/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.kolun.oxygenbus;

import android.content.Context;
import android.os.Bundle;
import android.os.RemoteException;
import android.util.Log;
import com.transsion.apiinvoke.invoke.ApiRequest;
import com.transsion.apiinvoke.invoke.ApiResponse;
import com.transsion.apiinvoke.invoke.api.ApiCallback;
import com.transsion.apiinvoke.invoke.api.ApiInterface;
import com.transsion.apiinvoke.invoke.api.ApiPublisher;
import com.transsion.apiinvoke.invoke.api.InvokeChannel;
import com.transsion.apiinvoke.ipc.APISubscribeCenter;
import com.transsion.apiinvoke.ipc.ICommonServiceInterface;
import com.transsion.apiinvoke.ipc.IRemoteAPIConnection;
import com.transsion.apiinvoke.ipc.IRemoteCallback;
import com.transsion.apiinvoke.ipc.ParcelPublishData;
import com.transsion.apiinvoke.ipc.ParcelRequest;
import com.transsion.apiinvoke.ipc.ParcelResponse;
import com.transsion.apiinvoke.subscribe.PublishData;
import com.transsion.apiinvoke.subscribe.Publisher;
import com.transsion.kolun.oxygenbus.IOxygenBusServer;
import com.transsion.kolun.oxygenbus.ISubscribeBusServer;
import com.transsion.kolun.oxygenbus.OxygenBusService;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicBoolean;

public class KolunIPCChannel
implements InvokeChannel {
    private static final String TAG = "RemoteIPCChannel";
    private Context mContext;
    private String mChannelName;
    private final RealRemoteConnection realRemoteConnection;
    private final RemoteApiPublisher mApiPublisher;
    private AtomicBoolean isConnected = new AtomicBoolean(false);
    private IOxygenBusServer oxygenBusServer;

    public KolunIPCChannel(Context context, String channelName) {
        this.mContext = context;
        this.mChannelName = channelName;
        this.realRemoteConnection = new RealRemoteConnection(this.mContext, this.mChannelName);
        this.mApiPublisher = new RemoteApiPublisher(context);
    }

    public boolean isInChannel(String apiServer) {
        this.oxygenBusServer = this.getOxygenBusServer();
        if (this.oxygenBusServer == null) {
            return false;
        }
        try {
            String channel = this.oxygenBusServer.findChannel(apiServer);
            if (channel == null || "".equals(channel)) {
                return false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    public synchronized void connectChannel() {
        Log.w((String)TAG, (String)"connectChannel");
        if (!this.isConnected.get()) {
            this.oxygenBusServer = this.getOxygenBusServer();
            if (this.oxygenBusServer == null) {
                return;
            }
            try {
                this.oxygenBusServer.bindRemoteServer(this.mChannelName, new Bundle(), (IRemoteAPIConnection)this.realRemoteConnection);
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
            this.isConnected.set(true);
        }
    }

    public void disconnectChannel() {
        this.oxygenBusServer = this.getOxygenBusServer();
        if (this.oxygenBusServer == null) {
            return;
        }
        try {
            this.oxygenBusServer.unRegisterService(this.mChannelName);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        this.isConnected.set(false);
    }

    public ApiInterface getApiInterface() {
        RealApiInterface apiInterface = this.realRemoteConnection.getRealApiInterface();
        if (apiInterface == null) {
            this.connectChannel();
        }
        return apiInterface;
    }

    private synchronized IOxygenBusServer getOxygenBusServer() {
        if (this.oxygenBusServer == null) {
            this.oxygenBusServer = OxygenBusService.getOxygenBusServer(this.mContext);
        }
        return this.oxygenBusServer;
    }

    public ApiPublisher getApiPublisher(Publisher.Host publisher) {
        return this.mApiPublisher;
    }

    private static class ApiInvokeRemoteCallbackStub
    extends IRemoteCallback.Stub {
        private ApiCallback mCallback;

        private ApiInvokeRemoteCallbackStub(ApiCallback callback) {
            this.mCallback = callback;
        }

        public void response(ParcelResponse result) throws RemoteException {
            if (this.mCallback != null) {
                this.mCallback.response(result.getResponse());
            }
        }
    }

    private static class RemoteCallbackWrapper
    extends IRemoteCallback.Stub {
        ParcelResponse mResult;

        private RemoteCallbackWrapper() {
        }

        public void response(ParcelResponse result) throws RemoteException {
            this.mResult = result;
        }
    }

    private static class RealApiInterface
    implements ApiInterface {
        private ICommonServiceInterface mServiceInterface;

        public RealApiInterface(ICommonServiceInterface serviceInterface) {
            this.mServiceInterface = serviceInterface;
        }

        public void apiInvokeAsync(ApiRequest request, ApiCallback callback) {
            block3: {
                if (this.mServiceInterface != null) {
                    try {
                        boolean bl = this.mServiceInterface.serviceCall(new ParcelRequest(request), (IRemoteCallback)new ApiInvokeRemoteCallbackStub(callback));
                    }
                    catch (Exception e) {
                        if (callback == null) break block3;
                        callback.response(ApiResponse.invokeRemoteError((String)request.getApiName(), (String)request.getApiMethod()));
                    }
                }
            }
        }

        public ApiResponse apiInvoke(ApiRequest request) {
            if (this.mServiceInterface != null) {
                try {
                    RemoteCallbackWrapper callbackWrapper = new RemoteCallbackWrapper();
                    boolean success = this.mServiceInterface.serviceCall(new ParcelRequest(request), (IRemoteCallback)callbackWrapper);
                    if (success) {
                        return callbackWrapper.mResult.getResponse();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return ApiResponse.knowError((String)request.getApiName(), (String)request.getApiMethod());
        }
    }

    private static class RealRemoteConnection
    extends IRemoteAPIConnection.Stub {
        private static final String TAG = "RealRemoteConnection";
        private String mChannelName;
        private RealApiInterface mRealApiInterface = null;

        public RealRemoteConnection(Context context, String channelName) {
            this.mChannelName = channelName;
        }

        public void onConnected(Bundle bundle, ICommonServiceInterface serviceInterface) throws RemoteException {
            ICommonServiceInterface commonServiceInterface = serviceInterface;
            this.mRealApiInterface = new RealApiInterface(commonServiceInterface);
        }

        public void onDisconnected(String apiName) throws RemoteException {
            this.mRealApiInterface = null;
        }

        public RealApiInterface getRealApiInterface() {
            return this.mRealApiInterface;
        }
    }

    private static class RemoteApiPublisher
    implements ApiPublisher {
        private Context mContext;

        public RemoteApiPublisher(Context context) {
            this.mContext = context;
        }

        public void publishData(Publisher publisher, Serializable data) {
            ISubscribeBusServer subscribeBusServer = OxygenBusService.getSubscribeServer(this.mContext);
            if (subscribeBusServer == null) {
                return;
            }
            APISubscribeCenter subscribeCenter = null;
            try {
                subscribeCenter = subscribeBusServer.getSubscribeCenter();
                if (subscribeCenter == null) {
                    Log.e((String)KolunIPCChannel.TAG, (String)"subscribeCenter == NULL");
                    return;
                }
                subscribeCenter.onPublishData(new ParcelPublishData(PublishData.create((Publisher)publisher, (Serializable)data)));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

