/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.kolun.oxygenbus;

import android.content.ContentProvider;
import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.os.Binder;
import android.os.IBinder;
import android.util.Log;
import com.transsion.kolun.oxygenbus.common.BinderCursor;
import com.transsion.kolun.oxygenbus.impl.IOxygenEventBusServer;
import com.transsion.kolun.oxygenbus.impl.OxygenBusServiceImpl;
import com.transsion.kolun.oxygenbus.impl.SubscribeBusServerImpl;

public class OxygenBusProvider
extends ContentProvider {
    public static final String AUTHORITY = "com.transsion.kolun.oxygenbus2.serviceBinder";
    public static final Uri CONTENT_URI = Uri.parse((String)"content://com.transsion.kolun.oxygenbus2.serviceBinder/binder");
    public static final String SERVICE_OXYGEN_BUS = "oxygenBusService";
    public static final String SERVICE_SUBSCRIBE = "subscribeService";
    public static final String SERVICE_EVENTBUS = "eventBusService";
    private static final String TAG = "OxygenBusProvider";

    public boolean onCreate() {
        return true;
    }

    public Cursor query(Uri uri, String[] projection, String selection, String[] selectionArgs, String sortOrder) {
        Binder binder;
        Context appContext = this.getContext().getApplicationContext();
        if (selectionArgs[0].equals(SERVICE_OXYGEN_BUS)) {
            binder = OxygenBusServiceImpl.get(appContext);
            Log.d((String)TAG, (String)"Query OxygenBusServiceImpl");
        } else if (selectionArgs[0].equals(SERVICE_SUBSCRIBE)) {
            binder = SubscribeBusServerImpl.get(appContext);
            Log.d((String)TAG, (String)"Query SubscribeBusServerImpl");
        } else if (selectionArgs[0].equals(SERVICE_EVENTBUS)) {
            binder = IOxygenEventBusServer.get(appContext);
            Log.d((String)TAG, (String)"Query IOxygenEventBusServer");
        } else {
            return null;
        }
        BinderCursor cursor = new BinderCursor(new String[]{"service"}, (IBinder)binder);
        return cursor;
    }

    public String getType(Uri uri) {
        return null;
    }

    public Uri insert(Uri uri, ContentValues values) {
        return null;
    }

    public int delete(Uri uri, String selection, String[] selectionArgs) {
        return 0;
    }

    public int update(Uri uri, ContentValues values, String selection, String[] selectionArgs) {
        return 0;
    }
}

