/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.kolun.oxygenbus;

import android.content.Context;
import android.database.Cursor;
import android.os.Bundle;
import android.os.IBinder;
import com.transsion.kolun.oxygenbus.IOxygenBusServer;
import com.transsion.kolun.oxygenbus.IOxygenEventBusServer;
import com.transsion.kolun.oxygenbus.ISubscribeBusServer;
import com.transsion.kolun.oxygenbus.OxygenBusProvider;
import com.transsion.kolun.oxygenbus.common.BinderCursor;

public class OxygenBusService {
    public static IOxygenBusServer getOxygenBusServer(Context context) {
        IBinder binder = OxygenBusService.getKolunServiceBinder(context, "oxygenBusService");
        if (binder == null) {
            return null;
        }
        return IOxygenBusServer.Stub.asInterface(binder);
    }

    public static ISubscribeBusServer getSubscribeServer(Context context) {
        IBinder binder = OxygenBusService.getKolunServiceBinder(context, "subscribeService");
        if (binder == null) {
            return null;
        }
        return ISubscribeBusServer.Stub.asInterface(binder);
    }

    public static IOxygenEventBusServer getKolunEventBus(Context context) {
        IBinder binder = OxygenBusService.getKolunServiceBinder(context, "eventBusService");
        if (binder == null) {
            return null;
        }
        return IOxygenEventBusServer.Stub.asInterface(binder);
    }

    public static IBinder getKolunServiceBinder(Context context, String serverName) {
        Cursor cursor = context.getContentResolver().query(OxygenBusProvider.CONTENT_URI, null, null, new String[]{serverName}, null);
        if (cursor == null) {
            return null;
        }
        return OxygenBusService.getServiceBinder(cursor);
    }

    private static IBinder getServiceBinder(Cursor cursor) {
        Bundle extras = cursor.getExtras();
        extras.setClassLoader(BinderCursor.BinderParcelable.class.getClassLoader());
        BinderCursor.BinderParcelable w = (BinderCursor.BinderParcelable)extras.getParcelable("binder");
        return w.mBinder;
    }
}

