/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.kolun.oxygenbus.common;

import android.app.ActivityManager;
import android.content.ComponentName;
import android.content.Context;
import android.content.pm.PackageManager;
import android.os.Process;
import android.os.RemoteException;
import android.util.Log;
import com.transsion.apiinvoke.IApiService;
import com.transsion.apiinvoke.channel.ApiChannel;
import com.transsion.apiinvoke.channel.LocalChannel;
import com.transsion.apiinvoke.common.router.ApiRouterManager;
import com.transsion.apiinvoke.common.router.ChannelEntity;
import com.transsion.apiinvoke.invoke.api.InvokeChannel;
import com.transsion.apiinvoke.ipc.APIPublisher;
import com.transsion.apiinvoke.ipc.APISubscribeCenter;
import com.transsion.apiinvoke.ipc.ParcelPublisher;
import com.transsion.apiinvoke.ipc.RemoteApiPublisherStub;
import com.transsion.apiinvoke.subscribe.OnSubscribeChangeListener;
import com.transsion.apiinvoke.subscribe.Publisher;
import com.transsion.apiinvoke.subscribe.SubscribeManager;
import com.transsion.kolun.oxygenbus.IOxygenBusServer;
import com.transsion.kolun.oxygenbus.ISubscribeBusServer;
import com.transsion.kolun.oxygenbus.KolunIPCChannel;
import com.transsion.kolun.oxygenbus.OxygenBusService;
import com.transsion.kolun.oxygenbus.common.ClassUtils;
import com.transsion.kolun.oxygenbus.kolunevent.SystemEventBus;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class KolunOxygenBusRegister {
    private static final String TAG = "ApiInvokeRegister";
    private static final String MANAGER_PACKAGE = "com.transsion.apiinvoke.routermap";
    private static String sProcessName;

    public static void init(Context context) {
        try {
            Set<String> set = ClassUtils.getFileNameByPackageName(context, MANAGER_PACKAGE);
            for (String packageClass : set) {
                ApiRouterManager.register((String)packageClass);
            }
            sProcessName = KolunOxygenBusRegister.getCurProcessName(context);
            ApiRouterManager.getInstance();
            ApiRouterManager.listRegisterServer();
            KolunOxygenBusRegister.serviceRegister(context);
            KolunOxygenBusRegister.registerRemoteIpcProxy(context);
            SystemEventBus.getInstance().registerEventBus(context);
            Log.d((String)TAG, (String)"init success ");
        }
        catch (PackageManager.NameNotFoundException | IOException | InterruptedException e) {
            e.printStackTrace();
        }
    }

    public static void registerChannel(Context appContext, final ChannelEntity entity, Class<IApiService>[] apis) {
        ApiChannel.ChannelCreator mChannelCreator = new ApiChannel.ChannelCreator(){

            public boolean shouldHandle(String channel) {
                return "DataCenter".equals(channel);
            }

            public InvokeChannel getChannel(String s) {
                return new LocalChannel(entity);
            }
        };
        ApiChannel.getInstance().addChannelCreator(mChannelCreator);
        ApiRouterManager.addNewChannel((ChannelEntity)entity);
        KolunOxygenBusRegister.registerSubscribe(appContext, entity.channelName);
        KolunOxygenBusRegister.registerServiceComponent(appContext, entity);
        if (apis != null && apis.length > 0) {
            for (Class<IApiService> api : apis) {
                ApiRouterManager.registerApi(api);
                Log.d((String)TAG, (String)("addDynamicChannel, registerApi " + api));
            }
        }
        ApiRouterManager.listRegisterServer();
    }

    public static void unRegisterChannel(Context appContext, String channelName) {
        IOxygenBusServer oxygenBusServer = OxygenBusService.getOxygenBusServer(appContext);
        if (oxygenBusServer == null) {
            return;
        }
        try {
            oxygenBusServer.unRegisterService(channelName);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void serviceRegister(Context context) {
        Map entityMap;
        Map map = entityMap = ApiRouterManager.getChannelMap();
        synchronized (map) {
            for (Map.Entry entityEntry : entityMap.entrySet()) {
                ChannelEntity entity = (ChannelEntity)entityEntry.getValue();
                KolunOxygenBusRegister.registerSubscribe(context, entity.channelName);
                if (!entity.autoConnect) continue;
                KolunOxygenBusRegister.registerServiceComponent(context, entity);
            }
        }
    }

    private static void registerSubscribe(Context appContext, String channelName) {
        ISubscribeBusServer subscribeServer = OxygenBusService.getSubscribeServer(appContext);
        if (subscribeServer == null) {
            return;
        }
        try {
            subscribeServer.registerSubscribeManager(sProcessName, channelName, (APIPublisher)new RemoteApiPublisherStub());
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    private static void registerServiceComponent(Context appContext, ChannelEntity entity) {
        IOxygenBusServer oxygenBusServer = OxygenBusService.getOxygenBusServer(appContext);
        if (oxygenBusServer == null) {
            return;
        }
        try {
            oxygenBusServer.registerService(entity.channelName, entity.channelService, new ComponentName(entity.packageName, entity.className));
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    private static void registerRemoteIpcProxy(Context context) {
        SubscribeManager.setGlobalSubscribeNotify((OnSubscribeChangeListener)new DataCenterSubscribeChangeListener(context));
        ApiChannel.getInstance().addChannelCreator((ApiChannel.ChannelCreator)new RemoteIPCChannelProxy(context));
    }

    private static String getCurProcessName(Context context) {
        int pid = Process.myPid();
        ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
        for (ActivityManager.RunningAppProcessInfo appProcess : activityManager.getRunningAppProcesses()) {
            if (appProcess.pid != pid) continue;
            return appProcess.processName;
        }
        return context.getPackageName();
    }

    private static class RemoteIPCChannelProxy
    implements ApiChannel.ChannelCreator {
        private Context mContext;
        private Map<String, KolunIPCChannel> remoteChannelMap = new ConcurrentHashMap<String, KolunIPCChannel>();

        public RemoteIPCChannelProxy(Context context) {
            this.mContext = context;
        }

        public boolean shouldHandle(String channelName) {
            IOxygenBusServer oxygenBusServer = OxygenBusService.getOxygenBusServer(this.mContext);
            if (oxygenBusServer == null) {
                return false;
            }
            try {
                return oxygenBusServer.isChannelRegistered(channelName);
            }
            catch (RemoteException e) {
                e.printStackTrace();
                return false;
            }
        }

        public synchronized InvokeChannel getChannel(String channelName) {
            KolunIPCChannel channel = this.remoteChannelMap.get(channelName);
            if (channel == null) {
                channel = new KolunIPCChannel(this.mContext, channelName);
                this.remoteChannelMap.put(channelName, channel);
            }
            if (channel.getApiInterface() == null) {
                channel.connectChannel();
            }
            Log.d((String)KolunOxygenBusRegister.TAG, (String)("RemoteIPCChannelProxy, getChannel connectChannel " + channelName));
            return channel;
        }
    }

    private static class DataCenterSubscribeChangeListener
    implements OnSubscribeChangeListener {
        private Context mContext;
        private String subscribeName;

        private DataCenterSubscribeChangeListener(Context context) {
            this.mContext = context;
            this.subscribeName = context.getPackageName() + Thread.currentThread().getId();
        }

        public void onSubscribe(Publisher publisher, int subscribeCount) {
            ISubscribeBusServer subscribeBusServer = OxygenBusService.getSubscribeServer(this.mContext);
            if (subscribeBusServer == null) {
                return;
            }
            try {
                APISubscribeCenter center = subscribeBusServer.getSubscribeCenter();
                if (center == null) {
                    Log.e((String)KolunOxygenBusRegister.TAG, (String)"DataCenterSubscribeChangeListener APISubscribeCenter is Null");
                    return;
                }
                center.onSubscribe(new ParcelPublisher(publisher), this.subscribeName, subscribeCount);
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
        }

        public void onUnSubscribe(Publisher publisher, int subscribeCount) {
            ISubscribeBusServer subscribeBusServer = OxygenBusService.getSubscribeServer(this.mContext);
            if (subscribeBusServer == null) {
                return;
            }
            try {
                APISubscribeCenter center = subscribeBusServer.getSubscribeCenter();
                if (center == null) {
                    Log.e((String)KolunOxygenBusRegister.TAG, (String)"DataCenterSubscribeChangeListener APISubscribeCenter is Null");
                    return;
                }
                center.onUnSubscribe(new ParcelPublisher(publisher), this.subscribeName, subscribeCount);
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
        }
    }
}

