/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.kolun.oxygenbus.impl;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.IBinder;
import android.os.RemoteException;
import android.util.Log;
import com.transsion.apiinvoke.invoke.ApiRequest;
import com.transsion.apiinvoke.invoke.ApiResponse;
import com.transsion.apiinvoke.invoke.api.ApiCallback;
import com.transsion.apiinvoke.ipc.ICommonServiceInterface;
import com.transsion.apiinvoke.ipc.IRemoteAPIConnection;
import com.transsion.apiinvoke.ipc.IRemoteCallback;
import com.transsion.apiinvoke.ipc.ParcelRequest;
import com.transsion.apiinvoke.ipc.ParcelResponse;
import com.transsion.kolun.oxygenbus.IOxygenBusServer;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class OxygenBusServiceImpl
extends IOxygenBusServer.Stub {
    private static final String REMOTE_SERVICE = "RemoteServer";
    private static final String TAG = "OxygenBusServiceImpl";
    private static final String APP_SERVICE_CHANNEL = "APPService";
    private static final ComponentName APP_SERVICE_COMPONENT = new ComponentName("com.transsion.kolun.aiservice", "com.transsion.kolun.aiservice.OxygenBusServer");
    private static final Map<String, ChannelBean> GLOBAL_ROUTER = new ConcurrentHashMap<String, ChannelBean>(8);
    private Context mAppContext;
    private CommonServiceInterfaceStub mServiceInterface;
    private static volatile OxygenBusServiceImpl instance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static OxygenBusServiceImpl get(Context appContext) {
        if (instance != null) return instance;
        Class<OxygenBusServiceImpl> clazz = OxygenBusServiceImpl.class;
        synchronized (OxygenBusServiceImpl.class) {
            if (instance != null) return instance;
            instance = new OxygenBusServiceImpl(appContext);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instance;
        }
    }

    private OxygenBusServiceImpl(Context context) {
        this.mAppContext = context;
        this.mServiceInterface = new CommonServiceInterfaceStub();
    }

    @Override
    public boolean bindRemoteServer(String channelName, Bundle extra, IRemoteAPIConnection callback) throws RemoteException {
        if (APP_SERVICE_CHANNEL.equals(channelName)) {
            this.onAppServiceConnect(callback);
            return true;
        }
        ComponentName component = OxygenBusServiceImpl.getComponent(channelName);
        if (APP_SERVICE_COMPONENT.equals((Object)component)) {
            this.onAppServiceConnect(callback);
            return true;
        }
        Log.w((String)TAG, (String)("bindRemoteServer " + channelName + " find component  " + component));
        if (component == null) {
            return false;
        }
        Intent intent = new Intent();
        ComponentName componentName = new ComponentName(component.getPackageName(), component.getClassName());
        intent.setComponent(componentName);
        boolean success = this.mAppContext.bindService(intent, (ServiceConnection)new ServiceConnectionWithCallback(channelName, callback), 1);
        Log.w((String)TAG, (String)("bindRemoteServer " + channelName + " success  " + success));
        return success;
    }

    @Override
    public boolean isChannelRegistered(String channelName) throws RemoteException {
        ChannelBean bean = GLOBAL_ROUTER.get(channelName);
        return bean != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String findChannel(String serverName) throws RemoteException {
        Map<String, ChannelBean> map = GLOBAL_ROUTER;
        synchronized (map) {
            for (Map.Entry<String, ChannelBean> entity : GLOBAL_ROUTER.entrySet()) {
                ChannelBean channelEntity = entity.getValue();
                if (channelEntity == null || channelEntity.channelService == null || channelEntity.channelService.length == 0) continue;
                for (String apis : channelEntity.channelService) {
                    if (!apis.equals(serverName)) continue;
                    return channelEntity.channelName;
                }
            }
        }
        return "";
    }

    @Override
    public boolean registerService(String channelName, String[] servers, ComponentName entity) throws RemoteException {
        GLOBAL_ROUTER.put(channelName, new ChannelBean(channelName, servers, entity));
        Log.w((String)TAG, (String)("registerService " + channelName + " entity " + entity.toString() + " GLOBAL_ROUTER " + GLOBAL_ROUTER.size()));
        return false;
    }

    @Override
    public void unRegisterService(String channelName) throws RemoteException {
        Log.w((String)TAG, (String)("unRegisterService " + channelName + " GLOBAL_ROUTER " + GLOBAL_ROUTER.size()));
        GLOBAL_ROUTER.remove(channelName);
    }

    private void onAppServiceConnect(IRemoteAPIConnection callback) throws RemoteException {
        Bundle bundle = new Bundle();
        bundle.putBinder(REMOTE_SERVICE, (IBinder)this);
        callback.onConnected(bundle, (ICommonServiceInterface)this.mServiceInterface);
    }

    private static ComponentName getComponent(String channelName) {
        ChannelBean bean = GLOBAL_ROUTER.get(channelName);
        return bean != null ? bean.component : null;
    }

    static {
        GLOBAL_ROUTER.put(APP_SERVICE_CHANNEL, new ChannelBean(APP_SERVICE_CHANNEL, new String[0], APP_SERVICE_COMPONENT));
    }

    private static class RemoteCallbackWrapper
    implements ApiCallback {
        private IRemoteCallback mCallback;

        private RemoteCallbackWrapper(IRemoteCallback callback) {
            this.mCallback = callback;
        }

        public void response(ApiResponse result) {
            try {
                if (this.mCallback != null) {
                    this.mCallback.response(new ParcelResponse(result));
                }
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
        }
    }

    private static class CommonServiceInterfaceStub
    extends ICommonServiceInterface.Stub {
        private CommonServiceInterfaceStub() {
        }

        public boolean serviceCall(ParcelRequest router, IRemoteCallback callback) throws RemoteException {
            try {
                ApiRequest request = router.getRequest();
                request.invokeAsync((ApiCallback)new RemoteCallbackWrapper(callback));
                return true;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                if (callback != null) {
                    callback.response(new ParcelResponse(ApiResponse.knowError((String)"", (String)"")));
                }
                return false;
            }
        }
    }

    private static class ChannelBean {
        public String channelName;
        public ComponentName component;
        public String[] channelService;

        public ChannelBean(String channelName, String[] channelService, ComponentName component) {
            this.channelName = channelName;
            this.component = component;
            this.channelService = channelService;
        }
    }

    private static final class ServiceConnectionWithCallback
    implements ServiceConnection {
        private IRemoteAPIConnection mCallback;
        private String mApiName;

        private ServiceConnectionWithCallback(String apiName, IRemoteAPIConnection callback) {
            this.mCallback = callback;
            this.mApiName = apiName;
        }

        public void onServiceConnected(ComponentName component, IBinder service) {
            if (this.mCallback != null) {
                Bundle bundle = new Bundle();
                try {
                    this.mCallback.onConnected(bundle, ICommonServiceInterface.Stub.asInterface((IBinder)service));
                    Log.i((String)OxygenBusServiceImpl.TAG, (String)("onServiceConnected mApiName " + this.mApiName));
                }
                catch (RemoteException e) {
                    e.printStackTrace();
                }
            }
        }

        public void onServiceDisconnected(ComponentName name) {
            if (this.mCallback != null) {
                try {
                    this.mCallback.onDisconnected(this.mApiName);
                    Log.i((String)OxygenBusServiceImpl.TAG, (String)("onServiceDisconnected mApiName " + this.mApiName));
                }
                catch (RemoteException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

