/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.kolun.oxygenbus.kolunevent;

import android.content.Context;
import android.os.RemoteException;
import com.transsion.kolun.common.eventbus.SimpleEventBus;
import com.transsion.kolun.oxygenbus.IOxygenEventBusServer;
import com.transsion.kolun.oxygenbus.OxygenBusService;
import com.transsion.kolun.oxygenbus.kolunevent.IKolunEventBus;
import com.transsion.kolun.oxygenbus.kolunevent.KolunEventWrap;

public class SystemEventBus {
    private IKolunEventBusStub kolunEvent = new IKolunEventBusStub();
    private static volatile SystemEventBus instance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SystemEventBus getInstance() {
        if (instance != null) return instance;
        Class<SystemEventBus> clazz = SystemEventBus.class;
        synchronized (SystemEventBus.class) {
            if (instance != null) return instance;
            instance = new SystemEventBus();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private SystemEventBus() {
    }

    public <T> boolean sendSystemEvent(Context context, String observedName, T event) {
        IOxygenEventBusServer eventBusServer = OxygenBusService.getKolunEventBus(context);
        if (eventBusServer != null) {
            try {
                eventBusServer.sendEventBus(observedName, new KolunEventWrap<T>(event));
                return true;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    public void registerEventBus(Context appContext) {
        IOxygenEventBusServer kolunEventBus = OxygenBusService.getKolunEventBus(appContext);
        if (kolunEventBus == null) {
            return;
        }
        try {
            kolunEventBus.registerEventBusClient(this.kolunEvent);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    private static class IKolunEventBusStub
    extends IKolunEventBus.Stub {
        private IKolunEventBusStub() {
        }

        @Override
        public void sendEvent(String observedName, KolunEventWrap kolunEvent) {
            try {
                SimpleEventBus.getDefault().post(observedName, (Object)kolunEvent);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }
}

