/*
 * Decompiled with CFR 0.152.
 */
package com.ts.lib.player.ui;

import android.content.Context;
import android.graphics.Point;
import android.net.Uri;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.TextureView;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.SeekBar;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.ts.lib.common.Logger;
import com.ts.lib.common.util.ToolUtils;
import com.ts.lib.common.util.Util;
import com.ts.lib.player.MediaDataSource;
import com.ts.lib.player.Player;
import com.ts.lib.player.TsPlayer;
import com.ts.lib.player.model.VideoSize;
import com.ts.lib.player.ui.ControlView;
import com.ts.lib.player.ui.PlayerManager;
import com.ts.lib.player.ui.R;

public abstract class PlayerView
extends FrameLayout
implements View.OnClickListener,
SeekBar.OnSeekBarChangeListener,
View.OnTouchListener,
Player,
ControlView,
Player.PlayerListener {
    public static final String TAG = "TS/view";
    protected Context mContext;
    protected MediaDataSource dataSource;
    public SeekBar progressBar;
    public ViewGroup textureViewContainer;
    public View displaySurface;
    public ImageView fullscreenButton;
    public TextView currentTimeTextView;
    public TextView totalTimeTextView;
    public ImageView startButton;
    protected int mScreenWidth;
    protected int mScreenHeight;
    public int state = -1;
    public int screen = 0;
    protected float mDownX;
    protected float mDownY;
    protected boolean mChangeVolume;
    protected boolean mChangePosition;
    protected boolean mChangeBrightness;
    protected long mGestureDownPosition;
    protected int mGestureDownVolume;
    protected float mGestureDownBrightness;
    protected long mSeekTimePosition;
    public static int backUpBufferState = -1;
    public static boolean WIFI_TIP_DIALOG_SHOWED = false;
    public ViewGroup topContainer;
    public ViewGroup bottomContainer;

    public PlayerView(@NonNull Context context) {
        this(context, null);
    }

    public PlayerView(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public PlayerView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        this(context, attrs, defStyleAttr, 0);
    }

    public PlayerView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init(context);
    }

    protected abstract int getLayoutId();

    protected void init(Context context) {
        View.inflate((Context)context, (int)this.getLayoutId(), (ViewGroup)this);
        this.mContext = context;
        this.startButton = (ImageView)this.findViewById(R.id.start);
        this.fullscreenButton = (ImageView)this.findViewById(R.id.fullscreen);
        this.progressBar = (SeekBar)this.findViewById(R.id.bottom_seek_progress);
        this.currentTimeTextView = (TextView)this.findViewById(R.id.current);
        this.totalTimeTextView = (TextView)this.findViewById(R.id.total);
        this.bottomContainer = (ViewGroup)this.findViewById(R.id.layout_bottom);
        this.textureViewContainer = (ViewGroup)this.findViewById(R.id.surface_container);
        this.topContainer = (ViewGroup)this.findViewById(R.id.layout_top);
        this.newViewIfNotFound(context);
        this.startButton.setOnClickListener((View.OnClickListener)this);
        this.fullscreenButton.setOnClickListener((View.OnClickListener)this);
        this.progressBar.setOnSeekBarChangeListener((SeekBar.OnSeekBarChangeListener)this);
        this.bottomContainer.setOnClickListener((View.OnClickListener)this);
        this.textureViewContainer.setOnClickListener((View.OnClickListener)this);
        this.textureViewContainer.setOnTouchListener((View.OnTouchListener)this);
        this.state = -1;
    }

    protected void newViewIfNotFound(Context context) {
        if (this.startButton == null) {
            this.startButton = new ImageView(context);
        }
        if (this.fullscreenButton == null) {
            this.fullscreenButton = new ImageView(context);
        }
        if (this.progressBar == null) {
            this.progressBar = new SeekBar(context);
        }
        if (this.currentTimeTextView == null) {
            this.currentTimeTextView = new TextView(context);
        }
        if (this.totalTimeTextView == null) {
            this.totalTimeTextView = new TextView(context);
        }
        if (this.bottomContainer == null) {
            this.bottomContainer = new LinearLayout(context);
        }
        if (this.textureViewContainer == null) {
            this.textureViewContainer = new FrameLayout(context);
        }
        if (this.topContainer == null) {
            this.topContainer = new RelativeLayout(context);
        }
    }

    public void onClick(View v) {
        int i = v.getId();
        if (i == R.id.start) {
            this.clickStart();
        } else if (i == R.id.fullscreen) {
            this.clickFullscreen();
        }
    }

    public boolean onTouch(View v, MotionEvent event) {
        float x = event.getX();
        float y = event.getY();
        int id2 = v.getId();
        if (id2 == R.id.surface_container) {
            switch (event.getAction()) {
                case 0: {
                    this.touchActionDown(x, y);
                    break;
                }
                case 2: {
                    this.touchActionMove(x, y);
                    break;
                }
                case 1: {
                    this.touchActionUp();
                }
            }
        }
        return false;
    }

    public void onProgressChanged(SeekBar seekBar, int progress, boolean fromUser) {
    }

    public void onStartTrackingTouch(SeekBar seekBar) {
    }

    public void onStopTrackingTouch(SeekBar seekBar) {
        TsPlayer player = PlayerManager.getInstance().getPlayer();
        if (player != null) {
            player.seekTo((long)seekBar.getProgress());
        }
    }

    protected void clickStart() {
        Logger.d((String)TAG, (String)"onClick start");
        TsPlayer player = PlayerManager.getInstance().getPlayer();
        if (player == null || this.dataSource == null) {
            Logger.w((String)TAG, (String)"\u8bf7\u8bbe\u7f6e--->MediaDataSource");
            return;
        }
        if (!(Util.isLocalFileUri((Uri)this.dataSource.playbackConfiguration.uri) || ToolUtils.isWifiConnected((Context)this.mContext) || WIFI_TIP_DIALOG_SHOWED)) {
            this.showWifiDialog();
            return;
        }
        this.setup(player);
        if (player.isPlaying()) {
            player.pause();
            this.onStatePause();
        } else {
            player.play();
            this.onStatePlaying();
        }
    }

    private void setup(TsPlayer player) {
        if (this.displaySurface == null) {
            PlayerManager.getInstance().setPlayerView(this);
            this.addDisplaySurface();
            player.addListener((Player.PlayerListener)this);
            player.setDataSource(this.dataSource);
            player.setVideoTextureView((TextureView)this.displaySurface);
        } else if (!PlayerManager.getInstance().isSameView(this.displaySurface.hashCode())) {
            player.clearVideoSurface();
            this.textureViewContainer.removeView(this.displaySurface);
            PlayerManager.getInstance().setPlayerView(this);
            this.addDisplaySurface();
            player.addListener((Player.PlayerListener)this);
            player.setDataSource(this.dataSource);
            player.setVideoTextureView((TextureView)this.displaySurface);
        }
    }

    private void addDisplaySurface() {
        if (this.displaySurface != null) {
            this.textureViewContainer.removeView(this.displaySurface);
        }
        this.displaySurface = new TextureView(this.mContext);
        PlayerManager.getInstance().setDisplayViewId(this.displaySurface.hashCode());
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-1, -1, 17);
        this.textureViewContainer.addView(this.displaySurface, (ViewGroup.LayoutParams)layoutParams);
    }

    protected void clickFullscreen() {
        Logger.d((String)TAG, (String)"onClick fullscreen");
    }

    protected void touchActionDown(float x, float y) {
    }

    protected void touchActionMove(float x, float y) {
    }

    protected void touchActionUp() {
    }

    public void onStatePlaying() {
        Logger.i((String)TAG, (String)("onStatePlaying  [" + this.hashCode() + "] "));
        if (this.state == 4) {
            Logger.d((String)TAG, (String)"onStatePlaying:STATE_PREPARED ");
        }
        this.state = 5;
        this.startProgressTimer();
    }

    public void onStatePause() {
        Logger.i((String)TAG, (String)("onStatePause  [" + this.hashCode() + "] "));
        this.state = 6;
        this.progressBar.setProgress(0);
        this.progressBar.setSecondaryProgress(0);
        this.startProgressTimer();
    }

    public void onStateError() {
        Logger.i((String)TAG, (String)("onStateError  [" + this.hashCode() + "] "));
        this.state = 8;
        this.cancelProgressTimer();
    }

    public void onStateAutoComplete() {
        Logger.i((String)TAG, (String)("onStateAutoComplete [" + this.hashCode() + "] "));
        this.state = 7;
    }

    public void cancelProgressTimer() {
    }

    public void onStateNormal() {
        Logger.i((String)TAG, (String)("onStateNormal  [" + this.hashCode() + "] "));
        this.state = 0;
    }

    public void onStatePreparing() {
        Logger.i((String)TAG, (String)("onStatePreparing  [" + this.hashCode() + "] "));
        this.state = 1;
    }

    public void onStatePreparingPlaying() {
        Logger.i((String)TAG, (String)("onStatePreparingPlaying  [" + this.hashCode() + "] "));
        this.state = 3;
    }

    public void onStatePreparingChangeUrl() {
        Logger.i((String)TAG, (String)("onStatePreparingChangeUrl  [" + this.hashCode() + "] "));
        this.state = 2;
    }

    public void startProgressTimer() {
    }

    public void setState(int state) {
        switch (state) {
            case 0: {
                this.onStateNormal();
                break;
            }
            case 1: {
                this.onStatePreparing();
                break;
            }
            case 3: {
                this.onStatePreparingPlaying();
                break;
            }
            case 2: {
                this.onStatePreparingChangeUrl();
                break;
            }
            case 5: {
                this.onStatePlaying();
                break;
            }
            case 6: {
                this.onStatePause();
                break;
            }
            case 8: {
                this.onStateError();
                break;
            }
            case 7: {
                this.onStateAutoComplete();
            }
        }
    }

    public void reset() {
    }

    public void showWifiDialog() {
    }

    public void changeUrl(MediaDataSource dataSource, long positionMs) {
    }

    public void onPrepared() {
        Logger.d((String)TAG, (String)"player--------->onPrepared");
        this.state = 4;
    }

    public void onCompletion() {
        Logger.d((String)TAG, (String)"player--------->onCompletion");
        this.onStateAutoComplete();
    }

    public void onVideoSizeChanged(VideoSize videoSize) {
        this.layoutByVideoRatio(videoSize);
    }

    private void layoutByVideoRatio(VideoSize videoSize) {
        Point displayModeSize = Util.getCurrentDisplayModeSize((Context)this.mContext);
        int containerWidth = this.textureViewContainer.getWidth();
        int containerHeight = this.textureViewContainer.getHeight();
        Point displaySize = Util.measureSizeByRatio((int)containerWidth, (int)containerHeight, (int)videoSize.width, (int)videoSize.height);
        Logger.d((String)("\u5c4f\u5e55\u5206\u8fa8\u7387-->" + displayModeSize + ",  video Container: " + containerWidth + "x" + containerHeight + " displaySize:" + videoSize));
        View view = this.displaySurface;
        if ((float)view.getWidth() / (float)view.getHeight() == (float)displaySize.x / (float)displaySize.y) {
            return;
        }
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(displaySize.x, displaySize.y, 17);
        view.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
    }

    public void onProgressChanged(Player.PositionInfo newPosition) {
        int durationMs = (int)newPosition.durationMs;
        if (this.progressBar.getMax() != durationMs) {
            this.progressBar.setMax(durationMs);
        }
        this.progressBar.setProgress((int)newPosition.currentPositionMs);
        this.progressBar.setSecondaryProgress((int)newPosition.bufferedPositionMs);
        this.currentTimeTextView.setText((CharSequence)newPosition.formatCurrentPositionElapsedTime());
        this.totalTimeTextView.setText((CharSequence)newPosition.formatDurationTime());
    }

    public void onInfo(int what, int extra) {
        Logger.d((String)TAG, (String)("onInfo what - " + what + " extra - " + extra));
        if (what == 3) {
            Logger.i((String)TAG, (String)"onInfo-->MEDIA_INFO_VIDEO_RENDERING_START");
            this.onStatePlaying();
        } else if (what == 701) {
            Logger.i((String)TAG, (String)"onInfo-->MEDIA_INFO_BUFFERING_START");
            backUpBufferState = this.state;
            this.setState(3);
        } else if (what == 702) {
            Logger.i((String)TAG, (String)"onInfo-->MEDIA_INFO_BUFFERING_END");
            if (backUpBufferState != -1) {
                this.setState(backUpBufferState);
                backUpBufferState = -1;
            }
        }
    }

    public void onError(int what, String extra) {
        super.onError(what, extra);
    }

    public void setDataSource(@NonNull MediaDataSource dataSource) {
        this.dataSource = dataSource;
    }

    public void addListener(Player.PlayerListener listener) {
        PlayerManager.getInstance().getPlayer().addListener((Player.PlayerListener)this);
    }

    public void removeListener(Player.PlayerListener listener) {
        PlayerManager.getInstance().getPlayer().removeListener((Player.PlayerListener)this);
    }

    public void prepare() {
        PlayerManager.getInstance().getPlayer().prepare();
    }

    public void play() {
        PlayerManager.getInstance().getPlayer().play();
    }

    public void setPlayWhenReady(boolean playWhenReady) {
        PlayerManager.getInstance().getPlayer().setPlayWhenReady(playWhenReady);
    }

    public boolean getPlayWhenReady() {
        return PlayerManager.getInstance().getPlayer().getPlayWhenReady();
    }

    public boolean isPlaying() {
        return PlayerManager.getInstance().getPlayer().isPlaying();
    }

    public void pause() {
        PlayerManager.getInstance().getPlayer().pause();
    }

    public void stop() {
        PlayerManager.getInstance().getPlayer().stop();
    }

    public long getCurrentPosition() {
        return PlayerManager.getInstance().getPlayer().getCurrentPosition();
    }

    public long getBufferedPosition() {
        return PlayerManager.getInstance().getPlayer().getBufferedPosition();
    }

    public long getDuration() {
        return PlayerManager.getInstance().getPlayer().getDuration();
    }

    public void setRepeatMode(int repeatMode) {
        PlayerManager.getInstance().getPlayer().setRepeatMode(repeatMode);
    }

    public int getRepeatMode() {
        return PlayerManager.getInstance().getPlayer().getRepeatMode();
    }

    public void setSeekType(int type) {
        PlayerManager.getInstance().getPlayer().setSeekType(type);
    }

    public void seekTo(long positionMs) {
        PlayerManager.getInstance().getPlayer().seekTo(positionMs);
    }

    public void setVolume(float vol) {
        PlayerManager.getInstance().getPlayer().setVolume(vol);
    }

    public float getVolume() {
        return PlayerManager.getInstance().getPlayer().getVolume();
    }

    public void setSpeed(float speed) {
        PlayerManager.getInstance().getPlayer().setSpeed(speed);
    }

    public float getSpeed() {
        return PlayerManager.getInstance().getPlayer().getSpeed();
    }

    public int getPlaybackState() {
        return PlayerManager.getInstance().getPlayer().getPlaybackState();
    }

    public void release() {
    }
}

