/*
 * Decompiled with CFR 0.152.
 */
package com.ts.lib.player.ui;

import android.app.AlertDialog;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentFilter;
import android.util.AttributeSet;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.PopupWindow;
import android.widget.ProgressBar;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.ts.lib.common.Logger;
import com.ts.lib.player.MediaDataSource;
import com.ts.lib.player.ui.PlayerView;
import com.ts.lib.player.ui.R;
import java.text.SimpleDateFormat;
import java.util.Date;

public class TsStyledPlayerView
extends PlayerView {
    public static long LAST_GET_BATTERYLEVEL_TIME = 0L;
    public static int LAST_GET_BATTERYLEVEL_PERCENT = 70;
    public ImageView backButton;
    public ProgressBar bottomProgressBar;
    public ProgressBar loadingProgressBar;
    public TextView titleTextView;
    public ImageView posterImageView;
    public ImageView tinyBackImageView;
    public LinearLayout batteryTimeLayout;
    public ImageView batteryLevel;
    public TextView videoCurrentTime;
    public TextView replayTextView;
    public TextView clarity;
    public PopupWindow clarityPopWindow;
    public TextView mRetryBtn;
    public LinearLayout mRetryLayout;
    protected GestureDetector gestureDetector = new GestureDetector(this.getContext().getApplicationContext(), (GestureDetector.OnGestureListener)new GestureDetector.SimpleOnGestureListener(){

        public boolean onDoubleTap(MotionEvent e) {
            if (TsStyledPlayerView.this.state == 5 || TsStyledPlayerView.this.state == 6) {
                Logger.d((String)"TS/view", (String)("doublClick [" + ((Object)((Object)this)).hashCode() + "] "));
                TsStyledPlayerView.this.startButton.performClick();
            }
            return super.onDoubleTap(e);
        }

        public boolean onSingleTapConfirmed(MotionEvent e) {
            if (!TsStyledPlayerView.this.mChangePosition && !TsStyledPlayerView.this.mChangeVolume) {
                TsStyledPlayerView.this.onClickUiToggle();
            }
            return super.onSingleTapConfirmed(e);
        }

        public void onLongPress(MotionEvent e) {
            super.onLongPress(e);
        }
    });
    public BroadcastReceiver battertReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            if ("android.intent.action.BATTERY_CHANGED".equals(action)) {
                int percent;
                int level = intent.getIntExtra("level", 0);
                int scale = intent.getIntExtra("scale", 100);
                LAST_GET_BATTERYLEVEL_PERCENT = percent = level * 100 / scale;
                TsStyledPlayerView.this.setBatteryLevel();
                try {
                    TsStyledPlayerView.this.mContext.unregisterReceiver(TsStyledPlayerView.this.battertReceiver);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    };

    public TsStyledPlayerView(@NonNull Context context) {
        this(context, null);
    }

    public TsStyledPlayerView(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public TsStyledPlayerView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        this(context, attrs, defStyleAttr, 0);
    }

    public TsStyledPlayerView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
    }

    @Override
    public int getLayoutId() {
        return R.layout.ts_styled_player_view;
    }

    @Override
    public void init(Context context) {
        super.init(context);
        this.batteryTimeLayout = (LinearLayout)this.findViewById(R.id.battery_time_layout);
        this.bottomProgressBar = (ProgressBar)this.findViewById(R.id.bottom_progress);
        this.titleTextView = (TextView)this.findViewById(R.id.title);
        this.backButton = (ImageView)this.findViewById(R.id.back);
        this.posterImageView = (ImageView)this.findViewById(R.id.poster);
        this.loadingProgressBar = (ProgressBar)this.findViewById(R.id.loading);
        this.tinyBackImageView = (ImageView)this.findViewById(R.id.back_tiny);
        this.batteryLevel = (ImageView)this.findViewById(R.id.battery_level);
        this.videoCurrentTime = (TextView)this.findViewById(R.id.video_current_time);
        this.replayTextView = (TextView)this.findViewById(R.id.replay_text);
        this.clarity = (TextView)this.findViewById(R.id.clarity);
        this.mRetryBtn = (TextView)this.findViewById(R.id.retry_btn);
        this.mRetryLayout = (LinearLayout)this.findViewById(R.id.retry_layout);
        if (this.batteryTimeLayout == null) {
            this.batteryTimeLayout = new LinearLayout(context);
        }
        if (this.bottomProgressBar == null) {
            this.bottomProgressBar = new ProgressBar(context);
        }
        if (this.titleTextView == null) {
            this.titleTextView = new TextView(context);
        }
        if (this.backButton == null) {
            this.backButton = new ImageView(context);
        }
        if (this.posterImageView == null) {
            this.posterImageView = new ImageView(context);
        }
        if (this.loadingProgressBar == null) {
            this.loadingProgressBar = new ProgressBar(context);
        }
        if (this.tinyBackImageView == null) {
            this.tinyBackImageView = new ImageView(context);
        }
        if (this.batteryLevel == null) {
            this.batteryLevel = new ImageView(context);
        }
        if (this.videoCurrentTime == null) {
            this.videoCurrentTime = new TextView(context);
        }
        if (this.replayTextView == null) {
            this.replayTextView = new TextView(context);
        }
        if (this.clarity == null) {
            this.clarity = new TextView(context);
        }
        if (this.mRetryBtn == null) {
            this.mRetryBtn = new TextView(context);
        }
        if (this.mRetryLayout == null) {
            this.mRetryLayout = new LinearLayout(context);
        }
        this.posterImageView.setOnClickListener((View.OnClickListener)this);
        this.backButton.setOnClickListener((View.OnClickListener)this);
        this.tinyBackImageView.setOnClickListener((View.OnClickListener)this);
        this.clarity.setOnClickListener((View.OnClickListener)this);
        this.mRetryBtn.setOnClickListener((View.OnClickListener)this);
    }

    @Override
    public void setDataSource(@NonNull MediaDataSource dataSource) {
        super.setDataSource(dataSource);
        this.titleTextView.setText((CharSequence)dataSource.subtitleConfig.topTitle);
    }

    @Override
    public void onClick(View v) {
        super.onClick(v);
        int i = v.getId();
    }

    @Override
    public boolean onTouch(View v, MotionEvent event) {
        int id2 = v.getId();
        if (id2 == R.id.surface_container) {
            switch (event.getAction()) {
                case 0: 
                case 2: {
                    break;
                }
                case 1: {
                    this.startDismissControlViewTimer();
                    if (!this.mChangePosition) break;
                    long duration = this.getDuration();
                    int progress = (int)(this.mSeekTimePosition * 100L / (duration == 0L ? 1L : duration));
                    this.bottomProgressBar.setProgress(progress);
                }
            }
            this.gestureDetector.onTouchEvent(event);
        } else if (id2 == R.id.bottom_seek_progress) {
            switch (event.getAction()) {
                case 0: {
                    this.cancelDismissControlViewTimer();
                    break;
                }
                case 1: {
                    this.startDismissControlViewTimer();
                }
            }
        }
        return super.onTouch(v, event);
    }

    public void onClickUiToggle() {
        if (this.bottomContainer.getVisibility() != 0) {
            this.setSystemTimeAndBattery();
        }
        if (this.state == 1) {
            this.changeUiToPreparing();
            if (this.bottomContainer.getVisibility() != 0) {
                this.setSystemTimeAndBattery();
            }
        } else if (this.state == 5) {
            if (this.bottomContainer.getVisibility() == 0) {
                this.changeUiToPlayingClear();
            } else {
                this.changeUiToPlayingShow();
            }
        } else if (this.state == 6) {
            if (this.bottomContainer.getVisibility() == 0) {
                this.changeUiToPauseClear();
            } else {
                this.changeUiToPauseShow();
            }
        }
    }

    @Override
    public void reset() {
        super.reset();
    }

    @Override
    public void showWifiDialog() {
        super.showWifiDialog();
        AlertDialog.Builder builder = new AlertDialog.Builder(this.mContext);
        builder.setMessage((CharSequence)this.getResources().getString(R.string.tips_not_wifi));
        builder.setPositiveButton((CharSequence)this.getResources().getString(R.string.tips_not_wifi_confirm), (dialog, which) -> {
            dialog.dismiss();
            WIFI_TIP_DIALOG_SHOWED = true;
            if (this.state == 6) {
                this.startButton.performClick();
            } else {
                this.clickStart();
            }
        });
        builder.setNegativeButton((CharSequence)this.getResources().getString(R.string.tips_not_wifi_cancel), (dialog, which) -> dialog.dismiss());
        builder.setOnCancelListener(new DialogInterface.OnCancelListener(){

            public void onCancel(DialogInterface dialog) {
                dialog.dismiss();
            }
        });
        builder.create().show();
    }

    @Override
    public void onStateNormal() {
        super.onStateNormal();
        this.changeUiToNormal();
    }

    @Override
    public void onStatePreparing() {
        super.onStatePreparing();
        this.changeUiToPreparing();
    }

    @Override
    public void onStatePreparingPlaying() {
        super.onStatePreparingPlaying();
        this.changeUIToPreparingPlaying();
    }

    @Override
    public void onStatePreparingChangeUrl() {
        super.onStatePreparingChangeUrl();
        this.changeUIToPreparingChangeUrl();
    }

    @Override
    public void onStatePlaying() {
        super.onStatePlaying();
        this.changeUiToPlayingClear();
    }

    @Override
    public void onStatePause() {
        super.onStatePause();
        this.changeUiToPauseShow();
    }

    @Override
    public void onStateError() {
        super.onStateError();
        this.changeUiToError();
    }

    @Override
    public void onStateAutoComplete() {
        super.onStateAutoComplete();
        this.changeUiToComplete();
    }

    public void changeUiToNormal() {
        switch (this.screen) {
            case 0: 
            case 1: {
                this.setAllControlsVisiblity(0, 4, 0, 4, 0, 4, 4);
                this.updateStartImage();
                break;
            }
        }
    }

    public void changeUiToPreparing() {
        switch (this.screen) {
            case 0: 
            case 1: {
                this.setAllControlsVisiblity(4, 4, 4, 0, 0, 4, 4);
                this.updateStartImage();
                break;
            }
        }
    }

    public void changeUIToPreparingPlaying() {
        switch (this.screen) {
            case 0: 
            case 1: {
                this.setAllControlsVisiblity(0, 0, 4, 0, 4, 4, 4);
                this.updateStartImage();
                break;
            }
        }
    }

    public void changeUIToPreparingChangeUrl() {
        switch (this.screen) {
            case 0: 
            case 1: {
                this.setAllControlsVisiblity(4, 4, 4, 0, 0, 4, 4);
                this.updateStartImage();
                break;
            }
        }
    }

    public void changeUiToPlayingShow() {
        switch (this.screen) {
            case 0: 
            case 1: {
                this.setAllControlsVisiblity(0, 0, 0, 4, 4, 4, 4);
                this.updateStartImage();
                break;
            }
        }
    }

    public void changeUiToPlayingClear() {
        switch (this.screen) {
            case 0: 
            case 1: {
                this.setAllControlsVisiblity(4, 4, 4, 4, 4, 0, 4);
                break;
            }
        }
    }

    public void changeUiToPauseShow() {
        switch (this.screen) {
            case 0: 
            case 1: {
                this.setAllControlsVisiblity(0, 0, 0, 4, 0, 4, 4);
                this.updateStartImage();
                break;
            }
        }
    }

    public void changeUiToPauseClear() {
        switch (this.screen) {
            case 0: 
            case 1: {
                this.setAllControlsVisiblity(4, 4, 4, 4, 4, 0, 4);
                break;
            }
        }
    }

    public void changeUiToComplete() {
        switch (this.screen) {
            case 0: 
            case 1: {
                this.setAllControlsVisiblity(0, 4, 0, 4, 0, 4, 4);
                this.updateStartImage();
                this.posterImageView.setVisibility(8);
                break;
            }
        }
    }

    public void changeUiToError() {
        switch (this.screen) {
            case 0: {
                this.setAllControlsVisiblity(4, 4, 0, 4, 4, 4, 0);
                this.updateStartImage();
                break;
            }
            case 1: {
                this.setAllControlsVisiblity(0, 4, 0, 4, 4, 4, 0);
                this.updateStartImage();
                break;
            }
        }
    }

    public void setAllControlsVisiblity(int topCon, int bottomCon, int startBtn, int loadingPro, int posterImg, int bottomPro, int retryLayout) {
        this.topContainer.setVisibility(topCon);
        this.bottomContainer.setVisibility(bottomCon);
        this.startButton.setVisibility(startBtn);
        this.loadingProgressBar.setVisibility(loadingPro);
        this.posterImageView.setVisibility(posterImg);
        this.bottomProgressBar.setVisibility(bottomPro);
        this.mRetryLayout.setVisibility(retryLayout);
    }

    public void updateStartImage() {
        if (this.state == 5) {
            this.startButton.setVisibility(0);
            this.startButton.setImageResource(R.drawable.jz_click_pause_selector);
            this.replayTextView.setVisibility(8);
        } else if (this.state == 8) {
            this.startButton.setVisibility(4);
            this.replayTextView.setVisibility(8);
        } else if (this.state == 7) {
            this.startButton.setVisibility(0);
            this.startButton.setImageResource(R.drawable.jz_click_replay_selector);
            this.replayTextView.setVisibility(0);
        } else {
            this.startButton.setImageResource(R.drawable.jz_click_play_selector);
            this.replayTextView.setVisibility(8);
        }
    }

    public void startDismissControlViewTimer() {
        this.cancelDismissControlViewTimer();
    }

    public void cancelDismissControlViewTimer() {
    }

    public void setSystemTimeAndBattery() {
        SimpleDateFormat dateFormater = new SimpleDateFormat("HH:mm");
        Date date = new Date();
        this.videoCurrentTime.setText((CharSequence)dateFormater.format(date));
        if (System.currentTimeMillis() - LAST_GET_BATTERYLEVEL_TIME > 30000L) {
            LAST_GET_BATTERYLEVEL_TIME = System.currentTimeMillis();
            this.mContext.registerReceiver(this.battertReceiver, new IntentFilter("android.intent.action.BATTERY_CHANGED"));
        } else {
            this.setBatteryLevel();
        }
    }

    public void setBatteryLevel() {
        int percent = LAST_GET_BATTERYLEVEL_PERCENT;
        if (percent < 15) {
            this.batteryLevel.setBackgroundResource(R.drawable.jz_battery_level_10);
        } else if (percent >= 15 && percent < 40) {
            this.batteryLevel.setBackgroundResource(R.drawable.jz_battery_level_30);
        } else if (percent >= 40 && percent < 60) {
            this.batteryLevel.setBackgroundResource(R.drawable.jz_battery_level_50);
        } else if (percent >= 60 && percent < 80) {
            this.batteryLevel.setBackgroundResource(R.drawable.jz_battery_level_70);
        } else if (percent >= 80 && percent < 95) {
            this.batteryLevel.setBackgroundResource(R.drawable.jz_battery_level_90);
        } else if (percent >= 95 && percent <= 100) {
            this.batteryLevel.setBackgroundResource(R.drawable.jz_battery_level_100);
        }
    }
}

