/*
 * Decompiled with CFR 0.152.
 */
package com.ts.lib.player.ui;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.View;
import android.widget.FrameLayout;
import androidx.annotation.Nullable;
import com.ts.lib.player.ui.R;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

public final class AspectRatioFrameLayout
extends FrameLayout {
    public static final int RESIZE_MODE_FIT = 0;
    public static final int RESIZE_MODE_FIXED_WIDTH = 1;
    public static final int RESIZE_MODE_FIXED_HEIGHT = 2;
    public static final int RESIZE_MODE_FILL = 3;
    public static final int RESIZE_MODE_ZOOM = 4;
    private static final float MAX_ASPECT_RATIO_DEFORMATION_FRACTION = 0.01f;
    private final AspectRatioUpdateDispatcher aspectRatioUpdateDispatcher;
    @Nullable
    private AspectRatioListener aspectRatioListener;
    private float videoAspectRatio;
    private int resizeMode = 0;

    public AspectRatioFrameLayout(Context context) {
        this(context, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AspectRatioFrameLayout(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        if (attrs != null) {
            TypedArray a = context.getTheme().obtainStyledAttributes(attrs, R.styleable.AspectRatioFrameLayout, 0, 0);
            try {
                this.resizeMode = a.getInt(R.styleable.AspectRatioFrameLayout_resize_mode, 0);
            }
            finally {
                a.recycle();
            }
        }
        this.aspectRatioUpdateDispatcher = new AspectRatioUpdateDispatcher();
    }

    public void setAspectRatio(float widthHeightRatio) {
        if (this.videoAspectRatio != widthHeightRatio) {
            this.videoAspectRatio = widthHeightRatio;
            this.requestLayout();
        }
    }

    public void setAspectRatioListener(@Nullable AspectRatioListener listener) {
        this.aspectRatioListener = listener;
    }

    public int getResizeMode() {
        return this.resizeMode;
    }

    public void setResizeMode(int resizeMode) {
        if (this.resizeMode != resizeMode) {
            this.resizeMode = resizeMode;
            this.requestLayout();
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int height;
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        if (this.videoAspectRatio <= 0.0f) {
            return;
        }
        int width = this.getMeasuredWidth();
        float viewAspectRatio = (float)width / (float)(height = this.getMeasuredHeight());
        float aspectDeformation = this.videoAspectRatio / viewAspectRatio - 1.0f;
        if (Math.abs(aspectDeformation) <= 0.01f) {
            this.aspectRatioUpdateDispatcher.scheduleUpdate(this.videoAspectRatio, viewAspectRatio, false);
            return;
        }
        switch (this.resizeMode) {
            case 1: {
                height = (int)((float)width / this.videoAspectRatio);
                break;
            }
            case 2: {
                width = (int)((float)height * this.videoAspectRatio);
                break;
            }
            case 4: {
                if (aspectDeformation > 0.0f) {
                    width = (int)((float)height * this.videoAspectRatio);
                    break;
                }
                height = (int)((float)width / this.videoAspectRatio);
                break;
            }
            case 0: {
                if (aspectDeformation > 0.0f) {
                    height = (int)((float)width / this.videoAspectRatio);
                    break;
                }
                width = (int)((float)height * this.videoAspectRatio);
                break;
            }
        }
        this.aspectRatioUpdateDispatcher.scheduleUpdate(this.videoAspectRatio, viewAspectRatio, true);
        super.onMeasure(View.MeasureSpec.makeMeasureSpec((int)width, (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)height, (int)0x40000000));
    }

    private final class AspectRatioUpdateDispatcher
    implements Runnable {
        private float targetAspectRatio;
        private float naturalAspectRatio;
        private boolean aspectRatioMismatch;
        private boolean isScheduled;

        private AspectRatioUpdateDispatcher() {
        }

        public void scheduleUpdate(float targetAspectRatio, float naturalAspectRatio, boolean aspectRatioMismatch) {
            this.targetAspectRatio = targetAspectRatio;
            this.naturalAspectRatio = naturalAspectRatio;
            this.aspectRatioMismatch = aspectRatioMismatch;
            if (!this.isScheduled) {
                this.isScheduled = true;
                AspectRatioFrameLayout.this.post(this);
            }
        }

        @Override
        public void run() {
            this.isScheduled = false;
            if (AspectRatioFrameLayout.this.aspectRatioListener == null) {
                return;
            }
            AspectRatioFrameLayout.this.aspectRatioListener.onAspectRatioUpdated(this.targetAspectRatio, this.naturalAspectRatio, this.aspectRatioMismatch);
        }
    }

    @Documented
    @Retention(value=RetentionPolicy.SOURCE)
    @Target(value={ElementType.TYPE_USE})
    public static @interface ResizeMode {
    }

    public static interface AspectRatioListener {
        public void onAspectRatioUpdated(float var1, float var2, boolean var3);
    }
}

