package com.ts.lib.player.ui;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

import androidx.annotation.IntDef;

/**
 * 播放view状态控制
 *
 * @author 💎 Li Junchao
 */
public interface ControlView
{
    int SCREEN_NORMAL = 0;
    int SCREEN_FULLSCREEN = 1;
    int SCREEN_TINY = 2;


   int STATE_IDLE = -1;
   int STATE_NORMAL = 0;
   int STATE_PREPARING = 1;
   int STATE_PREPARING_CHANGE_URL = 2;
   int STATE_PREPARING_PLAYING = 3;
   int STATE_PREPARED = 4;
   int STATE_PLAYING = 5;
   int STATE_PAUSE = 6;
   int STATE_AUTO_COMPLETE = 7;
   int STATE_ERROR = 8;

    @Documented
    @Retention(RetentionPolicy.SOURCE)
    @Target({ElementType.FIELD, ElementType.METHOD, ElementType.PARAMETER, ElementType.LOCAL_VARIABLE})
    @IntDef({STATE_IDLE, STATE_NORMAL, STATE_PREPARING, STATE_PREPARING_CHANGE_URL,
            STATE_PREPARING_PLAYING, STATE_PREPARED, STATE_PLAYING, STATE_PAUSE, STATE_AUTO_COMPLETE, STATE_ERROR})
    @interface ViewState {}
}
