package com.ts.lib.player.ui;

import android.content.Context;

import com.ts.lib.player.TsPlayer;

/**
 * 全局播放器manager
 *
 * @author 💎 Li Junchao
 */
public class PlayerManager implements Manager
{
    private TsPlayer player;

    private int displayViewId = Integer.MIN_VALUE;

    private PlayerView playerView;

    private PlayerManager()
    {}

    @Override
    public void createPlayer()
    {

    }

    @Override
    public void setPlayer(TsPlayer player)
    {
        this.player = player;
    }

    @Override
    public TsPlayer getPlayer()
    {
        return player;
    }

    public boolean isSameView(int viewId)
    {
        return displayViewId == viewId;
    }

    public void setDisplayViewId(int displayViewId)
    {
        this.displayViewId = displayViewId;
    }

    public PlayerView getPlayerView()
    {
        return playerView;
    }

    public void setPlayerView(PlayerView playerView)
    {
        synchronized (this) {
            this.playerView = playerView;
        }
    }

    @Override
    public void release()
    {
        if (player != null) {
            player.release();
            player = null;
        }

        displayViewId = Integer.MIN_VALUE;

        synchronized (this) {
            this.playerView = null;
        }
    }

    public static PlayerManager getInstance()
    {
        return PlayerManagerHolder.sInstance;
    }

    private static class PlayerManagerHolder
    {
        private static final PlayerManager sInstance = new PlayerManager();
    }

    public final static class PlayerFactory
    {
        public TsPlayer createPlayer(Context context)
        {
            return null;
        }
    }
}
