/*
 * Decompiled with CFR 0.152.
 */
package com.ts.lib.player.ui;

import android.content.Context;
import android.graphics.Point;
import android.net.Uri;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.TextureView;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.SeekBar;
import android.widget.TextView;
import android.widget.Toast;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.ts.lib.common.Logger;
import com.ts.lib.common.util.ToolUtils;
import com.ts.lib.common.util.Util;
import com.ts.lib.player.MediaDataSource;
import com.ts.lib.player.Player;
import com.ts.lib.player.TsPlayer;
import com.ts.lib.player.model.VideoSize;
import com.ts.lib.player.ui.ControlView;
import com.ts.lib.player.ui.PlayerManager;
import com.ts.lib.player.ui.R;

public abstract class PlayerView
extends FrameLayout
implements View.OnClickListener,
SeekBar.OnSeekBarChangeListener,
View.OnTouchListener,
Player,
ControlView,
Player.PlayerListener {
    public static final String TAG = "TS/view";
    protected Context mContext;
    protected MediaDataSource dataSource;
    public SeekBar progressBar;
    public ViewGroup textureViewContainer;
    public View displaySurface;
    public ImageView fullscreenButton;
    public TextView currentTimeTextView;
    public TextView totalTimeTextView;
    public ImageView startButton;
    protected int mScreenWidth;
    protected int mScreenHeight;
    public int state = -1;
    public int screen = 0;
    protected float mDownX;
    protected float mDownY;
    protected boolean mChangeVolume;
    protected boolean mChangePosition;
    protected boolean mChangeBrightness;
    protected long mGestureDownPosition;
    protected int mGestureDownVolume;
    protected float mGestureDownBrightness;
    protected long mSeekTimePosition;
    public static int backUpBufferState = -1;
    public static boolean WIFI_TIP_DIALOG_SHOWED = false;
    public ViewGroup topContainer;
    public ViewGroup bottomContainer;

    public PlayerView(@NonNull Context context) {
        this(context, null);
    }

    public PlayerView(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public PlayerView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        this(context, attrs, defStyleAttr, 0);
    }

    public PlayerView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init(context);
    }

    protected abstract int getLayoutId();

    protected void init(Context context) {
        View.inflate((Context)context, (int)this.getLayoutId(), (ViewGroup)this);
        this.mContext = context;
        this.startButton = (ImageView)this.findViewById(R.id.start);
        this.fullscreenButton = (ImageView)this.findViewById(R.id.fullscreen);
        this.progressBar = (SeekBar)this.findViewById(R.id.bottom_seek_progress);
        this.currentTimeTextView = (TextView)this.findViewById(R.id.current);
        this.totalTimeTextView = (TextView)this.findViewById(R.id.total);
        this.bottomContainer = (ViewGroup)this.findViewById(R.id.layout_bottom);
        this.textureViewContainer = (ViewGroup)this.findViewById(R.id.surface_container);
        this.topContainer = (ViewGroup)this.findViewById(R.id.layout_top);
        this.newViewIfNotFound(context);
        this.progressBar.setFocusable(false);
        this.progressBar.setEnabled(false);
        this.startButton.setOnClickListener((View.OnClickListener)this);
        this.fullscreenButton.setOnClickListener((View.OnClickListener)this);
        this.progressBar.setOnSeekBarChangeListener((SeekBar.OnSeekBarChangeListener)this);
        this.bottomContainer.setOnClickListener((View.OnClickListener)this);
        this.textureViewContainer.setOnClickListener((View.OnClickListener)this);
        this.textureViewContainer.setOnTouchListener((View.OnTouchListener)this);
        this.state = -1;
    }

    protected void newViewIfNotFound(Context context) {
        if (this.startButton == null) {
            this.startButton = new ImageView(context);
        }
        if (this.fullscreenButton == null) {
            this.fullscreenButton = new ImageView(context);
        }
        if (this.progressBar == null) {
            this.progressBar = new SeekBar(context);
        }
        if (this.currentTimeTextView == null) {
            this.currentTimeTextView = new TextView(context);
        }
        if (this.totalTimeTextView == null) {
            this.totalTimeTextView = new TextView(context);
        }
        if (this.bottomContainer == null) {
            this.bottomContainer = new LinearLayout(context);
        }
        if (this.textureViewContainer == null) {
            this.textureViewContainer = new FrameLayout(context);
        }
        if (this.topContainer == null) {
            this.topContainer = new RelativeLayout(context);
        }
    }

    public void onClick(View v) {
        int i = v.getId();
        if (i == R.id.start) {
            this.clickStart();
        } else if (i == R.id.fullscreen) {
            this.clickFullscreen();
        }
    }

    public boolean onTouch(View v, MotionEvent event) {
        float x = event.getX();
        float y = event.getY();
        int id2 = v.getId();
        if (id2 == R.id.surface_container) {
            switch (event.getAction()) {
                case 0: {
                    this.touchActionDown(x, y);
                    break;
                }
                case 2: {
                    this.touchActionMove(x, y);
                    break;
                }
                case 1: {
                    this.touchActionUp();
                }
            }
        }
        return false;
    }

    public void onProgressChanged(SeekBar seekBar, int progress, boolean fromUser) {
    }

    public void onStartTrackingTouch(SeekBar seekBar) {
    }

    public void onStopTrackingTouch(SeekBar seekBar) {
        TsPlayer player = PlayerManager.getInstance().getPlayer();
        if (player != null) {
            player.seekTo((long)seekBar.getProgress());
        }
    }

    protected boolean canPlay() {
        if (this.dataSource == null || this.dataSource.playbackConfiguration.uri == null) {
            Toast.makeText((Context)this.mContext, (CharSequence)this.getResources().getString(R.string.no_url), (int)0).show();
            Logger.w((String)TAG, (String)"\u672a\u8bbe\u7f6e\u64ad\u653e\u8d44\u6e90");
            return false;
        }
        Uri uri = this.dataSource.playbackConfiguration.uri;
        if (Util.isLocalFileUri((Uri)uri)) {
            return true;
        }
        if (this.isCacheCompleted(this.dataSource)) {
            Logger.i((String)TAG, (String)("\u5df2\u7f13\u5b58\u5b8c\u6bd5\u7684\u89c6\u9891\uff0c\u53ef\u65e0\u7f51\u64ad\u653e-->" + uri));
        } else if (ToolUtils.isNetworkAvailable((Context)this.mContext)) {
            if (!ToolUtils.isWifiConnected((Context)this.mContext)) {
                Logger.i((String)TAG, (String)("\u672a\u7f13\u5b58\u4e14\u7f51\u7edc\u5df2\u8fde\u63a5\u4f46\u4e0d\u662fWiFi\uff0c\u662f\u5426\u64ad\u653e-->" + uri));
                this.showWifiDialog();
                return false;
            }
        } else {
            Logger.w((String)TAG, (String)("\u672a\u7f13\u5b58\u6216\u8005\u672a\u7f13\u5b58\u5b8c\u6bd5\u7684\u89c6\u9891\uff0c\u9700\u8054\u7f51\u64ad\u653e-->" + uri));
            this.showNetworkDialog();
            return false;
        }
        return true;
    }

    protected void clickStart() {
        Logger.d((String)TAG, (String)("onClick start-->" + this.hashCode()));
        TsPlayer player = PlayerManager.getInstance().getPlayer();
        if (player == null) {
            Logger.e((String)TAG, (String)"clickStart--->\u672a\u521d\u59cb\u5316\u64ad\u653e\u5668");
            return;
        }
        if (this.state == 0) {
            if (!this.canPlay()) {
                return;
            }
            this.setup(player);
        } else if (this.state == 5) {
            player.pause();
        } else if (this.state == 6) {
            player.play();
        } else if (this.state == 7) {
            player.play();
        }
    }

    protected void startVideo() {
        TsPlayer player = PlayerManager.getInstance().getPlayer();
        this.setup(player);
    }

    private void setup(TsPlayer player) {
        if (this.displaySurface == null) {
            this.switchPlayerView();
            this.addDisplaySurface();
            player.addListener((Player.PlayerListener)this);
            player.setDataSource(this.dataSource);
            player.setVideoTextureView((TextureView)this.displaySurface);
        } else if (!PlayerManager.getInstance().isSameView(this.textureViewContainer.hashCode())) {
            this.switchPlayerView();
            player.addListener((Player.PlayerListener)this);
            player.setDataSource(this.dataSource);
            player.setVideoTextureView((TextureView)this.displaySurface);
        }
        ToolUtils.scanForActivity((Context)this.getContext()).getWindow().addFlags(128);
        if (this.state == 0 && player.getPlaybackState() != 1) {
            this.state = 4;
        }
        player.play();
    }

    private void switchPlayerView() {
        PlayerView playerView = PlayerManager.getInstance().getPlayerView();
        if (playerView != null) {
            playerView.progressBar.setFocusable(false);
            playerView.progressBar.setEnabled(false);
            playerView.progressBar.setSelected(false);
            playerView.progressBar.setOnSeekBarChangeListener(null);
            if (playerView.isPlaying()) {
                playerView.pause();
            }
        }
        PlayerManager.getInstance().setPlayerView(this);
        this.progressBar.setFocusable(true);
        this.progressBar.setSelected(true);
        this.progressBar.setEnabled(true);
        this.progressBar.setOnSeekBarChangeListener((SeekBar.OnSeekBarChangeListener)this);
    }

    private void addDisplaySurface() {
        if (this.displaySurface != null) {
            this.textureViewContainer.removeView(this.displaySurface);
        }
        this.displaySurface = new TextureView(this.mContext);
        PlayerManager.getInstance().setDisplayViewId(this.textureViewContainer.hashCode());
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-1, -1, 17);
        this.textureViewContainer.addView(this.displaySurface, (ViewGroup.LayoutParams)layoutParams);
    }

    protected void clickFullscreen() {
        Logger.d((String)TAG, (String)"onClick fullscreen");
    }

    protected void touchActionDown(float x, float y) {
    }

    protected void touchActionMove(float x, float y) {
    }

    protected void touchActionUp() {
    }

    public void onStatePlaying() {
        Logger.i((String)TAG, (String)("onStatePlaying  [" + this.hashCode() + "] "));
        if (this.state == 4) {
            Logger.d((String)TAG, (String)"onStatePlaying:STATE_PREPARED ");
        }
        this.state = 5;
        this.startProgressTimer();
    }

    public void onStatePause() {
        Logger.i((String)TAG, (String)("onStatePause  [" + this.hashCode() + "] "));
        this.state = 6;
        this.startProgressTimer();
    }

    public void onStateError() {
        Logger.i((String)TAG, (String)("onStateError  [" + this.hashCode() + "] "));
        this.state = 8;
        this.cancelProgressTimer();
    }

    public void onStateAutoComplete() {
        Logger.i((String)TAG, (String)("onStateAutoComplete [" + this.hashCode() + "] "));
        this.state = 7;
    }

    public void cancelProgressTimer() {
    }

    public void onStateNormal() {
        Logger.i((String)TAG, (String)("onStateNormal  [" + this.hashCode() + "] "));
        this.state = 0;
    }

    public void onStatePreparing() {
        Logger.i((String)TAG, (String)("onStatePreparing  [" + this.hashCode() + "] "));
        this.state = 1;
    }

    public void onStatePreparingPlaying() {
        Logger.i((String)TAG, (String)("onStatePreparingPlaying  [" + this.hashCode() + "] "));
        this.state = 3;
    }

    public void onStatePreparingChangeUrl() {
        Logger.i((String)TAG, (String)("onStatePreparingChangeUrl  [" + this.hashCode() + "] "));
        this.state = 2;
    }

    public void startProgressTimer() {
    }

    public void setState(int state) {
        switch (state) {
            case 0: {
                this.onStateNormal();
                break;
            }
            case 1: {
                this.onStatePreparing();
                break;
            }
            case 3: {
                this.onStatePreparingPlaying();
                break;
            }
            case 2: {
                this.onStatePreparingChangeUrl();
                break;
            }
            case 5: {
                this.onStatePlaying();
                break;
            }
            case 6: {
                this.onStatePause();
                break;
            }
            case 8: {
                this.onStateError();
                break;
            }
            case 7: {
                this.onStateAutoComplete();
            }
        }
    }

    public void reset() {
        Logger.i((String)TAG, (String)("reset--->view:" + this.hashCode() + "  progressBar:" + this.progressBar.getProgress()));
        if (this.state == 5 || this.state == 6 || this.state == 3) {
            Logger.i((String)TAG, (String)("reset--->currentPosition:" + this.getCurrentPosition()));
        }
        this.progressBar.setFocusable(false);
        this.progressBar.setSelected(false);
        this.progressBar.setEnabled(false);
        if (this.state == 5 || this.state == 3) {
            this.pause();
        }
        PlayerManager.getInstance().getPlayer().clearVideoSurface();
        PlayerManager.getInstance().setDisplayViewId(-1);
        PlayerManager.getInstance().setPlayerView(null);
        this.onStateNormal();
        this.displaySurface = null;
        this.textureViewContainer.removeAllViews();
        ToolUtils.scanForActivity((Context)this.getContext()).getWindow().clearFlags(128);
    }

    public void showWifiDialog() {
    }

    public void showNetworkDialog() {
    }

    public void changeUrl(MediaDataSource dataSource, long positionMs) {
    }

    public void onPrepared() {
        Logger.d((String)TAG, (String)"player--------->onPrepared");
        this.state = 4;
        String uriPath = this.dataSource.playbackConfiguration.uri.getPath();
        if (Util.isAudio((String)uriPath)) {
            this.onStatePlaying();
        }
    }

    public void onCompletion() {
        Logger.d((String)TAG, (String)"player--------->onCompletion");
        this.onStateAutoComplete();
        ToolUtils.scanForActivity((Context)this.getContext()).getWindow().clearFlags(128);
    }

    public void onVideoSizeChanged(VideoSize videoSize) {
        this.layoutByVideoRatio(videoSize);
    }

    private void layoutByVideoRatio(VideoSize videoSize) {
        Point displayModeSize = Util.getCurrentDisplayModeSize((Context)this.mContext);
        int containerWidth = this.textureViewContainer.getWidth();
        int containerHeight = this.textureViewContainer.getHeight();
        Point displaySize = Util.measureSizeByRatio((int)containerWidth, (int)containerHeight, (int)videoSize.width, (int)videoSize.height);
        Logger.d((String)("\u5c4f\u5e55\u5206\u8fa8\u7387-->" + displayModeSize + ",  video Container: " + containerWidth + "x" + containerHeight + " displaySize:" + videoSize));
        View view = this.displaySurface;
        if ((float)view.getWidth() / (float)view.getHeight() == (float)displaySize.x / (float)displaySize.y) {
            return;
        }
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(displaySize.x, displaySize.y, 17);
        view.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
    }

    public void onProgressChanged(Player.PositionInfo newPosition) {
        int durationMs = (int)newPosition.durationMs;
        if (this.progressBar.getMax() != durationMs) {
            this.progressBar.setMax(durationMs);
        }
        this.progressBar.setProgress((int)newPosition.currentPositionMs);
        this.progressBar.setSecondaryProgress((int)newPosition.bufferedPositionMs);
        this.currentTimeTextView.setText((CharSequence)newPosition.formatCurrentPositionElapsedTime());
        this.totalTimeTextView.setText((CharSequence)newPosition.formatDurationTime());
    }

    public void onInfo(int what, int extra) {
        Logger.d((String)TAG, (String)("onInfo what - " + what + " extra - " + extra));
        if (what == 3) {
            Logger.i((String)TAG, (String)"onInfo-->MEDIA_INFO_VIDEO_RENDERING_START");
            if (this.state == 4 || this.state == 6 || this.state == 3) {
                this.onStatePlaying();
            }
        } else if (what == 701) {
            Logger.i((String)TAG, (String)"onInfo-->MEDIA_INFO_BUFFERING_START");
            backUpBufferState = this.state;
            this.setState(3);
        } else if (what == 702) {
            Logger.i((String)TAG, (String)"onInfo-->MEDIA_INFO_BUFFERING_END");
            if (backUpBufferState != -1) {
                this.setState(backUpBufferState);
                backUpBufferState = -1;
            }
        } else if (what == 7) {
            this.onStatePause();
        }
    }

    public void onError(int what, String extra) {
        Logger.e((String)TAG, (String)("onError " + what + " - " + extra + " [" + this.hashCode() + "] "));
        this.onStateError();
    }

    public void setDataSource(@NonNull MediaDataSource dataSource) {
        this.dataSource = dataSource;
        this.onStateNormal();
        Logger.d((String)TAG, (String)("setDataSource-->" + dataSource.playbackConfiguration.uri));
    }

    public void addListener(Player.PlayerListener listener) {
        PlayerManager.getInstance().getPlayer().addListener((Player.PlayerListener)this);
    }

    public void removeListener(Player.PlayerListener listener) {
        PlayerManager.getInstance().getPlayer().removeListener((Player.PlayerListener)this);
    }

    public void prepare() {
        PlayerManager.getInstance().getPlayer().prepare();
    }

    public void play() {
        PlayerManager.getInstance().getPlayer().play();
    }

    public void setPlayWhenReady(boolean playWhenReady) {
        PlayerManager.getInstance().getPlayer().setPlayWhenReady(playWhenReady);
    }

    public boolean getPlayWhenReady() {
        return PlayerManager.getInstance().getPlayer().getPlayWhenReady();
    }

    public boolean isPlaying() {
        return PlayerManager.getInstance().getPlayer().isPlaying();
    }

    public void pause() {
        PlayerManager.getInstance().getPlayer().pause();
    }

    public void stop() {
        PlayerManager.getInstance().getPlayer().stop();
    }

    public long getCurrentPosition() {
        return PlayerManager.getInstance().getPlayer().getCurrentPosition();
    }

    public long getBufferedPosition() {
        return PlayerManager.getInstance().getPlayer().getBufferedPosition();
    }

    public long getDuration() {
        return PlayerManager.getInstance().getPlayer().getDuration();
    }

    public void setRepeatMode(int repeatMode) {
        PlayerManager.getInstance().getPlayer().setRepeatMode(repeatMode);
    }

    public int getRepeatMode() {
        return PlayerManager.getInstance().getPlayer().getRepeatMode();
    }

    public void setSeekType(int type) {
        PlayerManager.getInstance().getPlayer().setSeekType(type);
    }

    public void seekTo(long positionMs) {
        PlayerManager.getInstance().getPlayer().seekTo(positionMs);
    }

    public void setVolume(float vol) {
        PlayerManager.getInstance().getPlayer().setVolume(vol);
    }

    public float getVolume() {
        return PlayerManager.getInstance().getPlayer().getVolume();
    }

    public void setSpeed(float speed) {
        PlayerManager.getInstance().getPlayer().setSpeed(speed);
    }

    public float getSpeed() {
        return PlayerManager.getInstance().getPlayer().getSpeed();
    }

    public int getPlaybackState() {
        return PlayerManager.getInstance().getPlayer().getPlaybackState();
    }

    public boolean isCacheCompleted(@NonNull MediaDataSource dataSource) {
        return PlayerManager.getInstance().getPlayer().isCacheCompleted(dataSource);
    }

    public void release() {
    }
}

