/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.pay.paysdk.manager.entity;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import com.transsion.pay.paysdk.manager.pay.PayUtil;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.json.JSONObject;

public class PaynicornSpInfo
implements Parcelable {
    public static final Parcelable.Creator<PaynicornSpInfo> CREATOR = new Parcelable.Creator<PaynicornSpInfo>(){

        public PaynicornSpInfo createFromParcel(Parcel parcel) {
            return new PaynicornSpInfo(parcel);
        }

        public PaynicornSpInfo[] newArray(int n) {
            return new PaynicornSpInfo[n];
        }
    };
    @SerializedName(value="name")
    public String name;
    @SerializedName(value="icon")
    public String icon;
    @SerializedName(value="code")
    public String spCode;
    @SerializedName(value="maxAmount")
    public double maxAmount;
    @SerializedName(value="minAmount")
    public double minAmount;
    @SerializedName(value="methodType")
    public String type;
    @SerializedName(value="discreteAmount")
    public double[] supportAmounts;
    @SerializedName(value="discountRatio")
    public BigDecimal discountRatio;
    @Expose(serialize=false, deserialize=false)
    public transient boolean isSMS;
    @Expose(serialize=false, deserialize=false)
    public transient double actualAmount;
    @Expose(serialize=false, deserialize=false)
    public transient double discount;
    @Expose(serialize=false, deserialize=false)
    public transient boolean smsAmountUp = false;
    @SerializedName(value="mccmncSubscribeAmount")
    public MCCMNCSubscribeAmount mccmncSubscribeAmount;
    @SerializedName(value="supportBizType")
    public int supportBizType;

    public PaynicornSpInfo() {
    }

    public PaynicornSpInfo(Parcel parcel) {
        this.name = parcel.readString();
        this.icon = parcel.readString();
        this.spCode = parcel.readString();
        this.maxAmount = parcel.readDouble();
        this.minAmount = parcel.readDouble();
        this.type = parcel.readString();
        this.supportAmounts = parcel.createDoubleArray();
        this.supportBizType = parcel.readInt();
    }

    public static JSONObject entityToJson(PaynicornSpInfo object) {
        try {
            object = PayUtil.toJson(object);
        }
        catch (Throwable throwable) {
            return null;
        }
        return new JSONObject((String)object);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static PaynicornSpInfo jsonToEntity(JSONObject object) {
        try {
            object = PayUtil.fromJson(object.toString(), PaynicornSpInfo.class);
            if (((PaynicornSpInfo)object).supportAmounts != null && ((PaynicornSpInfo)object).maxAmount == 0.0) {
                ((PaynicornSpInfo)object).maxAmount = Double.MAX_VALUE;
                return object;
            }
            if (!((PaynicornSpInfo)object).isDiscountRatioValid()) return object;
            Object object2 = object;
        }
        catch (Throwable throwable) {
            return null;
        }
        ((PaynicornSpInfo)object2).maxAmount = new BigDecimal(((PaynicornSpInfo)object).maxAmount).divide(((PaynicornSpInfo)object).discountRatio, 0, 1).doubleValue();
        return object;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeString(this.name);
        parcel.writeString(this.icon);
        parcel.writeString(this.spCode);
        parcel.writeDouble(this.maxAmount);
        parcel.writeDouble(this.minAmount);
        parcel.writeString(this.type);
        parcel.writeDoubleArray(this.supportAmounts);
        parcel.writeInt(this.supportBizType);
    }

    public boolean isVas() {
        return this.isSMS || TextUtils.equals((CharSequence)this.type, (CharSequence)"VAS");
    }

    public boolean isNoDcpVas() {
        return this.isSMS;
    }

    public boolean isDiscountRatioValid() {
        if (this.discountRatio == null) {
            BigDecimal bigDecimal;
            BigDecimal bigDecimal2 = bigDecimal;
            bigDecimal = new BigDecimal(0);
            this.discountRatio = bigDecimal2;
        }
        return this.discountRatio.doubleValue() > 0.0 && this.discountRatio.doubleValue() < 1.0;
    }

    public static class SubscribeAmountDTO
    implements Parcelable {
        public static final Parcelable.Creator<SubscribeAmountDTO> CREATOR = new Parcelable.Creator<SubscribeAmountDTO>(){

            public SubscribeAmountDTO createFromParcel(Parcel parcel) {
                return new SubscribeAmountDTO(parcel);
            }

            public SubscribeAmountDTO[] newArray(int n) {
                return new SubscribeAmountDTO[n];
            }
        };
        @SerializedName(value="cycle")
        public String cycle;
        @SerializedName(value="amount")
        public double amount;

        public SubscribeAmountDTO() {
        }

        public SubscribeAmountDTO(Parcel parcel) {
            this.cycle = parcel.readString();
            this.amount = parcel.readDouble();
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(Parcel parcel, int n) {
            parcel.writeString(this.cycle);
            parcel.writeDouble(this.amount);
        }

        public void readFromParcel(Parcel parcel) {
            this.cycle = parcel.readString();
            this.amount = parcel.readDouble();
        }
    }

    public static class MCCMNCSubscribeAmount
    extends HashMap<String, List<SubscribeAmountDTO>> {
        @Override
        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object != null && MCCMNCSubscribeAmount.class == object.getClass()) {
                return super.equals(object);
            }
            return false;
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode());
        }

        @Override
        public String toString() {
            StringBuilder stringBuilder;
            MCCMNCSubscribeAmount mCCMNCSubscribeAmount = serializable;
            Serializable serializable = stringBuilder;
            new StringBuilder().append("class MCCMNCSubscribeAmount {\n");
            StringBuilder stringBuilder2 = ((StringBuilder)serializable).append("    ");
            String string2 = super.toString();
            string2 = string2 == null ? "null" : string2.toString().replace("\n", "\n    ");
            Serializable serializable2 = serializable;
            stringBuilder2.append(string2).append("\n");
            ((StringBuilder)serializable2).append("}");
            return ((StringBuilder)serializable2).toString();
        }
    }
}

