/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.pay.paysdk.manager.utils;

import android.app.Activity;
import android.app.UiModeManager;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.WebView;
import android.widget.ImageView;
import com.transsion.pay.paysdk.manager.GlobalCache;
import com.transsion.pay.paysdk.manager.utils.PaySDKLogUtil;
import com.transsion.pay.paysdk.manager.utils.SPUtils;
import java.io.InputStream;
import java.net.URL;
import java.util.UUID;

public class CommonUtils {
    public static final int TIME = 300;
    public static long lastClickTime = 0L;

    public static boolean isFastDoubleClick() {
        long l = System.currentTimeMillis();
        long l2 = l - lastClickTime;
        if (0L < l2 && l2 < 300L) {
            return true;
        }
        lastClickTime = l;
        return false;
    }

    public static boolean installed(String string2, Context context) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return false;
        }
        try {
            return context.getPackageManager().getApplicationInfo(string2, 0) != null;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public static int getPackageCode(String string2, Activity activity) {
        block4: {
            if (TextUtils.isEmpty((CharSequence)string2)) {
                return -1;
            }
            string2 = activity.getPackageManager().getPackageInfo(string2, 0);
            if (string2 == null) break block4;
            try {
                return ((PackageInfo)string2).versionCode;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return -1;
    }

    public static String getPackageName(String string2, Activity activity) {
        block4: {
            if (TextUtils.isEmpty((CharSequence)string2)) {
                return "";
            }
            string2 = activity.getPackageManager().getPackageInfo(string2, 0);
            if (string2 == null) break block4;
            try {
                return ((PackageInfo)string2).versionName;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return "";
    }

    public static void loadImage(final ImageView imageView, final String string2) {
        try {
            GlobalCache.cachedThreadPool.submit(new Runnable(){

                @Override
                public void run() {
                    1 v0 = this;
                    final Bitmap bitmap = BitmapFactory.decodeStream((InputStream)new URL(string2).openStream());
                    try {
                        v0.imageView.post(new Runnable(){

                            @Override
                            public void run() {
                                imageView.setImageBitmap(bitmap);
                                PaySDKLogUtil.logE("a", "loadImage success");
                            }
                        });
                    }
                    catch (Throwable throwable) {
                        PaySDKLogUtil.logE("a", "loadImage error:" + throwable.getMessage());
                    }
                }
            });
        }
        catch (Exception exception) {
            PaySDKLogUtil.logE("a", "loadImage error:" + exception.getMessage());
        }
    }

    public static String getDeviceId() {
        String string2 = "123456";
        if (GlobalCache.getInstance().mContext != null && TextUtils.isEmpty((CharSequence)(string2 = SPUtils.getParam(GlobalCache.getInstance().mContext, "sp_gaid_info", "")))) {
            string2 = UUID.randomUUID().toString();
            SPUtils.setParam(GlobalCache.getInstance().mContext, "sp_gaid_info", string2);
        }
        return string2;
    }

    public static String getPackageName() {
        if (GlobalCache.getInstance().mContext != null) {
            return GlobalCache.getInstance().mContext.getPackageName();
        }
        return "";
    }

    public static String getCountryCode() {
        if (GlobalCache.getInstance().countryCurrencyData != null) {
            return GlobalCache.getInstance().countryCurrencyData.countryCode;
        }
        return "";
    }

    public static String getToken() {
        if (GlobalCache.getInstance().mContext != null) {
            return SPUtils.getParam(GlobalCache.getInstance().mContext, "ACCESS_TOKEN", "");
        }
        return "";
    }

    public static boolean getNightMode(Context context) {
        return ((UiModeManager)context.getSystemService("uimode")).getNightMode() == 2;
    }

    public static String getSysLanguage(Context context) {
        return context.getResources().getConfiguration().locale.getLanguage();
    }

    public static void destroyWebview(WebView webView) {
        if (webView == null) {
            return;
        }
        WebView webView2 = webView;
        webView2.loadDataWithBaseURL(null, "", "text/html", "utf-8", null);
        if (webView2.getParent() != null) {
            ((ViewGroup)webView.getParent()).removeView((View)webView);
        }
        webView.destroy();
    }

    public static int getNumberDecimalDigits(double d) {
        double d2;
        int n = 0;
        while (d * Math.pow(10.0, d2 = (double)(++n)) % 1.0 != 0.0) {
        }
        return n;
    }
}

