/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.pay.mcompiler;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.transsion.pay.mrouter.Route;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;

public class RouteProcessor
extends AbstractProcessor {
    private Filer filer;
    private Map<String, String> routes = new HashMap<String, String>();
    private String moduleName;

    @Override
    public synchronized void init(ProcessingEnvironment processingEnvironment) {
        super.init(processingEnvironment);
        this.filer = processingEnvironment.getFiler();
    }

    @Override
    public boolean process(Set<? extends TypeElement> set, RoundEnvironment roundEnvironment) {
        for (Element element : roundEnvironment.getElementsAnnotatedWith(Route.class)) {
            this.addRoute(element);
        }
        this.createRouteFile();
        return true;
    }

    private void createRouteFile() {
        TypeSpec.Builder builder = TypeSpec.classBuilder((String)("MRouterMap_" + this.moduleName)).addModifiers(new Modifier[]{Modifier.PUBLIC});
        ClassName superInterface = ClassName.bestGuess((String)"com.transsion.pay.mrouter.IRoute");
        builder.addSuperinterface((TypeName)superInterface);
        ClassName stringType = ClassName.get(String.class);
        ParameterizedTypeName mapType = ParameterizedTypeName.get((ClassName)ClassName.get(Map.class), (TypeName[])new TypeName[]{stringType, stringType});
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)"loadInto").addAnnotation(Override.class).returns(Void.TYPE).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)mapType, "routes", new Modifier[0]);
        for (String key : this.routes.keySet()) {
            methodBuilder.addStatement("routes.put($S,$S)", new Object[]{key, this.routes.get(key)});
        }
        builder.addMethod(methodBuilder.build());
        JavaFile javaFile = JavaFile.builder((String)"com.transsion.pay.mrouter.routes", (TypeSpec)builder.build()).build();
        try {
            javaFile.writeTo(this.filer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void addRoute(Element e) {
        Route route = e.getAnnotation(Route.class);
        String path = route.path();
        String name = e.toString();
        this.moduleName = path.substring(path.lastIndexOf("/") + 1, path.length());
        this.routes.put(path, name);
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        LinkedHashSet<String> annotations = new LinkedHashSet<String>();
        annotations.add(Route.class.getCanonicalName());
        return annotations;
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }
}

