/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.pay.mrouter;

import android.content.Context;
import dalvik.system.BaseDexClassLoader;
import dalvik.system.DexFile;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ClassUtils {
    private static List<DexFile> getDexFiles(Context context) throws IOException {
        ArrayList<DexFile> dexFiles = new ArrayList<DexFile>();
        BaseDexClassLoader loader = (BaseDexClassLoader)context.getClassLoader();
        try {
            Field pathListField = ClassUtils.field("dalvik.system.BaseDexClassLoader", "pathList");
            Object list = pathListField.get(loader);
            Field dexElementsField = ClassUtils.field("dalvik.system.DexPathList", "dexElements");
            Object[] dexElements = (Object[])dexElementsField.get(list);
            Field dexFilefield = ClassUtils.field("dalvik.system.DexPathList$Element", "dexFile");
            for (Object dex : dexElements) {
                DexFile dexFile = (DexFile)dexFilefield.get(dex);
                dexFiles.add(dexFile);
            }
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return dexFiles;
    }

    private static Field field(String clazz, String fieldName) throws ClassNotFoundException, NoSuchFieldException {
        Class<?> cls = Class.forName(clazz);
        Field field = cls.getDeclaredField(fieldName);
        field.setAccessible(true);
        return field;
    }

    public static Set<String> getFileNameByPackageName(Context context, String packageName) throws IOException {
        HashSet<String> classNames = new HashSet<String>();
        List<DexFile> dexFiles = ClassUtils.getDexFiles(context);
        for (DexFile dexfile : dexFiles) {
            Enumeration dexEntries = dexfile.entries();
            while (dexEntries.hasMoreElements()) {
                String className = (String)dexEntries.nextElement();
                if (!className.startsWith(packageName)) continue;
                classNames.add(className);
            }
        }
        return classNames;
    }
}

