/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.pay.mrouter;

import android.content.Context;
import com.transsion.pay.mrouter.ClassUtils;
import com.transsion.pay.mrouter.IRoute;
import com.transsion.pay.mrouter.Postcard;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class MRouter {
    private Map<String, String> routes = new HashMap<String, String>();
    private static final MRouter instance = new MRouter();
    public static final String ROUTES_PACKAGE_NAME = "com.transsion.pay.mrouter.routes";

    public void init(Context context) {
        try {
            Set<String> names = ClassUtils.getFileNameByPackageName(context, ROUTES_PACKAGE_NAME);
            this.initRoutes(names);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private MRouter() {
    }

    private void initRoutes(Set<String> names) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        for (String name : names) {
            Class<?> clazz = Class.forName(name);
            Object obj = clazz.newInstance();
            if (!(obj instanceof IRoute)) continue;
            IRoute route = (IRoute)obj;
            route.loadInto(this.routes);
        }
    }

    public static MRouter getInstance() {
        return instance;
    }

    public Postcard build(String path) {
        String component = this.routes.get(path);
        if (component == null) {
            throw new RuntimeException("could not find route with " + path);
        }
        return new Postcard(component);
    }

    public Map<String, String> getRoutes() {
        return this.routes;
    }
}

