/*
 * Decompiled with CFR 0.152.
 */
package com.zero.admoblibrary.excuter;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import com.google.android.gms.ads.AdListener;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.AdSize;
import com.google.android.gms.ads.AdView;
import com.zero.common.base.BaseBanner;
import com.zero.common.bean.TAdErrorCode;
import com.zero.common.bean.TrackInfor;
import com.zero.common.utils.AdLogUtil;
import com.zero.common.utils.AutomatedLogUtil;
import com.zero.common.widget.WrapTadView;

public class AdmobBanner
extends BaseBanner {
    private AdView a;
    private int b;

    public AdmobBanner(Context context, String string, String string2, int n) {
        this(context, string, string2, n, null);
    }

    public AdmobBanner(Context context, String string, String string2, int n, TrackInfor trackInfor) {
        super(context, string, string2, trackInfor);
        this.b = n;
        AdLogUtil.Log().d("AdmobBanner", "placemen id:=" + string2 + ",bannerSize:=" + n);
    }

    public void loadAd() {
        this.a();
        if (this.a != null) {
            AdLogUtil.Log().d("AdmobBanner", "admob banner start load ad");
            AutomatedLogUtil.AutomatedRecord((String)"Admob", (String)this.mPlacementId, (String)"Banner", (String)"LoadAd");
            AdRequest adRequest = new AdRequest.Builder().build();
            this.a.setVisibility(8);
            this.a.loadAd(adRequest);
            this.startTime = System.currentTimeMillis();
            this.allianceStart();
        }
    }

    private void a() {
        if (this.mContext != null && this.mContext.get() != null) {
            this.a = new AdView(((Context)this.mContext.get()).getApplicationContext());
            this.a.setAdUnitId(this.mPlacementId);
            switch (this.b) {
                case 0: {
                    this.a.setAdSize(AdSize.BANNER);
                    break;
                }
                case 1: 
                case 3: {
                    this.a.setAdSize(AdSize.LARGE_BANNER);
                    break;
                }
                case 2: {
                    this.a.setAdSize(AdSize.MEDIUM_RECTANGLE);
                    break;
                }
                default: {
                    this.a.setAdSize(AdSize.BANNER);
                }
            }
            this.a.setAdListener(new AdListener(){

                public void onAdClosed() {
                    super.onAdClosed();
                    AdLogUtil.Log().d("AdmobBanner", "banner closec");
                    AutomatedLogUtil.AutomatedRecord((String)"Admob", (String)AdmobBanner.this.mPlacementId, (String)"Banner", (String)"Closed");
                    if (AdmobBanner.this.mAdRequestBody != null && AdmobBanner.this.mAdRequestBody.getAllianceListener() != null) {
                        AdmobBanner.this.mAdRequestBody.getAllianceListener().onClosed();
                    }
                }

                public void onAdFailedToLoad(int n) {
                    super.onAdFailedToLoad(n);
                    if (!AdmobBanner.this.isLoaded) {
                        AdmobBanner.this.isLoaded = true;
                        AdLogUtil.Log().e("AdmobBanner", "banner is error, error code is " + n);
                        AdmobBanner.this.allianceLoad(System.currentTimeMillis() - AdmobBanner.this.startTime, n + 100, AdmobBanner.this.defultMsg);
                        if (AdmobBanner.this.mAdRequestBody != null && AdmobBanner.this.mAdRequestBody.getAllianceListener() != null) {
                            AdmobBanner.this.mAdRequestBody.getAllianceListener().onAllianceError(new TAdErrorCode(n, ""));
                        }
                    } else {
                        AdmobBanner.this.allianceLoad(0L, n, AdmobBanner.this.defultMsg);
                        AdLogUtil.Log().e("AdmobBanner", "banner have been Loaded, but Loaded again ");
                    }
                }

                public void onAdLeftApplication() {
                    AdLogUtil.Log().d("AdmobBanner", "banner is click");
                    AutomatedLogUtil.AutomatedRecord((String)"Admob", (String)AdmobBanner.this.mPlacementId, (String)"Banner", (String)"Click");
                    AdmobBanner.this.allianceOnclick();
                    if (AdmobBanner.this.mAdRequestBody != null && AdmobBanner.this.mAdRequestBody.getAllianceListener() != null) {
                        AdmobBanner.this.mAdRequestBody.getAllianceListener().onClicked();
                    }
                }

                public void onAdLoaded() {
                    if (!AdmobBanner.this.isLoaded) {
                        AdmobBanner.this.isLoaded = true;
                        AdLogUtil.Log().d("AdmobBanner", "banner is Loaded");
                        AutomatedLogUtil.AutomatedRecord((String)"Admob", (String)AdmobBanner.this.mPlacementId, (String)"Banner", (String)"Loaded");
                        AdmobBanner.this.allianceLoad(System.currentTimeMillis() - AdmobBanner.this.startTime, AdmobBanner.this.defultCode, AdmobBanner.this.defultMsg);
                        if (AdmobBanner.this.mAdRequestBody != null && AdmobBanner.this.mAdRequestBody.getAllianceListener() != null) {
                            AdmobBanner.this.mAdRequestBody.getAllianceListener().onAllianceLoad();
                            AdLogUtil.Log().d("AdmobBanner", "adView load with listener ");
                        } else {
                            AdLogUtil.Log().d("AdmobBanner", "adView show ");
                        }
                    } else {
                        AdmobBanner.this.allianceLoad(0L, AdmobBanner.this.defultCode, AdmobBanner.this.defultMsg);
                        AdmobBanner.this.allianceShow();
                        AdLogUtil.Log().e("AdmobBanner", "banner have been Loaded, but Loaded again ");
                    }
                }

                public void onAdClicked() {
                    super.onAdClicked();
                }

                public void onAdImpression() {
                    super.onAdImpression();
                    AutomatedLogUtil.AutomatedRecord((String)"Admob", (String)AdmobBanner.this.mPlacementId, (String)"Banner", (String)"Impression");
                }
            });
        }
    }

    public void show(WrapTadView wrapTadView) {
        if (this.a != null) {
            wrapTadView.onAddView((View)this.a);
            this.a.setVisibility(0);
            this.allianceShow();
            AdLogUtil.Log().d("AdmobBanner", "adView is show ");
            AutomatedLogUtil.AutomatedRecord((String)"Admob", (String)this.mPlacementId, (String)"Banner", (String)"Show");
            if (this.mAdRequestBody != null && this.mAdRequestBody.getAllianceListener() != null) {
                this.mAdRequestBody.getAllianceListener().onShow();
            } else {
                AdLogUtil.Log().e("AdmobBanner", "adView is destroy before show ");
            }
        } else {
            AdLogUtil.Log().e("AdmobBanner", "adView is null ");
        }
    }

    public void destroyAd() {
        super.destroyAd();
        this.isLoaded = false;
        if (this.a != null) {
            ViewParent viewParent = this.a.getParent();
            if (viewParent != null && viewParent instanceof ViewGroup) {
                ((ViewGroup)viewParent).removeView((View)this.a);
            }
            this.a.setAdListener(null);
            this.a.destroy();
            this.a = null;
            AdLogUtil.Log().d("AdmobBanner", "admob banner destroy");
        }
    }
}

