/*
 * Decompiled with CFR 0.152.
 */
package com.zero.admoblibrary.excuter;

import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;
import android.view.View;
import androidx.annotation.NonNull;
import com.google.android.gms.ads.AdError;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.FullScreenContentCallback;
import com.google.android.gms.ads.LoadAdError;
import com.google.android.gms.ads.appopen.AppOpenAd;
import com.zero.common.base.BaseSplash;
import com.zero.common.bean.TAdErrorCode;
import com.zero.common.bean.TrackInfor;
import com.zero.common.interfacz.OnSkipListener;
import com.zero.common.utils.AdLogUtil;
import com.zero.ta.common.gif.ICustomGifView;

public class AdmobSplash
extends BaseSplash {
    public static final String TAG = "AdmobSplash";
    public static String AD_UNIT_ID = "";
    public static boolean isShowingAd = false;
    public AppOpenAd appOpenAd = null;
    public AppOpenAd.AppOpenAdLoadCallback loadCallback;
    public Activity currentActivity;
    public Context mContext;
    public OnSkipListener mListener;

    public AdmobSplash(Context context, String string, String string2, TrackInfor trackInfor) {
        super(context, string, string2, trackInfor);
        this.mContext = context;
        AdLogUtil.Log().d(TAG, "placemen id:=" + this.mPlacementId);
    }

    public void fetchAd() {
        if (this.isAdAvailable()) {
            return;
        }
        AdmobSplash admobSplash = this;
        admobSplash.loadCallback = new AppOpenAd.AppOpenAdLoadCallback(){

            public void a(AppOpenAd appOpenAd) {
                1 v0 = this;
                v0.AdmobSplash.this.appOpenAd = appOpenAd;
                v0.AdmobSplash.this.adLoaded();
                AdLogUtil.Log().d(AdmobSplash.TAG, "admob appOpenAd onAdLoaded");
                v0.AdmobSplash.this.appOpenAd.setFullScreenContentCallback(new FullScreenContentCallback(){

                    public void onAdFailedToShowFullScreenContent(@NonNull AdError adError) {
                        1 v0 = this;
                        super.onAdFailedToShowFullScreenContent(adError);
                        v0.AdmobSplash.this.adFailedToLoad(new TAdErrorCode(adError.getCode(), adError.getMessage()));
                        AdLogUtil.Log().d(AdmobSplash.TAG, "admob splashview show fail:" + adError.getMessage());
                    }

                    public void onAdShowedFullScreenContent() {
                        1 v0 = this;
                        super.onAdShowedFullScreenContent();
                        v0.AdmobSplash.this.adImpression();
                        isShowingAd = true;
                        AdLogUtil.Log().d(AdmobSplash.TAG, "admob splashview onAdShow");
                    }

                    public void onAdDismissedFullScreenContent() {
                        1 v0 = this;
                        super.onAdDismissedFullScreenContent();
                        if (v0.AdmobSplash.this.mListener != null) {
                            AdmobSplash.this.mListener.onClick();
                        }
                        AdmobSplash.this.appOpenAd = null;
                        isShowingAd = false;
                        AdLogUtil.Log().d(AdmobSplash.TAG, "admob splashview onAdClicked");
                    }

                    public void onAdImpression() {
                        super.onAdImpression();
                    }
                });
            }

            public void onAdFailedToLoad(LoadAdError loadAdError) {
                AdmobSplash.this.adFailedToLoad(new TAdErrorCode(loadAdError.getCode(), loadAdError.getMessage()));
                AdLogUtil.Log().e(AdmobSplash.TAG, "admob splashview onError:" + loadAdError.getMessage());
            }
        };
        AdRequest adRequest = admobSplash.getAdRequest();
        if (admobSplash.mContext != null && !TextUtils.isEmpty((CharSequence)this.mPlacementId) && adRequest != null) {
            Context context = this.mContext.getApplicationContext();
            String string = this.mPlacementId;
            try {
                AppOpenAd.load((Context)context, (String)string, (AdRequest)adRequest, (int)1, (AppOpenAd.AppOpenAdLoadCallback)this.loadCallback);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    public void showAdIfAvailable() {
        if (!isShowingAd && this.isAdAvailable()) {
            try {
                this.appOpenAd.show(this.currentActivity);
            }
            catch (Exception exception) {}
        }
    }

    public AdRequest getAdRequest() {
        return new AdRequest.Builder().build();
    }

    public boolean isAdAvailable() {
        return this.appOpenAd != null;
    }

    public void onSplashStartLoad() {
    }

    public View getSplash() {
        AdmobSplash admobSplash = admobSplash2;
        AdLogUtil.Log().d(TAG, "admob splashview load mPlacementId:" + admobSplash2.mPlacementId);
        admobSplash.fetchAd();
        AdmobSplash admobSplash2 = admobSplash.mContext;
        if (admobSplash2 != null) {
            return new View((Context)admobSplash2);
        }
        return null;
    }

    public void onSplashShow(ICustomGifView iCustomGifView) {
        this.showAdIfAvailable();
    }

    public void setOnSkipListener(@NonNull OnSkipListener onSkipListener) {
        this.mListener = onSkipListener;
    }

    public void destroyAd() {
        AdmobSplash admobSplash = this;
        super.destroyAd();
        if (admobSplash.appOpenAd != null) {
            this.appOpenAd = null;
        }
    }

    public String getImageUrl() {
        return null;
    }

    public void setBidInfo(String string) {
    }
}

