/*
 * Decompiled with CFR 0.152.
 */
package com.zero.admoblibrary.excuter;

import android.content.Context;
import com.google.android.gms.ads.AdListener;
import com.google.android.gms.ads.AdSize;
import com.google.android.gms.ads.AdView;
import com.google.android.gms.ads.LoadAdError;
import com.zero.admoblibrary.util.PlatformUtil;
import com.zero.common.base.BaseBanner;
import com.zero.common.bean.TAdErrorCode;
import com.zero.common.bean.TrackInfor;
import com.zero.common.utils.AdLogUtil;
import com.zero.ta.common.gif.ICustomGifView;

public class AdmobBanner
extends BaseBanner<AdView> {
    public AdView ea;
    public int fa;

    public AdmobBanner(Context context, String string, String string2, int n) {
        this(context, string, string2, n, null);
    }

    public AdmobBanner(Context context, String string, String string2, int n, TrackInfor trackInfor) {
        super(context, string, string2, trackInfor);
        this.fa = n;
        AdLogUtil.Log().d("AdmobBanner", "placemen id:=" + string2 + ",bannerSize:=" + n);
    }

    public AdView getBanner() {
        if (this.ea == null && this.mContext != null && this.mContext.get() != null) {
            AdmobBanner admobBanner = this;
            admobBanner.ea = new AdView(((Context)this.mContext.get()).getApplicationContext());
            admobBanner.ea.setAdUnitId(this.mPlacementId);
            switch (admobBanner.fa) {
                default: {
                    this.ea.setAdSize(AdSize.BANNER);
                    break;
                }
                case 2: {
                    this.ea.setAdSize(AdSize.MEDIUM_RECTANGLE);
                    break;
                }
                case 1: 
                case 3: {
                    this.ea.setAdSize(AdSize.LARGE_BANNER);
                    break;
                }
                case 0: {
                    this.ea.setAdSize(AdSize.BANNER);
                }
            }
            this.ea.setAdListener(new AdListener(){

                public void onAdClosed() {
                    AdLogUtil.Log().e("AdmobBanner", "banner onAdClosed");
                    AdmobBanner.this.adClosed();
                }

                public void onAdFailedToLoad(LoadAdError loadAdError) {
                    AdLogUtil.Log().e("AdmobBanner", "banner onAdFailedToLoad:" + loadAdError.toString());
                    AdmobBanner.this.adFailedToLoad(new TAdErrorCode(loadAdError.getCode(), loadAdError.getMessage()));
                }

                public void onAdLoaded() {
                    AdLogUtil.Log().d("AdmobBanner", "banner onAdLoaded");
                    AdmobBanner.this.adLoaded();
                }

                public void onAdClicked() {
                    1 v0 = this;
                    super.onAdClicked();
                    v0.AdmobBanner.this.adClicked();
                }

                public void onAdImpression() {
                    super.onAdImpression();
                }
            });
        }
        return this.ea;
    }

    public void onBannerLoad() {
        AdView adView = this.ea;
        if (adView != null) {
            try {
                adView.loadAd(PlatformUtil.getAdRequest());
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
        AdLogUtil.Log().d("AdmobBanner", "admob banner load mPlacementId:" + this.mPlacementId);
    }

    public void onBannerShow(ICustomGifView iCustomGifView) {
        AdmobBanner admobBanner = admobBanner.ea;
        if (admobBanner != null) {
            admobBanner.setVisibility(0);
        }
    }

    public void onBannerDestroy() {
        AdView adView = this.ea;
        if (adView != null) {
            adView.setAdListener(null);
            this.ea.destroy();
            this.ea = null;
        }
        AdLogUtil.Log().d("AdmobBanner", "banner destroy");
    }

    public void setBidInfo(String string) {
    }
}

