/*
 * Decompiled with CFR 0.152.
 */
package com.zero.adxlibrary.excuter;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import com.transsion.core.CoreUtil;
import com.zero.adx.ad.TAdNative;
import com.zero.adx.ad.request.TAdRequest;
import com.zero.adx.constant.TAdErrorCode;
import com.zero.adx.impl.TAdListener;
import com.zero.adxlibrary.util.NativeInfoTransfer;
import com.zero.common.base.BaseNative;
import com.zero.common.bean.TAdNativeInfo;
import com.zero.common.bean.TrackInfor;
import com.zero.common.interfacz.IadNative;
import com.zero.common.utils.AdLogUtil;
import com.zero.common.utils.AutomatedLogUtil;
import com.zero.common.utils.SensitiveUtil;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

public class AdxNative
extends BaseNative {
    private String TAG = "AdxNative";
    private static final String AD_PLATFORM = "Adx";
    private static final String AD_POSITION = "Native";
    private int mAdsCount = 1;
    private int defaultAdsCount = 1;
    private TAdNative mNativeAd;
    private List<com.zero.adx.bean.TAdNativeInfo> mAdxNativeInfos = new ArrayList<com.zero.adx.bean.TAdNativeInfo>();

    public AdxNative(Context context, String placementId, int mAdsCount, int adt, TrackInfor track) {
        super(context, placementId, adt, track);
        this.mAdsCount = mAdsCount <= 0 ? this.defaultAdsCount : mAdsCount;
    }

    public void loadAd() {
        if (this.mContext != null && this.mContext.get() != null) {
            AutomatedLogUtil.AutomatedRecord((String)AD_PLATFORM, (String)this.mPlacementId, (String)AD_POSITION, (String)"LoadAd");
            final ArrayList adNativeInfor = new ArrayList();
            this.mNativeAd = new TAdNative(CoreUtil.getContext(), this.mPlacementId, this.mAdsCount);
            TAdRequest tAdRequest = new TAdRequest.TAdRequestBuild().setListener(new TAdListener(){

                public void onError(TAdErrorCode adxError) {
                    AdxNative.this.isLoaded = true;
                    AdLogUtil.Log().d(AdxNative.this.TAG, "native is error, error code is " + adxError.getErrorCode() + ", error msg is " + adxError.getErrorMessage());
                    AdxNative.this.allianceLoad(System.currentTimeMillis() - AdxNative.this.startTime, adxError.getErrorCode(), adxError.getErrorMessage());
                    if (AdxNative.this.mAdRequestBody != null && AdxNative.this.mAdRequestBody.getAllianceListener() != null) {
                        AdxNative.this.mAdRequestBody.getAllianceListener().onAllianceError(new com.zero.common.bean.TAdErrorCode(adxError.getErrorCode(), adxError.getErrorMessage()));
                    }
                }

                public void onAdLoaded(com.zero.adx.bean.TAdNativeInfo adxNativeInfo) {
                    AdLogUtil.Log().d(AdxNative.this.TAG, "onAdLoaded single ad");
                    AdxNative.this.isLoaded = true;
                    AutomatedLogUtil.AutomatedRecord((String)AdxNative.AD_PLATFORM, (String)AdxNative.this.mPlacementId, (String)AdxNative.AD_POSITION, (String)"Loaded");
                    adNativeInfor.clear();
                    TAdNativeInfo nativeInfo = NativeInfoTransfer.getTAdNativeInfo(adxNativeInfo, AdxNative.this.mAdt, AdxNative.this.getTtl(), (IadNative)AdxNative.this);
                    if (nativeInfo != null && !SensitiveUtil.isSensitive((String)nativeInfo.getTitle()) && !SensitiveUtil.isSensitive((String)nativeInfo.getDescription())) {
                        adNativeInfor.add(nativeInfo);
                    }
                    if (adNativeInfor.size() > 0) {
                        AdxNative.this.allianceLoad(System.currentTimeMillis() - AdxNative.this.startTime, AdxNative.this.defultCode, AdxNative.this.defultMsg);
                        if (AdxNative.this.mAdRequestBody != null && AdxNative.this.mAdRequestBody.getAllianceListener() != null) {
                            AdxNative.this.mAdxNativeInfos.clear();
                            AdxNative.this.mAdxNativeInfos.add(adxNativeInfo);
                            AdxNative.this.mAdRequestBody.getAllianceListener().onAllianceLoad((List)adNativeInfor);
                        }
                    } else {
                        AdxNative.this.allianceLoad(System.currentTimeMillis() - AdxNative.this.startTime, com.zero.common.bean.TAdErrorCode.SENSITIVE_ERROR.getErrorCode(), com.zero.common.bean.TAdErrorCode.SENSITIVE_ERROR.getErrorMessage());
                        if (AdxNative.this.mAdRequestBody != null && AdxNative.this.mAdRequestBody.getAllianceListener() != null) {
                            AdxNative.this.mAdRequestBody.getAllianceListener().onAllianceError(com.zero.common.bean.TAdErrorCode.SENSITIVE_ERROR);
                        }
                    }
                }

                public void onAdLoaded(List<com.zero.adx.bean.TAdNativeInfo> adxNativeInfos) {
                    AdLogUtil.Log().d(AdxNative.this.TAG, "onAdLoaded multi");
                    AdxNative.this.isLoaded = true;
                    AutomatedLogUtil.AutomatedRecord((String)AdxNative.AD_PLATFORM, (String)AdxNative.this.mPlacementId, (String)AdxNative.AD_POSITION, (String)"Loaded");
                    adNativeInfor.clear();
                    for (int i = 0; i < adxNativeInfos.size(); ++i) {
                        TAdNativeInfo tAdNativeInfo = NativeInfoTransfer.getTAdNativeInfo(adxNativeInfos.get(i), AdxNative.this.mAdt, AdxNative.this.getTtl(), (IadNative)AdxNative.this);
                        if (tAdNativeInfo == null || SensitiveUtil.isSensitive((String)tAdNativeInfo.getTitle()) || SensitiveUtil.isSensitive((String)tAdNativeInfo.getDescription())) continue;
                        adNativeInfor.add(tAdNativeInfo);
                    }
                    if (adNativeInfor.size() > 0) {
                        AdxNative.this.allianceLoad(System.currentTimeMillis() - AdxNative.this.startTime, AdxNative.this.defultCode, AdxNative.this.defultMsg);
                        if (AdxNative.this.mAdRequestBody != null && AdxNative.this.mAdRequestBody.getAllianceListener() != null) {
                            AdxNative.this.mAdxNativeInfos = adxNativeInfos;
                            AdxNative.this.mAdRequestBody.getAllianceListener().onAllianceLoad((List)adNativeInfor);
                        }
                    } else {
                        AdxNative.this.allianceLoad(System.currentTimeMillis() - AdxNative.this.startTime, com.zero.common.bean.TAdErrorCode.SENSITIVE_ERROR.getErrorCode(), com.zero.common.bean.TAdErrorCode.SENSITIVE_ERROR.getErrorMessage());
                        if (AdxNative.this.mAdRequestBody != null && AdxNative.this.mAdRequestBody.getAllianceListener() != null) {
                            AdxNative.this.mAdRequestBody.getAllianceListener().onAllianceError(com.zero.common.bean.TAdErrorCode.SENSITIVE_ERROR);
                        }
                    }
                }

                public void onTimeOut() {
                    AdxNative.this.isLoaded = true;
                    AdxNative.this.allianceLoad(System.currentTimeMillis() - AdxNative.this.startTime, com.zero.common.bean.TAdErrorCode.NETWORK_TIMEOUT_ERROR.getErrorCode(), com.zero.common.bean.TAdErrorCode.NETWORK_TIMEOUT_ERROR.getErrorMessage());
                    AdLogUtil.Log().e(AdxNative.this.TAG, "native is timeout, error code is " + com.zero.common.bean.TAdErrorCode.NETWORK_TIMEOUT_ERROR.getErrorCode() + ", error msg is " + com.zero.common.bean.TAdErrorCode.NETWORK_TIMEOUT_ERROR.getErrorMessage());
                    if (AdxNative.this.mAdRequestBody != null && AdxNative.this.mAdRequestBody.getAllianceListener() != null) {
                        AdxNative.this.mAdRequestBody.getAllianceListener().onAllianceError(com.zero.common.bean.TAdErrorCode.NETWORK_TIMEOUT_ERROR);
                    }
                }

                public void onAdClosed() {
                    super.onAdClosed();
                    AutomatedLogUtil.AutomatedRecord((String)AdxNative.AD_PLATFORM, (String)AdxNative.this.mPlacementId, (String)AdxNative.AD_POSITION, (String)"Closed");
                }

                public void onAdClicked() {
                    AdLogUtil.Log().d(AdxNative.this.TAG, "banner is click");
                    AutomatedLogUtil.AutomatedRecord((String)AdxNative.AD_PLATFORM, (String)AdxNative.this.mPlacementId, (String)AdxNative.AD_POSITION, (String)"Click");
                    AdxNative.this.allianceOnclick();
                    if (AdxNative.this.mAdRequestBody != null && AdxNative.this.mAdRequestBody.getAllianceListener() != null) {
                        AdxNative.this.mAdRequestBody.getAllianceListener().onClicked();
                    }
                }
            }).build();
            this.mNativeAd.setAdRequest(tAdRequest);
            AdLogUtil.Log().d(this.TAG, "adx native ad start load, ad count is " + this.mAdsCount + " plid is " + this.mPlacementId);
            this.mNativeAd.loadAd();
            this.startTime = System.currentTimeMillis();
            this.allianceStart();
        }
    }

    public void destroyAd() {
        super.destroyAd();
        if (this.mNativeAd != null) {
            this.mNativeAd.destroy();
            this.mNativeAd = null;
        }
    }

    public void registerViewForInteraction(ViewGroup viewGroup, List<View> adContains, TAdNativeInfo nativeInfo) {
        if (viewGroup != null && this.mNativeAd != null) {
            this.unregisterView(nativeInfo);
            try {
                this.mNativeAd.registerView((View)viewGroup, (com.zero.adx.bean.TAdNativeInfo)nativeInfo.getNativeAdWrapper().getNativeAd());
                this.allianceShow();
                AutomatedLogUtil.AutomatedRecord((String)AD_PLATFORM, (String)this.mPlacementId, (String)AD_POSITION, (String)"Show");
                if (this.mAdRequestBody != null && this.mAdRequestBody.getAllianceListener() != null) {
                    this.mAdRequestBody.getAllianceListener().onShow();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void unregisterView(TAdNativeInfo info) {
        if (this.mNativeAd == null) {
            return;
        }
        try {
            Method m = TAdNative.class.getDeclaredMethod("unregisterView", new Class[0]);
            m.setAccessible(true);
            m.invoke((Object)this.mNativeAd, new Object[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

