/*
 * Decompiled with CFR 0.152.
 */
package com.zero.adxlibrary.excuter;

import android.content.Context;
import com.zero.adx.ad.AdxInterstitial;
import com.zero.common.base.BaseInterstitial;
import com.zero.common.bean.TAdErrorCode;
import com.zero.common.bean.TrackInfor;
import com.zero.common.utils.AdLogUtil;
import com.zero.common.utils.AutomatedLogUtil;
import com.zero.ta.common.callback.TaListener;
import com.zero.ta.common.callback.TaRequest;
import com.zero.ta.common.constant.TaErrorCode;

public class AdxInterstitia
extends BaseInterstitial {
    private static final String TAG = "AdxInterstitia";
    private static final String AD_PLATFORM = "Adx";
    private static final String AD_POSITION = "Interstitia";
    private AdxInterstitial mInterstitialAd;

    public AdxInterstitia(Context context, String cid, String mPlacementId) {
        this(context, cid, mPlacementId, null);
    }

    public AdxInterstitia(Context context, String cid, String placementId, TrackInfor track) {
        super(context, cid, placementId, track);
        AdLogUtil.Log().d(TAG, "placemen id:=" + this.mPlacementId);
    }

    public void loadAd() {
        if (this.mContext != null && this.mContext.get() != null) {
            AutomatedLogUtil.AutomatedRecord((String)AD_PLATFORM, (String)this.mPlacementId, (String)AD_POSITION, (String)"LoadAd");
            this.mInterstitialAd = new AdxInterstitial((Context)this.mContext.get(), this.mPlacementId);
            TaRequest tAdRequest = new TaRequest.TaRequestBuild().setListener(new TaListener(){

                public void onError(TaErrorCode adError) {
                    int adErrorCode = adError.getErrorCode();
                    if (adErrorCode == 0) {
                        adErrorCode = 100;
                    }
                    AdxInterstitia.this.allianceLoad(System.currentTimeMillis() - AdxInterstitia.this.startTime, adErrorCode, adError.getErrorMessage());
                    AdLogUtil.Log().e(AdxInterstitia.TAG, "tan interstitia is error, error code is " + adError.getErrorCode() + ", error msg is " + adError.getErrorMessage());
                    AdxInterstitia.this.isLoaded = true;
                    if (AdxInterstitia.this.mAdRequestBody != null && AdxInterstitia.this.mAdRequestBody.getAllianceListener() != null) {
                        AdxInterstitia.this.mAdRequestBody.getAllianceListener().onAllianceError(new TAdErrorCode(adError.getErrorCode(), adError.getErrorMessage()));
                    }
                }

                public void onAdClosed() {
                    AdLogUtil.Log().d(AdxInterstitia.TAG, "interstitia is closed");
                    AutomatedLogUtil.AutomatedRecord((String)AdxInterstitia.AD_PLATFORM, (String)AdxInterstitia.this.mPlacementId, (String)AdxInterstitia.AD_POSITION, (String)"Closed");
                    if (AdxInterstitia.this.mAdRequestBody != null && AdxInterstitia.this.mAdRequestBody.getAllianceListener() != null) {
                        AdxInterstitia.this.mAdRequestBody.getAllianceListener().onClosed();
                    }
                }

                public void onAdLoaded() {
                    AdLogUtil.Log().d(AdxInterstitia.TAG, "interstitia is Loaded");
                    AdxInterstitia.this.isLoaded = true;
                    AutomatedLogUtil.AutomatedRecord((String)AdxInterstitia.AD_PLATFORM, (String)AdxInterstitia.this.mPlacementId, (String)AdxInterstitia.AD_POSITION, (String)"Loaded");
                    AdxInterstitia.this.allianceLoad(System.currentTimeMillis() - AdxInterstitia.this.startTime, AdxInterstitia.this.defultCode, AdxInterstitia.this.defultMsg);
                    if (AdxInterstitia.this.mAdRequestBody != null && AdxInterstitia.this.mAdRequestBody.getAllianceListener() != null) {
                        AdLogUtil.Log().d(AdxInterstitia.TAG, "adView load with listener ");
                        AdxInterstitia.this.mAdRequestBody.getAllianceListener().onAllianceLoad();
                    } else {
                        AdLogUtil.Log().d(AdxInterstitia.TAG, "adView show");
                        AdxInterstitia.this.show();
                    }
                }

                public void onAdClicked() {
                    AdLogUtil.Log().d(AdxInterstitia.TAG, "interstitia is click");
                    AutomatedLogUtil.AutomatedRecord((String)AdxInterstitia.AD_PLATFORM, (String)AdxInterstitia.this.mPlacementId, (String)AdxInterstitia.AD_POSITION, (String)"Click");
                    AdxInterstitia.this.allianceOnclick();
                    if (AdxInterstitia.this.mAdRequestBody != null && AdxInterstitia.this.mAdRequestBody.getAllianceListener() != null) {
                        AdxInterstitia.this.mAdRequestBody.getAllianceListener().onClicked();
                    }
                }

                public void onTimeOut() {
                    AdxInterstitia.this.isLoaded = true;
                    AdxInterstitia.this.allianceLoad(System.currentTimeMillis() - AdxInterstitia.this.startTime, TAdErrorCode.NETWORK_TIMEOUT_ERROR.getErrorCode(), TAdErrorCode.NETWORK_TIMEOUT_ERROR.getErrorMessage());
                    AdLogUtil.Log().e(AdxInterstitia.TAG, "interstitia is timeout, error code is " + TAdErrorCode.NETWORK_TIMEOUT_ERROR.getErrorCode() + ", error msg is " + TAdErrorCode.NETWORK_TIMEOUT_ERROR.getErrorMessage());
                    if (AdxInterstitia.this.mAdRequestBody != null && AdxInterstitia.this.mAdRequestBody.getAllianceListener() != null) {
                        AdxInterstitia.this.mAdRequestBody.getAllianceListener().onAllianceError(TAdErrorCode.NETWORK_TIMEOUT_ERROR);
                    }
                }
            }).showByApk(true).build();
            this.mInterstitialAd.setAdRequest(tAdRequest);
            if (this.mInterstitialAd != null && !this.mInterstitialAd.isLoaded()) {
                this.mInterstitialAd.loadAd();
                this.startTime = System.currentTimeMillis();
                this.allianceStart();
            }
        }
    }

    public void show() {
        if (this.mInterstitialAd != null && this.mInterstitialAd.isLoaded()) {
            this.mInterstitialAd.show();
            this.allianceShow();
            AdLogUtil.Log().d(TAG, "adx interstitial ad show");
            AutomatedLogUtil.AutomatedRecord((String)AD_PLATFORM, (String)this.mPlacementId, (String)AD_POSITION, (String)"Show");
            if (this.mAdRequestBody != null && this.mAdRequestBody.getAllianceListener() != null) {
                this.mAdRequestBody.getAllianceListener().onShow();
            }
        } else {
            AdLogUtil.Log().d(TAG, "adx interstitial is not ready");
        }
    }

    public boolean isLoaded() {
        return this.mInterstitialAd != null && this.mInterstitialAd.isLoaded();
    }

    public void destroyAd() {
        super.destroyAd();
        if (this.mInterstitialAd != null) {
            this.mInterstitialAd.destroy();
            this.mInterstitialAd = null;
            AdLogUtil.Log().d(TAG, "adx interstitial destroy");
        }
    }
}

