/*
 * Decompiled with CFR 0.152.
 */
package com.zero.adxlibrary.excuter;

import android.content.Context;
import com.zero.common.base.BaseBanner;
import com.zero.common.bean.TAdErrorCode;
import com.zero.common.bean.TrackInfor;
import com.zero.common.utils.AdLogUtil;
import com.zero.ta.api.adx.ABannerView;
import com.zero.ta.common.callback.TaListener;
import com.zero.ta.common.callback.TaRequest;
import com.zero.ta.common.constant.TaErrorCode;

public class AdxBanner
extends BaseBanner<ABannerView> {
    private static final String TAG = "AdxBanner";
    private ABannerView tAdBannerView;
    private int mBannerSize;

    public AdxBanner(Context context, String cid, String mPlacementId, int mBannerSize) {
        this(context, cid, mPlacementId, mBannerSize, null);
    }

    public AdxBanner(Context context, String cid, String mPlacementId, int mBannerSize, TrackInfor track) {
        super(context, cid, mPlacementId, track);
        this.mBannerSize = mBannerSize;
        AdLogUtil.Log().d(TAG, "placemen id:=" + mPlacementId + ",bannerSize:=" + mBannerSize);
    }

    protected ABannerView getBanner() {
        if (this.tAdBannerView == null && this.mContext != null && this.mContext.get() != null) {
            this.tAdBannerView = new ABannerView((Context)this.mContext.get(), this.mPlacementId);
            TaRequest tAdRequest = new TaRequest.TaRequestBuild().setListener(new TaListener(){

                public void onError(TaErrorCode adError) {
                    AdLogUtil.Log().d(AdxBanner.TAG, "banner is Load error:" + adError.getErrorCode() + " msg:" + adError.getErrorMessage());
                    AdxBanner.this.adFailedToLoad(new TAdErrorCode(adError.getErrorCode(), adError.getErrorMessage()));
                }

                public void onAdLoaded() {
                    AdLogUtil.Log().d(AdxBanner.TAG, "banner is Loaded");
                    AdxBanner.this.adLoaded();
                }

                public void onAdClicked() {
                    AdLogUtil.Log().d(AdxBanner.TAG, "banner is click");
                    AdxBanner.this.adClicked();
                }

                public void onAdClosed() {
                    AdLogUtil.Log().d(AdxBanner.TAG, "banner onAdClosed");
                    AdxBanner.this.adClosed();
                }

                public void onTimeOut() {
                    AdLogUtil.Log().d(AdxBanner.TAG, "banner onTimeOut");
                    AdxBanner.this.adFailedToLoad(TAdErrorCode.NETWORK_TIMEOUT_ERROR);
                }
            }).build();
            this.tAdBannerView.setAdRequest(tAdRequest);
        }
        return this.tAdBannerView;
    }

    protected void onBannerLoad() {
        if (this.tAdBannerView != null) {
            this.tAdBannerView.loadAd();
        }
        AdLogUtil.Log().d(TAG, "adx banner load mPlacementId:" + this.mPlacementId);
    }

    protected void onBannerShow() {
        if (this.tAdBannerView != null) {
            this.tAdBannerView.show();
        }
    }

    protected void onBannerDestroy() {
        if (this.tAdBannerView != null) {
            this.tAdBannerView.destroy();
            this.tAdBannerView = null;
            AdLogUtil.Log().d(TAG, "banner destroy");
        }
    }
}

