/*
 * Decompiled with CFR 0.152.
 */
package com.zero.adxlibrary.excuter;

import android.content.Context;
import com.zero.common.base.BaseInterstitial;
import com.zero.common.bean.TAdErrorCode;
import com.zero.common.bean.TrackInfor;
import com.zero.common.utils.AdLogUtil;
import com.zero.ta.api.adx.AInterstitial;
import com.zero.ta.common.callback.TaListener;
import com.zero.ta.common.callback.TaRequest;
import com.zero.ta.common.constant.TaErrorCode;

public class AdxInterstitia
extends BaseInterstitial {
    private static final String TAG = "AdxInterstitia";
    private AInterstitial mInterstitialAd;

    public AdxInterstitia(Context context, String cid, String mPlacementId) {
        this(context, cid, mPlacementId, null);
    }

    public AdxInterstitia(Context context, String cid, String placementId, TrackInfor track) {
        super(context, cid, placementId, track);
        AdLogUtil.Log().d(TAG, "placemen id:=" + this.mPlacementId);
    }

    protected void onInterstitialStartLoad() {
        if (this.mInterstitialAd != null && !this.mInterstitialAd.isLoaded()) {
            this.mInterstitialAd.loadAd();
        }
        AdLogUtil.Log().d(TAG, "adx mInterstitialAd load mPlacementId:" + this.mPlacementId);
    }

    protected void initInterstitial() {
        if (this.mInterstitialAd == null && this.mContext != null && this.mContext.get() != null) {
            this.mInterstitialAd = new AInterstitial((Context)this.mContext.get(), this.mPlacementId);
            TaRequest tAdRequest = new TaRequest.TaRequestBuild().setListener(new TaListener(){

                public void onError(TaErrorCode adError) {
                    AdLogUtil.Log().d(AdxInterstitia.TAG, "interstitial onError:errorCode:" + adError.getErrorCode() + ",errorMessage:" + adError.getErrorMessage());
                    AdxInterstitia.this.adFailedToLoad(new TAdErrorCode(adError.getErrorCode(), adError.getErrorMessage()));
                }

                public void onAdClosed() {
                    AdLogUtil.Log().d(AdxInterstitia.TAG, "interstitial is closed");
                    AdxInterstitia.this.adClosed();
                }

                public void onAdLoaded() {
                    AdLogUtil.Log().d(AdxInterstitia.TAG, "interstitial is Loaded");
                    AdxInterstitia.this.adLoaded();
                }

                public void onAdClicked() {
                    AdLogUtil.Log().d(AdxInterstitia.TAG, "interstitial is click");
                    AdxInterstitia.this.adClicked();
                }

                public void onTimeOut() {
                    AdxInterstitia.this.adFailedToLoad(TAdErrorCode.NETWORK_TIMEOUT_ERROR);
                }
            }).showByApk(true).build();
            this.mInterstitialAd.setAdRequest(tAdRequest);
        }
    }

    public boolean isExpired() {
        return super.isExpired();
    }

    protected void onInterstitialShow() {
        if (this.mInterstitialAd != null) {
            this.mInterstitialAd.show();
        }
    }

    public boolean isLoaded() {
        return this.mInterstitialAd != null && this.mInterstitialAd.isLoaded();
    }

    public void destroyAd() {
        super.destroyAd();
        if (this.mInterstitialAd != null) {
            this.mInterstitialAd.destroy();
            this.mInterstitialAd = null;
            AdLogUtil.Log().d(TAG, "adx interstitial destroy");
        }
    }
}

