/*
 * Decompiled with CFR 0.152.
 */
package com.zero.adxlibrary.excuter;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import com.zero.adxlibrary.util.NativeInfoTransfer;
import com.zero.common.base.BaseNative;
import com.zero.common.bean.TAdErrorCode;
import com.zero.common.bean.TAdNativeInfo;
import com.zero.common.bean.TrackInfor;
import com.zero.common.utils.AdLogUtil;
import com.zero.common.utils.AdUtil;
import com.zero.ta.api.adx.ANative;
import com.zero.ta.common.bean.TaNativeInfo;
import com.zero.ta.common.callback.TaListener;
import com.zero.ta.common.callback.TaRequest;
import com.zero.ta.common.constant.TaErrorCode;
import java.util.List;

public class AdxNative
extends BaseNative {
    private String TAG = "AdxNative";
    private int defaultAdsCount = 1;
    private ANative mNativeAd;

    public AdxNative(Context context, String cid, String placementId, int mAdsCount, int adt, TrackInfor track) {
        super(context, cid, placementId, adt, track);
        this.mAdNumber = mAdsCount <= 0 ? this.defaultAdsCount : mAdsCount;
    }

    protected void onNativeAdStartLoad() {
        if (this.mNativeAd != null) {
            this.mNativeAd.loadAd();
        }
        AdLogUtil.Log().d(this.TAG, "adx native load mPlacementId:" + this.mPlacementId + " num:" + this.mAdNumber);
    }

    protected void initNative() {
        if (this.mContext != null && this.mContext.get() != null) {
            this.mNatives.clear();
            this.mNativeAd = new ANative((Context)this.mContext.get(), this.mPlacementId, this.mAdNumber);
            TaRequest tAdRequest = new TaRequest.TaRequestBuild().cacheBigImage(!this.isNativeBanner()).setListener(new TaListener(){

                public void onError(TaErrorCode adxError) {
                    AdxNative.this.adFailedToLoad(new TAdErrorCode(adxError.getErrorCode(), adxError.getErrorMessage()));
                }

                public void onAdLoaded(TaNativeInfo adxNativeInfo) {
                    AdLogUtil.Log().d(AdxNative.this.TAG, "onAdLoaded single ad");
                    TAdNativeInfo nativeInfo = NativeInfoTransfer.getTAdNativeInfo(adxNativeInfo, AdxNative.this.mAdt, AdxNative.this.getTtl(), AdxNative.this);
                    int filter = AdxNative.this.filter(nativeInfo);
                    if (filter == 0) {
                        AdxNative.this.mNatives.add(nativeInfo);
                    } else {
                        AdUtil.release((TAdNativeInfo)nativeInfo);
                    }
                    if (AdxNative.this.mNatives.size() > 0) {
                        AdxNative.this.adLoaded(AdxNative.this.mNatives);
                    } else {
                        AdxNative.this.adFailedToLoad(new TAdErrorCode(filter, "ad filter"));
                        AdLogUtil.Log().e(AdxNative.this.TAG, "ad not pass sensitive check or no icon or image filter:" + filter);
                    }
                }

                public void onAdLoaded(List<TaNativeInfo> adxNativeInfos) {
                    AdLogUtil.Log().d(AdxNative.this.TAG, "onAdLoaded multi");
                    int filter = 0;
                    for (int i = 0; i < adxNativeInfos.size(); ++i) {
                        TAdNativeInfo tAdNativeInfo = NativeInfoTransfer.getTAdNativeInfo(adxNativeInfos.get(i), AdxNative.this.mAdt, AdxNative.this.getTtl(), AdxNative.this);
                        filter = AdxNative.this.filter(tAdNativeInfo);
                        if (filter == 0) {
                            AdxNative.this.mNatives.add(tAdNativeInfo);
                            continue;
                        }
                        AdUtil.release((TAdNativeInfo)tAdNativeInfo);
                    }
                    if (AdxNative.this.mNatives.size() > 0) {
                        AdxNative.this.adLoaded(AdxNative.this.mNatives);
                    } else {
                        AdxNative.this.adFailedToLoad(new TAdErrorCode(filter, "ad filter"));
                        AdLogUtil.Log().e(AdxNative.this.TAG, "ad not pass sensitive check or no icon or image filter:" + filter);
                    }
                }

                public void onTimeOut() {
                    AdxNative.this.adFailedToLoad(TAdErrorCode.NETWORK_TIMEOUT_ERROR);
                }

                public void onAdShow() {
                    super.onAdShow();
                    AdxNative.this.adImpression();
                }

                public void onAdClosed() {
                    super.onAdClosed();
                    AdxNative.this.adClosed();
                }

                public void onAdClicked() {
                    AdxNative.this.adClicked();
                }
            }).build();
            this.mNativeAd.setAdRequest(tAdRequest);
        }
    }

    public void destroyAd() {
        super.destroyAd();
        if (this.mNativeAd != null) {
            this.mNativeAd.destroy();
            this.mNativeAd = null;
        }
    }

    public void registerViewForInteraction(ViewGroup viewGroup, List<View> adContains, TAdNativeInfo nativeInfo) {
        if (viewGroup != null && this.mNativeAd != null) {
            this.unregisterView(nativeInfo);
            try {
                this.mNativeAd.registerView((View)viewGroup, (TaNativeInfo)nativeInfo.getNativeAdWrapper().getNativeAd());
            }
            catch (Exception e) {
                AdLogUtil.Log().e(this.TAG, "exception .... ");
            }
        }
    }

    public void unregisterView(TAdNativeInfo info) {
        if (this.mNativeAd == null) {
            return;
        }
        try {
            TaNativeInfo tif = (TaNativeInfo)info.getNativeAdWrapper().getNativeAd();
            if (this.mNativeAd != null) {
                this.mNativeAd.unregisterViews(tif);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

