/*
 * Decompiled with CFR 0.152.
 */
package com.zero.adxlibrary.excuter;

import android.content.Context;
import android.view.View;
import com.zero.common.base.BaseSplash;
import com.zero.common.bean.TAdErrorCode;
import com.zero.common.bean.TrackInfor;
import com.zero.common.utils.AdLogUtil;
import com.zero.ta.api.adx.ASplash;
import com.zero.ta.common.callback.OnSkipListener;
import com.zero.ta.common.callback.TaListener;
import com.zero.ta.common.callback.TaRequest;
import com.zero.ta.common.constant.TaErrorCode;

public class AdxSplash
extends BaseSplash {
    private final String TAG = "AdxSplash";
    private ASplash splashView;

    public AdxSplash(Context context, String cid, String placementId, TrackInfor track) {
        super(context, cid, placementId, track);
    }

    protected void onSplashStartLoad() {
        if (this.splashView != null) {
            this.splashView.loadAd();
        }
        AdLogUtil.Log().d("AdxSplash", "adx splashview load mPlacementId:" + this.mPlacementId);
    }

    protected View getSplash() {
        if (this.splashView == null && this.mContext != null && this.mContext.get() != null) {
            this.splashView = new ASplash((Context)this.mContext.get(), this.mPlacementId);
            this.splashView.setFlag(1);
            this.splashView.setAdRequest(new TaRequest.TaRequestBuild().setListener(new TaListener(){

                public void onAdLoaded() {
                    AdxSplash.this.adLoaded();
                    AdLogUtil.Log().d("AdxSplash", "adx splashview onAdLoaded");
                }

                public void onAdClosed() {
                    AdxSplash.this.adClosed();
                }

                public void onAdShow() {
                    AdLogUtil.Log().d("AdxSplash", "adx splashview onAdShow");
                }

                public void onAdClicked() {
                    AdxSplash.this.adClicked();
                    AdLogUtil.Log().d("AdxSplash", "adx splashview onAdClicked");
                }

                public void onError(TaErrorCode tAdError) {
                    AdxSplash.this.adFailedToLoad(new TAdErrorCode(tAdError.getErrorCode(), tAdError.getErrorMessage()));
                    AdLogUtil.Log().d("AdxSplash", "adx splashview onError:" + tAdError.toString());
                }

                public void onTimeOut() {
                    AdxSplash.this.adFailedToLoad(TAdErrorCode.NETWORK_TIMEOUT_ERROR);
                    AdLogUtil.Log().d("AdxSplash", "adx splashview onTimeOut");
                }
            }).build());
        }
        return this.splashView;
    }

    protected void onSplashShow() {
        this.splashView.show(null);
    }

    public void destroyAd() {
        super.destroyAd();
        if (this.splashView != null) {
            this.splashView.destroy();
            this.splashView = null;
        }
    }

    public void setOnSkipListener(final com.zero.common.interfacz.OnSkipListener listener) {
        if (this.splashView != null) {
            this.splashView.setSkipListener(new OnSkipListener(){

                public void onClick() {
                    if (listener != null) {
                        listener.onClick();
                    }
                }

                public void onTimeEnd() {
                    if (listener != null) {
                        listener.onTimeReach();
                    }
                }
            });
        }
    }
}

