/*
 * Decompiled with CFR 0.152.
 */
package com.zero.common.base;

import android.content.Context;
import android.os.Handler;
import com.zero.common.bean.InterceptAdapter;
import com.zero.common.bean.TAdErrorCode;
import com.zero.common.bean.TAdNativeInfo;
import com.zero.common.bean.TAdRequestBody;
import com.zero.common.bean.TrackInfor;
import com.zero.common.constant.Constants;
import com.zero.common.event.EventTrack;
import com.zero.common.interfacz.Iad;
import com.zero.common.interfacz.TAdAllianceListener;
import com.zero.common.utils.AdLogUtil;
import com.zero.common.utils.AutomatedLogUtil;
import com.zero.common.utils.RunTimer;
import java.lang.ref.WeakReference;
import java.util.List;

public abstract class BaseAd
implements Iad {
    protected WeakReference<Context> mContext;
    protected String mPlacementId;
    protected String mCid;
    private String TAG = "BaseAd";
    private TrackInfor trackInfor;
    private int priority = Integer.MAX_VALUE;
    private int ttl;
    private int adSource;
    private long startTime;
    protected TAdRequestBody mAdRequestBody;
    private int delay;
    protected boolean isLoaded = false;
    private RunTimer runTimer;
    private TAdAllianceListener listener;
    private RunTimer.TimeOutCallback timeOutCallback = new RunTimer.TimeOutCallback(){

        @Override
        public void isTimeOut() {
            AdLogUtil.Log().d(BaseAd.this.TAG, "Load ad is time out");
            BaseAd.this.onTimeOut();
        }
    };

    public BaseAd(Context context, String string, String string2, TrackInfor trackInfor) {
        if (trackInfor != null) {
            this.trackInfor = trackInfor;
        }
        this.mContext = new WeakReference<Context>(context);
        this.mPlacementId = string2;
        this.mCid = string;
    }

    @Override
    public void loadAd() {
        this.startTime = System.currentTimeMillis();
        this.logRequest();
        if (this.listener != null) {
            this.listener.onAllianceStart();
        }
        if (this.supportTimer()) {
            this.startTimer();
        }
    }

    @Override
    public void setId(String string) {
    }

    public void adLoaded() {
        this.isLoaded = true;
        this.onAdLoaded();
        this.logOnLoaded(0);
        if (this.listener != null) {
            this.listener.onAllianceLoad();
        } else {
            this.destroyAd();
        }
        if (this.supportTimer()) {
            this.stopTimer();
        }
    }

    protected void onAdLoaded() {
    }

    public void adLoaded(List<TAdNativeInfo> list) {
        this.isLoaded = true;
        this.onAdLoaded(list);
        this.logOnLoaded(0);
        if (this.listener != null) {
            this.listener.onAllianceLoad(list);
        } else {
            this.destroyAd();
        }
        if (this.supportTimer()) {
            this.stopTimer();
        }
    }

    protected void onAdLoaded(List<TAdNativeInfo> list) {
    }

    protected void adFailedToLoad(TAdErrorCode tAdErrorCode) {
        this.isLoaded = true;
        int n = tAdErrorCode.getErrorCode();
        if (n == 0) {
            n = 100;
        }
        this.onAdFailedToLoad(tAdErrorCode);
        this.logOnLoaded(n);
        if (this.listener != null) {
            this.listener.onAllianceError(tAdErrorCode);
        }
        if (this.supportTimer()) {
            this.stopTimer();
        }
        this.destroyAd();
    }

    protected void onAdFailedToLoad(TAdErrorCode tAdErrorCode) {
    }

    protected void adImpression() {
        this.onAdImpression();
        this.logImpression();
        if (this.listener != null) {
            this.listener.onShow();
        }
    }

    protected void onAdImpression() {
    }

    protected void adClicked() {
        this.onAdClicked();
        this.logClick();
        if (this.listener != null) {
            this.listener.onClicked();
        }
    }

    private void onAdClicked() {
    }

    protected void nativeVideoPlay(String string) {
        this.logNativeVideoClick(string);
    }

    protected void adClosed() {
        this.onAdClosed();
        AutomatedLogUtil.AutomatedRecord(Constants.getAdType(this.getAdType()), this.mPlacementId, Constants.getSourceName(this.getAdSource()), "Closed");
        if (this.listener != null) {
            this.listener.onClosed();
        }
    }

    protected void onAdClosed() {
    }

    protected void adRewarded() {
        this.onAdRewarded();
        this.logRewarded();
        if (this.listener != null) {
            this.listener.onRewarded();
        }
    }

    protected void onAdRewarded() {
    }

    protected void adClickIntercept(InterceptAdapter interceptAdapter) {
        if (this.mAdRequestBody != null && this.mAdRequestBody.getAllianceListener() != null) {
            this.mAdRequestBody.getAllianceListener().onClickIntercept(interceptAdapter);
        }
    }

    protected void logRequest() {
        AutomatedLogUtil.AutomatedRecord(Constants.getAdType(this.getAdType()), this.mPlacementId, Constants.getSourceName(this.getAdSource()), "LoadAd");
        EventTrack.getInstance().logEventNetworkReq(this.trackInfor);
    }

    protected void logOnLoaded(int n) {
        AutomatedLogUtil.AutomatedRecord(Constants.getAdType(this.getAdType()), this.mPlacementId, Constants.getSourceName(this.getAdSource()), "Loaded");
        long l = System.currentTimeMillis() - this.startTime;
        if (this.trackInfor != null) {
            this.trackInfor.setCode(n);
            this.trackInfor.setCost(l);
            EventTrack.getInstance().logEventNetworkFill(this.trackInfor);
        }
    }

    protected void logImpression() {
        AutomatedLogUtil.AutomatedRecord(Constants.getAdType(this.getAdType()), this.mPlacementId, Constants.getSourceName(this.getAdSource()), "Impression");
        EventTrack.getInstance().logEventNetworkImp(this.trackInfor);
    }

    protected void logClick() {
        AutomatedLogUtil.AutomatedRecord(Constants.getAdType(this.getAdType()), this.mPlacementId, Constants.getSourceName(this.getAdSource()), "Click");
        EventTrack.getInstance().logEventNetworkClick(this.trackInfor);
    }

    protected void logNativeVideoClick(String string) {
        AutomatedLogUtil.AutomatedRecord(Constants.getAdType(this.getAdType()), this.mPlacementId, Constants.getSourceName(this.getAdSource()), "NativeVideoPlay");
        EventTrack.getInstance().logNativeVideoPlay(this.trackInfor, string);
    }

    private void logRewarded() {
        AutomatedLogUtil.AutomatedRecord(Constants.getAdType(this.getAdType()), this.mPlacementId, Constants.getSourceName(this.getAdSource()), "Rewarded");
        EventTrack.getInstance().logRewardedImpl(this.trackInfor);
    }

    @Override
    public void destroyAd() {
        this.mContext = null;
        this.trackInfor = null;
        this.mAdRequestBody = null;
        this.listener = null;
        this.stopTimer();
    }

    @Override
    public void setRequestBody(TAdRequestBody tAdRequestBody) {
        this.mAdRequestBody = tAdRequestBody;
        if (tAdRequestBody != null) {
            this.listener = tAdRequestBody.getAllianceListener();
        }
    }

    @Override
    public TAdRequestBody getRequestBody() {
        return this.mAdRequestBody;
    }

    public void setPriority(int n) {
        this.priority = n;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    public int getTtl() {
        return this.ttl;
    }

    public void setTtl(int n) {
        this.ttl = n;
    }

    @Override
    public boolean isExpired() {
        return this.getValidTimeLimit() <= 0L;
    }

    @Override
    public long getValidTimeLimit() {
        if (this.ttl <= 0) {
            return Long.MAX_VALUE;
        }
        return (long)(this.ttl * 60 * 1000) - Math.abs(System.currentTimeMillis() - this.startTime);
    }

    @Override
    public int getAdSource() {
        return this.adSource;
    }

    @Override
    public void setAdSource(int n) {
        this.adSource = n;
    }

    @Override
    public int getDelay() {
        return this.delay;
    }

    @Override
    public void setDelay(int n) {
        this.delay = n;
    }

    @Override
    public String getPlacementId() {
        return this.mPlacementId;
    }

    @Override
    public String getCid() {
        return this.mCid;
    }

    @Override
    public void stopLoader() {
        if (this.isLoaded) {
            return;
        }
        this.destroyAd();
    }

    protected boolean supportTimer() {
        return false;
    }

    protected void startTimer() {
        if (this.runTimer == null) {
            this.runTimer = new RunTimer();
            this.runTimer.setScheduleTime(120000);
            this.runTimer.setTimeOutCallback(this.timeOutCallback);
        }
        this.runTimer.runTimerTask();
        AdLogUtil.Log().d(this.TAG, "\u542f\u52a8\u5e7f\u544a\u8bf7\u6c42\u8d85\u65f6\u76d1\u542c...");
    }

    protected void stopTimer() {
        if (this.runTimer != null) {
            this.runTimer.resetTimerTask();
            this.runTimer = null;
        }
    }

    public void onTimeOut() {
        this.isLoaded = true;
        this.adFailedToLoad(TAdErrorCode.NETWORK_TIMEOUT_ERROR);
        this.destroyAd();
    }

    public void post(Handler handler, Runnable runnable) {
        if (handler != null) {
            handler.post(runnable);
        } else {
            runnable.run();
        }
    }
}

