/*
 * Decompiled with CFR 0.152.
 */
package com.zero.common.base;

import android.content.Context;
import com.zero.common.base.BaseAd;
import com.zero.common.bean.TAdNativeInfo;
import com.zero.common.bean.TrackInfor;
import com.zero.common.interfacz.IadNative;
import com.zero.common.utils.AdLogUtil;
import com.zero.common.utils.SensitiveUtil;
import java.util.ArrayList;
import java.util.List;

public abstract class BaseNative
extends BaseAd
implements IadNative {
    private String TAG = "BaseNative";
    protected int mAdt;
    protected List<TAdNativeInfo> mNatives = new ArrayList<TAdNativeInfo>();
    protected int mAdNumber;
    protected static final int FILTER_NONE = 0;

    public BaseNative(Context context, String string, String string2, int n, TrackInfor trackInfor) {
        super(context, string, string2, trackInfor);
        this.mAdt = n;
    }

    @Override
    public void setId(String string) {
        this.mPlacementId = string;
        AdLogUtil.Log().d(this.TAG, "placement id =" + this.mPlacementId);
    }

    @Override
    public void loadAd() {
        super.loadAd();
        this.mNatives.clear();
        this.initNative();
        this.onNativeAdStartLoad();
    }

    protected abstract void onNativeAdStartLoad();

    protected abstract void initNative();

    protected boolean isNativeBanner() {
        return this.mAdt == 4;
    }

    @Override
    public void adLoaded(List<TAdNativeInfo> list) {
        super.adLoaded(list);
    }

    @Override
    protected void onAdLoaded(List<TAdNativeInfo> list) {
        super.onAdLoaded(list);
    }

    protected int filter(TAdNativeInfo tAdNativeInfo) {
        if (tAdNativeInfo == null) {
            return 9033;
        }
        if (SensitiveUtil.isSensitive(tAdNativeInfo)) {
            AdLogUtil.Log().e(this.TAG, "ad is filter title:" + tAdNativeInfo.getTitle() + " dec:" + tAdNativeInfo.getDescription());
            return 9001;
        }
        if (this.isNativeBanner()) {
            boolean bl = tAdNativeInfo.isIconValid();
            AdLogUtil.Log().e(this.TAG, "ad nativebanner has icon:" + bl);
            return bl ? 0 : 9032;
        }
        boolean bl = tAdNativeInfo.isMaterielValid();
        AdLogUtil.Log().e(this.TAG, "ad nativebanner has meteriel:" + bl);
        return bl ? 0 : 9032;
    }

    @Override
    public int getAdType() {
        return this.mAdt;
    }

    @Override
    public void destroyAd() {
        super.destroyAd();
        for (TAdNativeInfo tAdNativeInfo : this.mNatives) {
            if (tAdNativeInfo == null) continue;
            tAdNativeInfo.release();
        }
        this.mNatives.clear();
    }

    public void setChoicesPosition(int n) {
    }
}

