/*
 * Decompiled with CFR 0.152.
 */
package com.zero.common.utils;

import android.support.annotation.IntRange;
import android.support.annotation.NonNull;
import android.support.annotation.RestrictTo;
import android.text.TextUtils;
import java.util.Collection;
import java.util.Locale;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class Preconditions {
    public static void checkArgument(boolean bl) {
        if (!bl) {
            throw new IllegalArgumentException();
        }
    }

    public static void checkArgument(boolean bl, Object object) {
        if (!bl) {
            throw new IllegalArgumentException(String.valueOf(object));
        }
    }

    @NonNull
    public static <T extends CharSequence> T checkStringNotEmpty(T t) {
        if (TextUtils.isEmpty(t)) {
            throw new IllegalArgumentException();
        }
        return t;
    }

    @NonNull
    public static <T extends CharSequence> T checkStringNotEmpty(T t, Object object) {
        if (TextUtils.isEmpty(t)) {
            throw new IllegalArgumentException(String.valueOf(object));
        }
        return t;
    }

    @NonNull
    public static <T> T checkNotNull(T t) {
        if (t == null) {
            throw new NullPointerException();
        }
        return t;
    }

    @NonNull
    public static <T> T checkNotNull(T t, Object object) {
        if (t == null) {
            throw new NullPointerException(String.valueOf(object));
        }
        return t;
    }

    public static void checkState(boolean bl, String string) {
        if (!bl) {
            throw new IllegalStateException(string);
        }
    }

    public static void checkState(boolean bl) {
        Preconditions.checkState(bl, null);
    }

    public static int checkFlagsArgument(int n, int n2) {
        if ((n & n2) != n) {
            throw new IllegalArgumentException("Requested flags 0x" + Integer.toHexString(n) + ", but only 0x" + Integer.toHexString(n2) + " are allowed");
        }
        return n;
    }

    @IntRange(from=0L)
    public static int checkArgumentNonnegative(int n, String string) {
        if (n < 0) {
            throw new IllegalArgumentException(string);
        }
        return n;
    }

    @IntRange(from=0L)
    public static int checkArgumentNonnegative(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        return n;
    }

    public static long checkArgumentNonnegative(long l) {
        if (l < 0L) {
            throw new IllegalArgumentException();
        }
        return l;
    }

    public static long checkArgumentNonnegative(long l, String string) {
        if (l < 0L) {
            throw new IllegalArgumentException(string);
        }
        return l;
    }

    public static int checkArgumentPositive(int n, String string) {
        if (n <= 0) {
            throw new IllegalArgumentException(string);
        }
        return n;
    }

    public static float checkArgumentFinite(float f, String string) {
        if (Float.isNaN(f)) {
            throw new IllegalArgumentException(string + " must not be NaN");
        }
        if (Float.isInfinite(f)) {
            throw new IllegalArgumentException(string + " must not be infinite");
        }
        return f;
    }

    public static float checkArgumentInRange(float f, float f2, float f3, String string) {
        if (Float.isNaN(f)) {
            throw new IllegalArgumentException(string + " must not be NaN");
        }
        if (f < f2) {
            throw new IllegalArgumentException(String.format(Locale.US, "%s is out of range of [%f, %f] (too low)", string, Float.valueOf(f2), Float.valueOf(f3)));
        }
        if (f > f3) {
            throw new IllegalArgumentException(String.format(Locale.US, "%s is out of range of [%f, %f] (too high)", string, Float.valueOf(f2), Float.valueOf(f3)));
        }
        return f;
    }

    public static int checkArgumentInRange(int n, int n2, int n3, String string) {
        if (n < n2) {
            throw new IllegalArgumentException(String.format(Locale.US, "%s is out of range of [%d, %d] (too low)", string, n2, n3));
        }
        if (n > n3) {
            throw new IllegalArgumentException(String.format(Locale.US, "%s is out of range of [%d, %d] (too high)", string, n2, n3));
        }
        return n;
    }

    public static long checkArgumentInRange(long l, long l2, long l3, String string) {
        if (l < l2) {
            throw new IllegalArgumentException(String.format(Locale.US, "%s is out of range of [%d, %d] (too low)", string, l2, l3));
        }
        if (l > l3) {
            throw new IllegalArgumentException(String.format(Locale.US, "%s is out of range of [%d, %d] (too high)", string, l2, l3));
        }
        return l;
    }

    public static <T> T[] checkArrayElementsNotNull(T[] TArray, String string) {
        if (TArray == null) {
            throw new NullPointerException(string + " must not be null");
        }
        for (int i = 0; i < TArray.length; ++i) {
            if (TArray[i] != null) continue;
            throw new NullPointerException(String.format(Locale.US, "%s[%d] must not be null", string, i));
        }
        return TArray;
    }

    @NonNull
    public static <C extends Collection<T>, T> C checkCollectionElementsNotNull(C c, String string) {
        if (c == null) {
            throw new NullPointerException(string + " must not be null");
        }
        long l = 0L;
        for (T t : c) {
            if (t == null) {
                throw new NullPointerException(String.format(Locale.US, "%s[%d] must not be null", string, l));
            }
            ++l;
        }
        return c;
    }

    public static <T> Collection<T> checkCollectionNotEmpty(Collection<T> collection, String string) {
        if (collection == null) {
            throw new NullPointerException(string + " must not be null");
        }
        if (collection.isEmpty()) {
            throw new IllegalArgumentException(string + " is empty");
        }
        return collection;
    }

    public static float[] checkArrayElementsInRange(float[] fArray, float f, float f2, String string) {
        Preconditions.checkNotNull(fArray, string + " must not be null");
        for (int i = 0; i < fArray.length; ++i) {
            float f3 = fArray[i];
            if (Float.isNaN(f3)) {
                throw new IllegalArgumentException(string + "[" + i + "] must not be NaN");
            }
            if (f3 < f) {
                throw new IllegalArgumentException(String.format(Locale.US, "%s[%d] is out of range of [%f, %f] (too low)", string, i, Float.valueOf(f), Float.valueOf(f2)));
            }
            if (!(f3 > f2)) continue;
            throw new IllegalArgumentException(String.format(Locale.US, "%s[%d] is out of range of [%f, %f] (too high)", string, i, Float.valueOf(f), Float.valueOf(f2)));
        }
        return fArray;
    }
}

