/*
 * Decompiled with CFR 0.152.
 */
package com.zero.common.utils;

import android.os.Handler;
import android.os.Looper;

public class RunTimer {
    private int scheduleTime = 60000;
    private TimeOutCallback timeOutCallback;
    private Handler handler = new Handler();
    private Runnable mTimeoutRunnable;

    public void setScheduleTime(int n) {
        this.scheduleTime = n;
    }

    public void setTimeOutCallback(TimeOutCallback timeOutCallback) {
        this.timeOutCallback = timeOutCallback;
    }

    public void runTimerTask() {
        if (this.handler == null) {
            this.handler = new Handler(Looper.getMainLooper());
        }
        if (this.mTimeoutRunnable == null) {
            this.mTimeoutRunnable = new Runnable(){

                @Override
                public void run() {
                    if (RunTimer.this.timeOutCallback != null) {
                        RunTimer.this.timeOutCallback.isTimeOut();
                    }
                }
            };
        }
        try {
            this.handler.postDelayed(this.mTimeoutRunnable, (long)this.scheduleTime);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public void resetTimerTask() {
        this.timeOutCallback = null;
        if (this.handler != null) {
            this.handler.removeCallbacksAndMessages(null);
            this.handler = null;
        }
        this.mTimeoutRunnable = null;
    }

    public static interface TimeOutCallback {
        public void isTimeOut();
    }
}

