/*
 * Decompiled with CFR 0.152.
 */
package com.zero.common.base;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import com.zero.common.base.BaseAd;
import com.zero.common.bean.TAdErrorCode;
import com.zero.common.bean.TrackInfor;
import com.zero.common.interfacz.IadView;
import com.zero.common.utils.AdLogUtil;
import com.zero.common.widget.WrapTadView;
import com.zero.ta.common.gif.ICustomGifView;

public abstract class BaseBanner<T extends View>
extends BaseAd
implements IadView {
    private String TAG = "BaseBanner";

    public BaseBanner(Context context, String string, String string2, TrackInfor trackInfor) {
        super(context, string, string2, trackInfor);
    }

    @Override
    public void setId(String string) {
        this.mPlacementId = string;
        AdLogUtil.Log().d(this.TAG, "placement id =" + this.mPlacementId);
    }

    @Override
    public int getAdType() {
        return 1;
    }

    @Override
    public void loadAd() {
        if (this.getBanner() != null) {
            BaseBanner baseBanner = this;
            super.loadAd();
            baseBanner.onBannerLoad();
        }
    }

    protected abstract T getBanner();

    protected abstract void onBannerLoad();

    @Override
    public void adLoaded() {
        if (!this.isLoaded) {
            super.adLoaded();
        } else {
            AdLogUtil.Log().e(this.TAG, "banner have been Loaded, but refresh banner success ");
        }
    }

    @Override
    protected void adFailedToLoad(TAdErrorCode tAdErrorCode) {
        if (!this.isLoaded) {
            super.adFailedToLoad(tAdErrorCode);
        } else {
            AdLogUtil.Log().e(this.TAG, "banner have been Loaded, but refresh banner failed ");
        }
    }

    @Override
    public void show(WrapTadView wrapTadView, ICustomGifView iCustomGifView, int n, long l) {
        this.mAdFrom = n;
        this.mLoadedTime = l;
        T t = this.getBanner();
        if (t != null) {
            boolean bl = !this.isExpired();
            BaseBanner baseBanner = this;
            this.logTrigerShow(bl);
            wrapTadView.onAddView((View)t);
            baseBanner.onBannerShow(iCustomGifView);
            baseBanner.adImpression();
        } else {
            AdLogUtil.Log().e(this.TAG, "banner is null ");
        }
    }

    protected abstract void onBannerShow(ICustomGifView var1);

    protected abstract void onBannerDestroy();

    @Override
    public void destroyAd() {
        BaseBanner baseBanner = this;
        super.destroyAd();
        baseBanner.isLoaded = false;
        T t = baseBanner.getBanner();
        if (t != null) {
            ViewParent viewParent = t.getParent();
            if (viewParent != null && viewParent instanceof ViewGroup) {
                ((ViewGroup)viewParent).removeView(t);
            }
            this.onBannerDestroy();
        }
        AdLogUtil.Log().d(this.TAG, "destroy");
    }
}

