/*
 * Decompiled with CFR 0.152.
 */
package com.zero.common.base;

import android.content.Context;
import android.util.Log;
import com.zero.common.base.BaseAd;
import com.zero.common.bean.TrackInfor;
import com.zero.common.interfacz.IadInterstitial;
import com.zero.common.utils.AdLogUtil;
import java.lang.ref.WeakReference;

public abstract class BaseInterstitial<T>
extends BaseAd
implements IadInterstitial {
    private String TAG = "BaseInterstitial";

    public BaseInterstitial(Context context, String string, String string2, TrackInfor trackInfor) {
        super(context, string, string2, trackInfor);
    }

    public void setContext(Context context) {
        if (context == null) {
            return;
        }
        this.mContext = new WeakReference<Context>(context);
    }

    @Override
    public void setId(String string) {
        this.mPlacementId = string;
        AdLogUtil.Log().d(this.TAG, "placement id =" + this.mPlacementId);
    }

    @Override
    public int getAdType() {
        return 2;
    }

    @Override
    public void onResume() {
    }

    @Override
    public void loadAd() {
        BaseInterstitial baseInterstitial = this;
        super.loadAd();
        baseInterstitial.initInterstitial();
        baseInterstitial.onInterstitialStartLoad();
    }

    protected abstract void onInterstitialStartLoad();

    @Override
    public void adLoaded() {
        super.adLoaded();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void show(int n, long l) {
        this.mAdFrom = n;
        this.mLoadedTime = l;
        try {
            if (!this.isLoaded()) {
                AdLogUtil.Log().d(this.TAG, "interstitial  is not ready");
                return;
            }
            n = !this.isExpired() ? 1 : 0;
            BaseInterstitial baseInterstitial = this;
            baseInterstitial.logTrigerShow(n != 0);
            baseInterstitial.onInterstitialShow();
            super.adImpression();
            return;
        }
        catch (Throwable throwable) {
            AdLogUtil.Log().e(this.TAG, "show exception");
            AdLogUtil.Log().e(this.TAG, "interstitial show exception:" + Log.getStackTraceString((Throwable)throwable));
        }
    }

    protected abstract void initInterstitial();

    protected abstract void onInterstitialShow();

    @Override
    public void destroyAd() {
        super.destroyAd();
        AdLogUtil.Log().d(this.TAG, "destroy");
    }
}

