/*
 * Decompiled with CFR 0.152.
 */
package com.zero.common.base;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import com.zero.common.R;
import com.zero.common.bean.NativeVideoParam;
import com.zero.common.bean.TAdNativeInfo;

public abstract class BaseNativeViewHolder {
    private View iconView;
    private View choicesView;
    private View mediaView;
    private View attributionView;
    private Integer tag;

    private void removeView(View view) {
        if (view == null) {
            return;
        }
        BaseNativeViewHolder baseNativeViewHolder = view.getParent();
        if (baseNativeViewHolder != null && baseNativeViewHolder instanceof ViewGroup) {
            ((ViewGroup)baseNativeViewHolder).removeView(view);
        }
    }

    public View getContainer(ViewGroup viewGroup) {
        return null;
    }

    public Integer getTag() {
        return this.tag;
    }

    public void setTag(Integer n) {
        this.tag = n;
    }

    protected View createChoicesView(Context context, TAdNativeInfo tAdNativeInfo) {
        return null;
    }

    protected View createAttributionView(Context context, TAdNativeInfo tAdNativeInfo) {
        ImageView imageView = new ImageView(context);
        imageView.setImageDrawable(context.getResources().getDrawable(R.drawable.ad_choice));
        return imageView;
    }

    public final View getChoicesView(Context context, TAdNativeInfo tAdNativeInfo) {
        View view = this.choicesView;
        if (view == null) {
            this.choicesView = this.createChoicesView(context.getApplicationContext(), tAdNativeInfo);
        } else if (view.getParent() != null) {
            ((ViewGroup)this.choicesView.getParent()).removeView(this.choicesView);
        }
        return this.choicesView;
    }

    public final View getAttributionView(Context context, TAdNativeInfo tAdNativeInfo) {
        View view = this.attributionView;
        if (view == null) {
            this.attributionView = this.createAttributionView(context.getApplicationContext(), tAdNativeInfo);
        } else if (view.getParent() != null) {
            ((ViewGroup)this.attributionView.getParent()).removeView(this.attributionView);
        }
        return this.attributionView;
    }

    public void destroy() {
        BaseNativeViewHolder baseNativeViewHolder = this;
        baseNativeViewHolder.removeView(baseNativeViewHolder.iconView);
        baseNativeViewHolder.removeView(baseNativeViewHolder.choicesView);
        baseNativeViewHolder.removeView(baseNativeViewHolder.mediaView);
        baseNativeViewHolder.removeView(baseNativeViewHolder.attributionView);
        baseNativeViewHolder.iconView = null;
        baseNativeViewHolder.choicesView = null;
        baseNativeViewHolder.mediaView = null;
        baseNativeViewHolder.attributionView = null;
    }

    public void removePointView(View view) {
        this.removeView(view);
    }

    public void removeChoiceView() {
        BaseNativeViewHolder baseNativeViewHolder = this;
        baseNativeViewHolder.removePointView(baseNativeViewHolder.choicesView);
    }

    public void removeAttributionView() {
        BaseNativeViewHolder baseNativeViewHolder = this;
        baseNativeViewHolder.removePointView(baseNativeViewHolder.attributionView);
    }

    public void addContentView(View view) {
    }

    public void setBodyView(View view) {
    }

    public void setCallToActionView(View view) {
    }

    public void setHeadlineView(View view) {
    }

    public void setMediaView(View view) {
    }

    public void setIconView(View view) {
    }

    public void setNativeAd(TAdNativeInfo tAdNativeInfo) {
    }

    protected View createIconView(Context context) {
        return new ImageView(context);
    }

    public final View getIconView(Context context) {
        View view = this.iconView;
        if (view == null) {
            this.iconView = this.createIconView(context.getApplicationContext());
        } else {
            this.removeView(view);
        }
        return this.iconView;
    }

    public void setIconDrawable(Drawable drawable2) {
        BaseNativeViewHolder baseNativeViewHolder = baseNativeViewHolder.iconView;
        if (baseNativeViewHolder != null && baseNativeViewHolder instanceof ImageView) {
            ((ImageView)baseNativeViewHolder).setImageDrawable(drawable2);
        }
    }

    protected View createMediaView(Context context, TAdNativeInfo tAdNativeInfo, NativeVideoParam nativeVideoParam) {
        return new ImageView(context);
    }

    public final View getMediaView(Context context, TAdNativeInfo tAdNativeInfo, NativeVideoParam nativeVideoParam) {
        View view = this.mediaView;
        if (view == null) {
            this.mediaView = this.createMediaView(context.getApplicationContext(), tAdNativeInfo, nativeVideoParam);
        } else {
            this.removeView(view);
        }
        return this.mediaView;
    }
}

