/*
 * Decompiled with CFR 0.152.
 */
package com.zero.fblibrary.excuter;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import com.facebook.ads.Ad;
import com.facebook.ads.AdError;
import com.facebook.ads.AdIconView;
import com.facebook.ads.MediaView;
import com.facebook.ads.NativeAd;
import com.facebook.ads.NativeAdBase;
import com.facebook.ads.NativeAdListener;
import com.facebook.ads.NativeAdsManager;
import com.facebook.ads.NativeBannerAd;
import com.transsion.core.CoreUtil;
import com.zero.common.base.BaseNative;
import com.zero.common.bean.TAdErrorCode;
import com.zero.common.bean.TAdNativeInfo;
import com.zero.common.bean.TrackInfor;
import com.zero.common.utils.AdLogUtil;
import com.zero.common.utils.AdUtil;
import com.zero.common.utils.PackageUtil;
import com.zero.fblibrary.excuter.util.PltatformUtil;
import java.util.ArrayList;
import java.util.List;

public class FanNative
extends BaseNative {
    private String TAG = "FanNative";
    private NativeAdBase g;

    public FanNative(Context context, String string, String string2, int n) {
        this(context, string, string2, n, null);
    }

    public FanNative(Context context, String string, String string2, int n, TrackInfor trackInfor) {
        this(context, string, string2, 1, n, trackInfor);
    }

    public FanNative(Context context, String string, String string2, int n, int n2, TrackInfor trackInfor) {
        super(context, string, string2, n2, trackInfor);
        this.mAdNumber = n;
    }

    public void loadAd() {
        boolean bl;
        if (this.mContext != null && this.mContext.get() != null && !(bl = PackageUtil.checkExistFB((Context)((Context)this.mContext.get())))) {
            AdLogUtil.Log().e(this.TAG, "not exist fb application");
            this.adFailedToLoad(TAdErrorCode.NO_FB);
            return;
        }
        if (this.mAdNumber > 1 && this.mAdt == 3) {
            this.logRequest();
            this.loadAds();
        } else {
            super.loadAd();
        }
        AdLogUtil.Log().d(this.TAG, "fan native load mPlacementId:" + this.mPlacementId + " num:" + this.mAdNumber);
    }

    protected void onNativeAdStartLoad() {
        if (this.g != null) {
            this.post(PltatformUtil.handler, new Runnable(){

                @Override
                public void run() {
                    try {
                        FanNative.this.g.loadAd();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
        }
    }

    protected void initNative() {
        if (this.mContext != null && this.mContext.get() != null) {
            this.g = this.mAdt == 4 ? new NativeBannerAd(CoreUtil.getContext().getApplicationContext(), this.mPlacementId) : new NativeAd(CoreUtil.getContext().getApplicationContext(), this.mPlacementId);
            this.g.setAdListener(new NativeAdListener(){

                public void onMediaDownloaded(Ad ad) {
                    AdLogUtil.Log().d(FanNative.this.TAG, "fan native ad media download");
                }

                public void onError(Ad ad, AdError adError) {
                    AdLogUtil.Log().d(FanNative.this.TAG, "fan native is error, error code is " + adError.getErrorCode() + ", error msg is " + adError.getErrorMessage());
                    FanNative.this.adFailedToLoad(new TAdErrorCode(adError.getErrorCode(), adError.getErrorMessage()));
                }

                public void onAdLoaded(Ad ad) {
                    TAdNativeInfo tAdNativeInfo = PltatformUtil.getTAdNativeInfo(ad, FanNative.this.mAdt, FanNative.this.getTtl(), FanNative.this);
                    int n = FanNative.this.filter(tAdNativeInfo);
                    if (n == 0) {
                        FanNative.this.mNatives.add(tAdNativeInfo);
                    } else {
                        AdUtil.release((TAdNativeInfo)tAdNativeInfo);
                    }
                    if (FanNative.this.mNatives.size() > 0) {
                        FanNative.this.adLoaded(FanNative.this.mNatives);
                    } else {
                        FanNative.this.adFailedToLoad(new TAdErrorCode(n, "ad filter"));
                        AdLogUtil.Log().e(FanNative.this.TAG, "ad not pass sensitive check or no icon or image filter:" + n);
                    }
                }

                public void onAdClicked(Ad ad) {
                    AdLogUtil.Log().d(FanNative.this.TAG, "fan ad clicked");
                    FanNative.this.adClicked();
                }

                public void onLoggingImpression(Ad ad) {
                    AdLogUtil.Log().d(FanNative.this.TAG, "fan ad impression");
                    FanNative.this.adImpression();
                }
            });
        }
    }

    private void loadAds() {
        if (this.mContext != null && this.mContext.get() != null && this.mAdt != 4) {
            final NativeAdsManager nativeAdsManager = new NativeAdsManager((Context)this.mContext.get(), this.mPlacementId, this.mAdNumber);
            nativeAdsManager.setListener(new NativeAdsManager.Listener(){

                public void onAdsLoaded() {
                    AdLogUtil.Log().d(FanNative.this.TAG, "onAdsLoaded");
                    int n = 0;
                    for (int i = 0; i < nativeAdsManager.getUniqueNativeAdCount(); ++i) {
                        NativeAd nativeAd = nativeAdsManager.nextNativeAd();
                        TAdNativeInfo tAdNativeInfo = PltatformUtil.getTAdNativeInfo((Ad)nativeAd, FanNative.this.mAdt, FanNative.this.getTtl(), FanNative.this);
                        n = FanNative.this.filter(tAdNativeInfo);
                        if (n == 0) {
                            FanNative.this.mNatives.add(tAdNativeInfo);
                            continue;
                        }
                        AdUtil.release((TAdNativeInfo)tAdNativeInfo);
                    }
                    if (FanNative.this.mNatives.size() > 0) {
                        FanNative.this.adLoaded(FanNative.this.mNatives);
                    } else {
                        FanNative.this.adFailedToLoad(new TAdErrorCode(n, "ad filter"));
                        AdLogUtil.Log().e(FanNative.this.TAG, "ad not pass sensitive check or no icon or image filter:" + n);
                    }
                }

                public void onAdError(AdError adError) {
                    AdLogUtil.Log().d(FanNative.this.TAG, "adError:" + adError.getErrorCode() + "," + adError.getErrorMessage());
                    FanNative.this.adFailedToLoad(new TAdErrorCode(adError.getErrorCode(), adError.getErrorMessage()));
                }
            });
            this.post(PltatformUtil.handler, new Runnable(){

                @Override
                public void run() {
                    try {
                        nativeAdsManager.loadAds();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
        }
    }

    protected boolean supportTimer() {
        return true;
    }

    public void registerViewForInteraction(ViewGroup viewGroup, List<View> list, TAdNativeInfo tAdNativeInfo) {
        NativeAdBase nativeAdBase = (NativeAdBase)tAdNativeInfo.getNativeAdWrapper().getNativeAd();
        if (viewGroup != null && nativeAdBase != null && nativeAdBase.isAdLoaded()) {
            this.unregisterView(tAdNativeInfo);
            ArrayList<View> arrayList = new ArrayList<View>();
            PltatformUtil.findFbMediaViewAndIconView(viewGroup, arrayList);
            MediaView mediaView = null;
            AdIconView adIconView = null;
            for (View view : arrayList) {
                if (view instanceof AdIconView) {
                    adIconView = (AdIconView)view;
                    continue;
                }
                if (!(view instanceof MediaView)) continue;
                mediaView = (MediaView)view;
            }
            if (nativeAdBase instanceof NativeAd) {
                ((NativeAd)nativeAdBase).registerViewForInteraction((View)viewGroup, mediaView, adIconView, list);
            } else if (nativeAdBase instanceof NativeBannerAd) {
                ((NativeBannerAd)nativeAdBase).registerViewForInteraction((View)viewGroup, adIconView, list);
            }
        }
    }

    public void unregisterView(TAdNativeInfo tAdNativeInfo) {
        NativeAdBase nativeAdBase = (NativeAdBase)tAdNativeInfo.getNativeAdWrapper().getNativeAd();
        if (nativeAdBase != null) {
            nativeAdBase.unregisterView();
        }
    }

    public void destroyAd() {
        super.destroyAd();
        if (this.g != null) {
            this.g.setAdListener(null);
            this.g.destroy();
            this.g = null;
        }
        AdLogUtil.Log().d(this.TAG, "fan destroy");
    }
}

