/*
 * Decompiled with CFR 0.152.
 */
package com.zero.mediation.ad;

import android.content.Context;
import android.os.Looper;
import android.text.TextUtils;
import com.zero.common.base.BaseBanner;
import com.zero.common.bean.TAdErrorCode;
import com.zero.common.bean.TrackInfor;
import com.zero.common.utils.AdLogUtil;
import com.zero.common.widget.WrapTadView;
import com.zero.mediation.ad.TBaseAd;
import com.zero.mediation.bean.NetWork;
import com.zero.mediation.bean.ResponseBody;
import com.zero.mediation.handler.CacheHandler;
import com.zero.mediation.handler.banner.BannerCacheHandler;
import com.zero.mediation.handler.banner.BannerParalle;
import com.zero.mediation.handler.banner.BannerSerial;
import com.zero.mediation.interfacz.IAdParallel;
import com.zero.mediation.interfacz.IMediationBanner;
import com.zero.mediation.util.PlfmExistsUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class TBannerAd
extends TBaseAd
implements IAdParallel,
IMediationBanner {
    private String TAG = "TBannerAd";
    private int a;
    private BannerSerial b;
    private BannerSerial c;
    private int count = 0;
    private HashMap<String, BannerParalle> d = new HashMap();
    private BannerParalle e = null;
    private int f;

    public TBannerAd(Context context, String string, int n) {
        super(context, string);
        this.a = n;
        AdLogUtil.Log().d(this.TAG, "bannerSize:=" + this.a);
    }

    public TBannerAd(Context context, String string, int n, int n2) {
        super(context, string);
        this.a = n;
        this.f = n2;
        AdLogUtil.Log().d(this.TAG, "bannerSize:=" + this.a);
        AdLogUtil.Log().d(this.TAG, "bannerNum:=" + this.f);
    }

    @Override
    protected void requestMediationSuccess(ResponseBody responseBody) {
        switch (responseBody.getModel()) {
            case 1: {
                AdLogUtil.Log().d(this.TAG, "request type is serial");
                this.serialRequest(responseBody);
                break;
            }
            case 2: {
                AdLogUtil.Log().d(this.TAG, "request type is parallel");
                this.parallelRequest(responseBody);
                break;
            }
            default: {
                if (this.mAdRequestBody == null || this.mAdRequestBody.getMediationListener() == null) break;
                this.mAdRequestBody.getMediationListener().onMediationError(TAdErrorCode.AD_MODEL_ERROR);
            }
        }
    }

    @Override
    protected boolean checkAdt(int n) {
        return n == 1;
    }

    @Override
    protected void parallelRequest(ResponseBody responseBody) {
        ArrayList<NetWork> arrayList = responseBody.getNetwork();
        if (arrayList != null && arrayList.size() > 0) {
            this.b();
            this.count = 0;
            for (int i = 0; i < arrayList.size(); ++i) {
                this.b(arrayList.get(i), responseBody);
            }
            if (this.d.size() > 0) {
                this.a();
            } else {
                AdLogUtil.Log().d(this.TAG, "paralleMap is empty");
                if (this.mAdRequestBody != null && this.mAdRequestBody.getMediationListener() != null) {
                    this.mAdRequestBody.getMediationListener().onMediationError(TAdErrorCode.AD_IS_EMPTY);
                }
            }
        } else {
            AdLogUtil.Log().d(this.TAG, "networks is empty");
            if (this.mAdRequestBody != null && this.mAdRequestBody.getMediationListener() != null) {
                this.mAdRequestBody.getMediationListener().onMediationError(TAdErrorCode.AD_IS_EMPTY);
            }
        }
    }

    private void a() {
        this.initDelayTimeHandler();
        if (this.d != null && this.d.size() > 0) {
            AdLogUtil.Log().d(this.TAG, " start all paralle request , size is " + this.d.size());
            for (String string : this.d.keySet()) {
                this.d.get(string).loadAd();
            }
        }
    }

    private void b() {
        if (this.d != null && this.d.size() > 0) {
            AdLogUtil.Log().d(this.TAG, "clear cache map");
            for (String string : this.d.keySet()) {
                this.d.get(string).destroyAd();
            }
            this.d.clear();
        }
    }

    private void a(String string) {
        AdLogUtil.Log().d(this.TAG, "clear cache map, except " + string);
        Iterator<Map.Entry<String, BannerParalle>> iterator = this.d.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, BannerParalle> entry = iterator.next();
            String string2 = entry.getKey();
            if (TextUtils.equals((CharSequence)string, (CharSequence)string2)) continue;
            BannerParalle bannerParalle = entry.getValue();
            bannerParalle.destroyAd();
            iterator.remove();
        }
    }

    @Override
    public synchronized void paralleAdBeLoad(String string) {
        this.count = 0;
        if (this.d != null && this.d.containsKey(string)) {
            if (this.isHighestPriority(string) && !this.mDispatched) {
                BannerParalle bannerParalle;
                AdLogUtil.Log().d(this.TAG, "highest priority is come, placementId is " + string);
                this.clearDelayTimeHandler();
                this.a(string);
                this.e = bannerParalle = this.d.get(string);
                bannerParalle.onParalleFilterTheBest();
                this.mDispatched = true;
            } else {
                BannerParalle bannerParalle = this.d.get(string);
                if (this.e == null) {
                    this.e = bannerParalle;
                } else if (bannerParalle.getNetwork().getPriority() < this.e.getNetwork().getPriority()) {
                    this.e = bannerParalle;
                }
                AdLogUtil.Log().d(this.TAG, "wait for highest priority , now placementId is " + string);
                if (!this.mParalleWaiting) {
                    this.mParalleWaiting = true;
                    if (this.mParalleExecuteHandler != null) {
                        this.mParalleExecuteHandler.postDelayed(new Runnable(){

                            @Override
                            public void run() {
                                TBannerAd.this.clearDelayTimeHandler();
                                if (TBannerAd.this.e != null && TBannerAd.this.e.getNetwork() != null && !TBannerAd.this.mDispatched) {
                                    AdLogUtil.Log().d(TBannerAd.this.TAG, "wait time is out, now placementid is " + TBannerAd.this.e.getNetwork().getPmid());
                                    TBannerAd.this.a(TBannerAd.this.e.getNetwork().getPmid());
                                    TBannerAd.this.e.onParalleFilterTheBest();
                                    TBannerAd.this.mDispatched = true;
                                }
                            }
                        }, (long)this.mParalleWaitTime);
                        AdLogUtil.Log().d(this.TAG, "start wait , wait time=" + this.mParalleWaitTime);
                    }
                }
            }
        }
    }

    @Override
    protected boolean isHighestPriority(String string) {
        BannerParalle bannerParalle = this.d.get(string);
        for (Map.Entry<String, BannerParalle> entry : this.d.entrySet()) {
            BannerParalle bannerParalle2 = entry.getValue();
            if (bannerParalle2.getNetwork().getPriority() >= bannerParalle.getNetwork().getPriority()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean paralleAdSizeOut() {
        if (this.d != null) {
            ++this.count;
            if (this.count >= this.d.size()) {
                AdLogUtil.Log().e(this.TAG, "error count timeout size is " + this.count + ", clear count");
                this.count = 0;
                return true;
            }
            AdLogUtil.Log().e(this.TAG, "error count is " + this.count);
            return false;
        }
        AdLogUtil.Log().e(this.TAG, "paralleMap is null");
        return false;
    }

    private BaseBanner a(NetWork netWork, ResponseBody responseBody) {
        Class<? extends BaseBanner> clazz;
        BaseBanner baseBanner = null;
        String string = PlfmExistsUtil.toAdName(netWork.getId());
        HashMap<String, Class<? extends BaseBanner>> hashMap = PlfmExistsUtil.getInstance().getBannerClassMap();
        if (!TextUtils.isEmpty((CharSequence)string) && (clazz = hashMap.get(string)) != null) {
            Class[] classArray = new Class[]{Context.class, String.class, Integer.TYPE, TrackInfor.class};
            Object[] objectArray = new Object[]{this.mContext, netWork.getPmid(), this.a, this.createTrackInfor(netWork, responseBody)};
            try {
                baseBanner = clazz.getConstructor(classArray).newInstance(objectArray);
                baseBanner.setPriority(netWork.getPriority());
                baseBanner.setTtl(netWork.getTtl());
                baseBanner.setAdSource(netWork.getId());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return baseBanner;
    }

    private void b(NetWork netWork, ResponseBody responseBody) {
        if (netWork != null) {
            if (netWork.getId() == 6) {
                AdLogUtil.Log().e(this.TAG, "Current is Criteo ad ,don't send paralle request, drop it.");
                return;
            }
            BannerParalle bannerParalle = new BannerParalle(netWork, this);
            BaseBanner baseBanner = this.a(netWork, responseBody);
            if (baseBanner != null) {
                bannerParalle.setRequestBody(this.mAdRequestBody);
                bannerParalle.setAllianceExecuter(baseBanner);
                this.d.put(netWork.getPmid(), bannerParalle);
            }
        }
    }

    @Override
    protected void serialRequest(ResponseBody responseBody) {
        ArrayList<NetWork> arrayList = responseBody.getNetwork();
        if (arrayList != null && arrayList.size() > 0) {
            for (int i = 0; i < arrayList.size(); ++i) {
                NetWork netWork = arrayList.get(i);
                BannerSerial bannerSerial = this.c(netWork, responseBody);
                if (bannerSerial == null) continue;
                if (this.c == null) {
                    this.b = this.c = bannerSerial;
                    continue;
                }
                this.b.setNextHandler(bannerSerial);
                this.b = this.b.getNextHandler();
            }
            if (this.c != null) {
                AdLogUtil.Log().d(this.TAG, "headHandler is " + this.c.toString());
                this.c.loadAd();
            } else {
                AdLogUtil.Log().d(this.TAG, "headHandler is empty");
                if (this.mAdRequestBody != null && this.mAdRequestBody.getMediationListener() != null) {
                    this.mAdRequestBody.getMediationListener().onMediationError(TAdErrorCode.AD_IS_EMPTY);
                }
            }
        } else {
            AdLogUtil.Log().d(this.TAG, "ad is empty");
            if (this.mAdRequestBody != null && this.mAdRequestBody.getMediationListener() != null) {
                this.mAdRequestBody.getMediationListener().onMediationError(TAdErrorCode.AD_IS_EMPTY);
            }
        }
    }

    private BannerSerial c(NetWork netWork, ResponseBody responseBody) {
        if (netWork == null) {
            return null;
        }
        BannerSerial bannerSerial = new BannerSerial(netWork);
        BaseBanner baseBanner = this.a(netWork, responseBody);
        if (baseBanner != null) {
            bannerSerial.setRequestBody(this.mAdRequestBody);
            bannerSerial.setAllianceExecuter(baseBanner);
        }
        return bannerSerial;
    }

    @Override
    public void clearCurrentAd() {
        super.clearCurrentAd();
        AdLogUtil.Log().d(this.TAG, "TBanner destroy");
        if (this.c != null) {
            this.c.destroyAd();
            this.c = null;
            this.b = null;
        }
        if (this.e != null) {
            this.e.destroyAd();
            this.e = null;
        }
        this.b();
    }

    @Override
    public void onDestroy() {
        this.clearCurrentAd();
        super.onDestroy();
    }

    @Override
    @Deprecated
    public void bindView(WrapTadView wrapTadView) {
    }

    @Override
    public void show(WrapTadView wrapTadView) {
        if (Looper.myLooper() != Looper.getMainLooper()) {
            new IllegalStateException("must call show in main thread");
        }
        wrapTadView.removeAllViews();
        CacheHandler cacheHandler = this.getCacheHandler();
        try {
            if (cacheHandler != null) {
                BaseBanner baseBanner = (BaseBanner)cacheHandler.getUseCache();
                if (baseBanner != null) {
                    baseBanner.show(wrapTadView);
                    return;
                }
                AdLogUtil.Log().e(this.TAG, "no ad or ad is expired");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.e != null) {
            this.e.show(wrapTadView);
        }
        if (this.c != null) {
            this.c.show(wrapTadView);
        }
    }

    @Override
    protected CacheHandler buildCacheHandler() {
        BannerCacheHandler bannerCacheHandler = new BannerCacheHandler(this.mSlotId, this.mAdRequestBody);
        bannerCacheHandler.setBannerSize(this.a);
        return bannerCacheHandler;
    }
}

