/*
 * Decompiled with CFR 0.152.
 */
package com.zero.mediation.ad;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import com.transsion.core.deviceinfo.DeviceInfo;
import com.zero.common.bean.TAdErrorCode;
import com.zero.common.bean.TAdRequestBody;
import com.zero.common.bean.TrackInfor;
import com.zero.common.event.EventTrack;
import com.zero.common.interfacz.TAdAllianceListener;
import com.zero.common.interfacz.TAdMediationListener;
import com.zero.common.utils.AdLogUtil;
import com.zero.mediation.adapter.TAdAllianceListenerAdapter;
import com.zero.mediation.adapter.TAdMediationListenerAdapter;
import com.zero.mediation.bean.NetWork;
import com.zero.mediation.bean.ResponseBody;
import com.zero.mediation.config.MediaSync;
import com.zero.mediation.config.ServerManager;
import com.zero.mediation.config.TAdManager;
import com.zero.mediation.db.ResponseBodyDaoImp;
import com.zero.mediation.handler.CacheHandler;
import com.zero.mediation.http.callback.CommonResponseListener;
import com.zero.mediation.http.request.AdServerRequest;
import com.zero.mediation.util.ConfigUtil;
import com.zero.mediation.util.DeviceUtil;
import com.zero.mediation.util.MitNetUtil;
import com.zero.mediation.util.RunTimer;
import java.util.ArrayList;

public abstract class TBaseAd {
    private Handler mHandler = new Handler(Looper.getMainLooper());
    private String TAG = "TBaseAd";
    protected String mSlotId = "";
    protected Context mContext = null;
    private RunTimer h;
    protected AdServerRequest adServerRequest;
    protected static final int BUSINESS_SUCCESS_CODE = 0;
    protected static final String SUCCESS_MSG = "success";
    private long startTime = 0L;
    protected boolean mDispatched;
    protected boolean mParalleWaiting;
    protected Handler mParalleExecuteHandler;
    protected int mParalleWaitTime = 0;
    private CacheHandler i;
    private boolean j;
    protected TAdRequestBody mAdRequestBody = new TAdRequestBody.AdRequestBodyBuild().setAllianceListener((TAdAllianceListener)new TAdAllianceListenerAdapter(this)).setMediationListener((TAdMediationListener)new TAdMediationListenerAdapter(this)).build();
    private RunTimer.TimeOutCallback k = new RunTimer.TimeOutCallback(){

        @Override
        public void isTimeOut() {
            AdLogUtil.Log().d(TBaseAd.this.TAG, "Load ad is time out");
            TBaseAd.this.clearCurrentAd();
            if (TBaseAd.this.mAdRequestBody != null && TBaseAd.this.mAdRequestBody.getMediationListener() != null) {
                TBaseAd.this.mAdRequestBody.getMediationListener().onTimeOut();
            }
        }
    };

    protected TBaseAd(Context context, String string) {
        this.mSlotId = string;
        this.mContext = context.getApplicationContext();
        AdLogUtil.Log().d(this.TAG, "mSlotId:=" + string);
    }

    protected void loadAdInternal() {
        this.j = false;
        this.clearCurrentAd();
        if (!MitNetUtil.isNetWorkAvailable()) {
            AdLogUtil.Log().e(this.TAG, "net error");
            if (this.mAdRequestBody != null && this.mAdRequestBody.getMediationListener() != null) {
                this.mAdRequestBody.getMediationListener().onMediationError(TAdErrorCode.NETWORK_ERROR);
                return;
            }
        }
        AdLogUtil.Log().d(this.TAG, "start load ad");
        MediaSync.mediaSyncRequest();
        if (!ConfigUtil.adIsOpen().booleanValue()) {
            AdLogUtil.Log().e(this.TAG, "ad is close");
            if (this.mAdRequestBody != null && this.mAdRequestBody.getMediationListener() != null) {
                this.mAdRequestBody.getMediationListener().onMediationError(TAdErrorCode.MEDIATION_CLOSE_ERROR);
            }
            return;
        }
        if (!this.f()) {
            this.j = true;
            return;
        }
        this.c();
        this.runTimerTask();
    }

    public final void loadAd() {
        if (Looper.myLooper() != Looper.getMainLooper()) {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    TBaseAd.this.loadAdInternal();
                }
            });
            return;
        }
        this.loadAdInternal();
    }

    private void c() {
        ResponseBody responseBody;
        AdLogUtil.Log().d(this.TAG, "start mediation load");
        if (this.mAdRequestBody != null && this.mAdRequestBody.getMediationListener() != null) {
            this.mAdRequestBody.getMediationListener().onMediationStartLoad();
        }
        if ((responseBody = ResponseBodyDaoImp.getsInstance().getAdMsgById(this.mSlotId)) != null) {
            if (responseBody.isExpires()) {
                AdLogUtil.Log().d(this.TAG, "out of time\uff0csync with net");
                this.b(responseBody);
            } else {
                EventTrack.getInstance().mediationLoad(new TrackInfor(TAdManager.getAppToken(), responseBody.getRid(), TAdManager.getAppId(), this.mSlotId, Long.valueOf(0L), 0, SUCCESS_MSG, 0, responseBody.getAdt(), DeviceInfo.getGAId(), DeviceUtil.getSdkVersion()));
                if (this.mAdRequestBody != null && this.mAdRequestBody.getMediationListener() != null) {
                    this.mAdRequestBody.getMediationListener().onMediationLoad(0);
                }
                AdLogUtil.Log().d(this.TAG, "get date from cache");
                this.c(responseBody);
            }
        } else {
            AdLogUtil.Log().d(this.TAG, "not have cache, sync with net");
            ResponseBody responseBody2 = null;
            this.b(responseBody2);
        }
    }

    private void a(ResponseBody responseBody) {
        this.a(responseBody, false);
    }

    private void a(ResponseBody responseBody, boolean bl) {
        if (responseBody != null) {
            if (responseBody.getCode() == 0) {
                if (!bl) {
                    if (responseBody.getOffdur() > 0) {
                        if (!TextUtils.isEmpty((CharSequence)this.mSlotId) && responseBody.getNetwork() != null && responseBody.getNetwork().size() > 0) {
                            AdLogUtil.Log().d(this.TAG, "offdur is " + responseBody.getOffdur() + " save in db");
                            responseBody.setSlotid(this.mSlotId);
                            responseBody.setLastLoadTime(System.currentTimeMillis());
                            ResponseBodyDaoImp.getsInstance().insertAll(responseBody);
                        } else {
                            AdLogUtil.Log().e(this.TAG, "slot id is  null or empty");
                        }
                    } else {
                        AdLogUtil.Log().d(this.TAG, " offdur is unUseful, delete object from db");
                        ResponseBodyDaoImp.getsInstance().delete(responseBody);
                    }
                }
                EventTrack.getInstance().mediationLoad(new TrackInfor(TAdManager.getAppToken(), responseBody.getRid(), TAdManager.getAppId(), this.mSlotId, Long.valueOf(System.currentTimeMillis() - this.startTime), 0, SUCCESS_MSG, 1, responseBody.getAdt(), DeviceInfo.getGAId(), DeviceUtil.getSdkVersion()));
                if (this.mAdRequestBody != null && this.mAdRequestBody.getMediationListener() != null) {
                    this.mAdRequestBody.getMediationListener().onMediationLoad(1);
                }
                AdLogUtil.Log().d(this.TAG, "get data from net");
                this.c(responseBody);
            } else {
                AdLogUtil.Log().d(this.TAG, "mediation is error:" + responseBody.getMsg());
                EventTrack.getInstance().mediationLoad(new TrackInfor(TAdManager.getAppToken(), responseBody.getRid(), TAdManager.getAppId(), this.mSlotId, Long.valueOf(System.currentTimeMillis() - this.startTime), responseBody.getCode(), responseBody.getMsg(), 1, 0, DeviceInfo.getGAId(), DeviceUtil.getSdkVersion()));
                if (this.mAdRequestBody != null && this.mAdRequestBody.getMediationListener() != null) {
                    this.mAdRequestBody.getMediationListener().onMediationError(new TAdErrorCode(responseBody.getCode(), responseBody.getMsg()));
                }
            }
        } else if (this.mAdRequestBody != null && this.mAdRequestBody.getMediationListener() != null) {
            this.mAdRequestBody.getMediationListener().onMediationError(TAdErrorCode.RESPONSE_ERROR);
        }
    }

    private void b(final ResponseBody responseBody) {
        this.adServerRequest = ((AdServerRequest)((AdServerRequest)new AdServerRequest().setSlotId(this.mSlotId)).setListener(new CommonResponseListener<ResponseBody>(true){

            protected void a(int n, ResponseBody responseBody2) {
                TBaseAd.this.a(responseBody2);
            }

            protected void onRequestError(TAdErrorCode tAdErrorCode) {
                if (responseBody != null) {
                    TBaseAd.this.a(responseBody, true);
                    return;
                }
                AdLogUtil.Log().d(TBaseAd.this.TAG, "mediation is error:" + tAdErrorCode.toString());
                EventTrack.getInstance().mediationLoad(new TrackInfor(TAdManager.getAppToken(), "", TAdManager.getAppId(), TBaseAd.this.mSlotId, Long.valueOf(System.currentTimeMillis() - TBaseAd.this.startTime), tAdErrorCode.getErrorCode() + 10000, tAdErrorCode.getErrorMessage(), 1, 0, DeviceInfo.getGAId(), DeviceUtil.getSdkVersion()));
                if (TBaseAd.this.mAdRequestBody != null && TBaseAd.this.mAdRequestBody.getMediationListener() != null) {
                    TBaseAd.this.mAdRequestBody.getMediationListener().onMediationError(tAdErrorCode);
                }
            }

            @Override
            protected /* synthetic */ void onRequestSuccess(int n, Object object) {
                this.a(n, (ResponseBody)object);
            }
        })).setUrl(ServerManager.getServerUrl());
        this.startTime = System.currentTimeMillis();
        this.adServerRequest.netRequestPreExecute();
    }

    private void c(final ResponseBody responseBody) {
        AdLogUtil.Log().d(this.TAG, "response is " + responseBody.toString());
        this.mParalleWaitTime = responseBody.getWaitime();
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                CacheHandler cacheHandler;
                ArrayList<NetWork> arrayList = responseBody.getNetwork();
                if (arrayList != null && arrayList.size() > 0) {
                    for (int i = 0; i < arrayList.size(); ++i) {
                        String string = arrayList.get(i).getPmid();
                        if (string == null) continue;
                        arrayList.get(i).setPmid(string.trim());
                    }
                }
                if (!TBaseAd.this.checkAdt(responseBody.getAdt())) {
                    AdLogUtil.Log().d(TBaseAd.this.TAG, "ad type is error");
                    if (TBaseAd.this.mAdRequestBody != null && TBaseAd.this.mAdRequestBody.getMediationListener() != null) {
                        TBaseAd.this.mAdRequestBody.getMediationListener().onMediationError(TAdErrorCode.AD_TYPE_ERROR);
                    }
                    return;
                }
                if (TBaseAd.this.mAdRequestBody != null && TBaseAd.this.mAdRequestBody.getAllianceListener() != null) {
                    TBaseAd.this.mAdRequestBody.getAllianceListener().onAllianceStart();
                }
                if ((cacheHandler = TBaseAd.this.getCacheHandler()) != null && cacheHandler.handleResponse(TBaseAd.this.mContext, responseBody)) {
                    return;
                }
                TBaseAd.this.requestMediationSuccess(responseBody);
            }
        });
    }

    public void setRequestBody(TAdRequestBody tAdRequestBody) {
        this.mAdRequestBody = tAdRequestBody;
        this.mAdRequestBody.setAllianceListener((TAdAllianceListener)new TAdAllianceListenerAdapter(tAdRequestBody.getAllianceListener(), this));
        this.mAdRequestBody.setmMediationListener((TAdMediationListener)new TAdMediationListenerAdapter(tAdRequestBody.getMediationListener(), this));
    }

    public void setId(String string) {
        this.mSlotId = string;
        AdLogUtil.Log().d(this.TAG, "slot id:=" + string);
    }

    private void d() {
        this.mHandler.removeCallbacksAndMessages(null);
        if (this.adServerRequest != null) {
            this.adServerRequest.cancelRequest();
            this.adServerRequest = null;
        }
    }

    protected void clearCurrentAd() {
        AdLogUtil.Log().d(this.TAG, "TBase ad destroy");
        this.mDispatched = false;
        this.stopTimer();
        this.clearDelayTimeHandler();
        if (this.i != null) {
            this.i.destroy();
            this.i = null;
        }
        this.d();
    }

    public void onDestroy() {
        this.mContext = null;
        this.mAdRequestBody = null;
        this.j = false;
        this.d();
    }

    public void stopTimer() {
        if (this.h != null) {
            AdLogUtil.Log().d(this.TAG, "stop timer");
            this.h.resetTimerTask();
            this.h = null;
        }
    }

    private void runTimerTask() {
        int n = 60000;
        if (this.mAdRequestBody != null) {
            n = this.mAdRequestBody.getScheduleTime();
        }
        if (n > 0) {
            if (this.h == null) {
                this.h = new RunTimer();
            }
            this.h.resetTimerTask();
            this.h.setTimeOutCallback(this.k);
            this.h.setScheduleTime(n);
            this.h.runTimerTask();
            AdLogUtil.Log().d(this.TAG, "start timer,schedule time is " + n);
        }
    }

    protected TrackInfor createTrackInfor(NetWork netWork, ResponseBody responseBody) {
        return new TrackInfor(TAdManager.getAppToken(), responseBody.getRid(), netWork.getId(), TAdManager.getAppId(), this.mSlotId, netWork.getPmid(), 1, responseBody.getAdt(), DeviceInfo.getGAId(), DeviceUtil.getSdkVersion());
    }

    public static TrackInfor createTrackInfor(NetWork netWork, ResponseBody responseBody, String string) {
        return new TrackInfor(TAdManager.getAppToken(), responseBody.getRid(), netWork.getId(), TAdManager.getAppId(), string, netWork.getPmid(), 1, responseBody.getAdt(), DeviceInfo.getGAId(), DeviceUtil.getSdkVersion());
    }

    protected void initDelayTimeHandler() {
        if (this.mParalleExecuteHandler == null) {
            this.mParalleExecuteHandler = new Handler();
        }
        this.mParalleWaiting = false;
    }

    protected void clearDelayTimeHandler() {
        if (this.mParalleExecuteHandler != null) {
            this.mParalleExecuteHandler.removeCallbacksAndMessages(null);
            this.mParalleExecuteHandler = null;
        }
    }

    protected abstract boolean isHighestPriority(String var1);

    protected abstract void serialRequest(ResponseBody var1);

    protected abstract void parallelRequest(ResponseBody var1);

    protected abstract void requestMediationSuccess(ResponseBody var1);

    protected abstract boolean checkAdt(int var1);

    protected CacheHandler buildCacheHandler() {
        return null;
    }

    private final void e() {
        if (this.mAdRequestBody == null || !this.mAdRequestBody.hasFlag(1)) {
            this.i = null;
            return;
        }
        this.i = this.buildCacheHandler();
        if (this.i != null) {
            this.i.setRequestBody(this.mAdRequestBody);
        }
    }

    protected final CacheHandler getCacheHandler() {
        if (this.mAdRequestBody == null || !this.mAdRequestBody.hasFlag(1)) {
            return null;
        }
        return this.i;
    }

    private boolean f() {
        this.e();
        if (this.i != null) {
            return this.i.preLoad();
        }
        return true;
    }

    public boolean isLoaded() {
        return this.j;
    }

    public void setLoaded(boolean bl) {
        this.j = bl;
    }
}

