/*
 * Decompiled with CFR 0.152.
 */
package com.zero.mediation.ad;

import android.content.Context;
import android.text.TextUtils;
import com.zero.common.base.BaseInterstitial;
import com.zero.common.bean.TAdErrorCode;
import com.zero.common.bean.TrackInfor;
import com.zero.common.utils.AdLogUtil;
import com.zero.mediation.ad.TBaseAd;
import com.zero.mediation.bean.NetWork;
import com.zero.mediation.bean.ResponseBody;
import com.zero.mediation.handler.CacheHandler;
import com.zero.mediation.handler.interstial.InterstialCacheHandler;
import com.zero.mediation.handler.interstial.InterstialParalle;
import com.zero.mediation.handler.interstial.InterstialSerial;
import com.zero.mediation.interfacz.IAdParallel;
import com.zero.mediation.interfacz.IMediationIntersitial;
import com.zero.mediation.util.PlfmExistsUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class TInterstitialAd
extends TBaseAd
implements IAdParallel,
IMediationIntersitial {
    private String TAG = "TInterstitialAd";
    private InterstialSerial u;
    private InterstialSerial v;
    private int count = 0;
    private HashMap<String, InterstialParalle> d = new HashMap();
    private InterstialParalle w;

    public TInterstitialAd(Context context, String string) {
        super(context, string);
    }

    @Override
    protected void requestMediationSuccess(ResponseBody responseBody) {
        switch (responseBody.getModel()) {
            case 1: {
                AdLogUtil.Log().d(this.TAG, "request type is serial");
                this.serialRequest(responseBody);
                break;
            }
            case 2: {
                AdLogUtil.Log().d(this.TAG, "request type is parallel");
                this.parallelRequest(responseBody);
                break;
            }
            default: {
                if (this.mAdRequestBody == null || this.mAdRequestBody.getMediationListener() == null) break;
                this.mAdRequestBody.getMediationListener().onMediationError(TAdErrorCode.AD_MODEL_ERROR);
            }
        }
    }

    @Override
    protected boolean checkAdt(int n) {
        return n == 2;
    }

    @Override
    protected void parallelRequest(ResponseBody responseBody) {
        ArrayList<NetWork> arrayList = responseBody.getNetwork();
        if (arrayList != null && arrayList.size() > 0) {
            this.b();
            this.count = 0;
            for (int i = 0; i < arrayList.size(); ++i) {
                this.b(arrayList.get(i), responseBody);
            }
            if (this.d.size() > 0) {
                this.a();
            } else {
                AdLogUtil.Log().d(this.TAG, "paralleMap is empty");
                if (this.mAdRequestBody != null && this.mAdRequestBody.getMediationListener() != null) {
                    this.mAdRequestBody.getMediationListener().onMediationError(TAdErrorCode.AD_IS_EMPTY);
                }
            }
        } else {
            AdLogUtil.Log().d(this.TAG, "networks is empty");
            if (this.mAdRequestBody != null && this.mAdRequestBody.getMediationListener() != null) {
                this.mAdRequestBody.getMediationListener().onMediationError(TAdErrorCode.AD_IS_EMPTY);
            }
        }
    }

    private void b(NetWork netWork, ResponseBody responseBody) {
        if (netWork != null) {
            InterstialParalle interstialParalle = new InterstialParalle(netWork, this);
            BaseInterstitial baseInterstitial = this.f(netWork, responseBody);
            if (baseInterstitial != null && this.mAdRequestBody != null) {
                interstialParalle.setRequestBody(this.mAdRequestBody);
                interstialParalle.setAllianceExecuter(baseInterstitial);
                this.d.put(netWork.getPmid(), interstialParalle);
            }
        }
    }

    private void a() {
        this.initDelayTimeHandler();
        if (this.d != null && this.d.size() > 0) {
            AdLogUtil.Log().d(this.TAG, " start all paralle request , size is " + this.d.size());
            for (String string : this.d.keySet()) {
                this.d.get(string).loadAd();
            }
        }
    }

    private void b() {
        if (this.d != null && this.d.size() > 0) {
            AdLogUtil.Log().d(this.TAG, "clear cache map");
            for (String string : this.d.keySet()) {
                this.d.get(string).destroyAd();
            }
            this.d.clear();
        }
    }

    private void a(String string) {
        AdLogUtil.Log().d(this.TAG, "clear cache map, except " + string);
        Iterator<Map.Entry<String, InterstialParalle>> iterator = this.d.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, InterstialParalle> entry = iterator.next();
            String string2 = entry.getKey();
            if (TextUtils.equals((CharSequence)string, (CharSequence)string2)) continue;
            InterstialParalle interstialParalle = entry.getValue();
            interstialParalle.destroyAd();
            iterator.remove();
        }
    }

    @Override
    public synchronized void paralleAdBeLoad(String string) {
        this.count = 0;
        if (this.d != null && this.d.containsKey(string)) {
            if (this.isHighestPriority(string) && !this.mDispatched) {
                AdLogUtil.Log().d(this.TAG, "highest priority is come, placementId is " + string);
                this.clearDelayTimeHandler();
                this.a(string);
                this.w = this.d.get(string);
                this.w.onParalleFilterTheBest();
                this.mDispatched = true;
            } else {
                InterstialParalle interstialParalle = this.d.get(string);
                if (this.w == null) {
                    this.w = interstialParalle;
                } else if (interstialParalle.getNetwork().getPriority() < this.w.getNetwork().getPriority()) {
                    this.w = interstialParalle;
                }
                AdLogUtil.Log().d(this.TAG, "wait for highest priority , now placementId is " + string);
                if (!this.mParalleWaiting) {
                    this.mParalleWaiting = true;
                    if (this.mParalleExecuteHandler != null) {
                        this.mParalleExecuteHandler.postDelayed(new Runnable(){

                            @Override
                            public void run() {
                                TInterstitialAd.this.clearDelayTimeHandler();
                                if (TInterstitialAd.this.w != null && TInterstitialAd.this.w.getNetwork() != null && !TInterstitialAd.this.mDispatched) {
                                    AdLogUtil.Log().d(TInterstitialAd.this.TAG, "wait time is out, now placementid is " + TInterstitialAd.this.w.getNetwork().getPmid());
                                    TInterstitialAd.this.a(TInterstitialAd.this.w.getNetwork().getPmid());
                                    TInterstitialAd.this.w.onParalleFilterTheBest();
                                    TInterstitialAd.this.mDispatched = true;
                                }
                            }
                        }, (long)this.mParalleWaitTime);
                        AdLogUtil.Log().d(this.TAG, "start wait , wait time=" + this.mParalleWaitTime);
                    }
                }
            }
        }
    }

    @Override
    protected boolean isHighestPriority(String string) {
        InterstialParalle interstialParalle = this.d.get(string);
        for (Map.Entry<String, InterstialParalle> entry : this.d.entrySet()) {
            InterstialParalle interstialParalle2 = entry.getValue();
            if (interstialParalle2.getNetwork().getPriority() >= interstialParalle.getNetwork().getPriority()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean paralleAdSizeOut() {
        if (this.d != null) {
            ++this.count;
            if (this.count >= this.d.size()) {
                AdLogUtil.Log().e(this.TAG, "error count timeout size is " + this.count + ", clear count");
                this.count = 0;
                return true;
            }
            AdLogUtil.Log().e(this.TAG, "error count is " + this.count);
            return false;
        }
        AdLogUtil.Log().e(this.TAG, "paralleMap is null");
        return false;
    }

    @Override
    protected void serialRequest(ResponseBody responseBody) {
        ArrayList<NetWork> arrayList = responseBody.getNetwork();
        if (arrayList != null && arrayList.size() > 0) {
            for (int i = 0; i < arrayList.size(); ++i) {
                NetWork netWork = arrayList.get(i);
                InterstialSerial interstialSerial = this.g(netWork, responseBody);
                if (interstialSerial == null) continue;
                if (this.v == null) {
                    this.u = this.v = interstialSerial;
                    continue;
                }
                this.u.setNextHandler(interstialSerial);
                this.u = this.u.getNextHandler();
            }
            AdLogUtil.Log().d(this.TAG, "headHandler is " + this.v.toString());
            if (this.v != null) {
                this.v.loadAd();
            } else {
                AdLogUtil.Log().d(this.TAG, "headHandler is empty");
                if (this.mAdRequestBody != null && this.mAdRequestBody.getMediationListener() != null) {
                    this.mAdRequestBody.getMediationListener().onMediationError(TAdErrorCode.AD_IS_EMPTY);
                }
            }
        } else {
            AdLogUtil.Log().d(this.TAG, "ad is empty");
            if (this.mAdRequestBody != null && this.mAdRequestBody.getMediationListener() != null) {
                this.mAdRequestBody.getMediationListener().onMediationError(TAdErrorCode.AD_IS_EMPTY);
            }
        }
    }

    private BaseInterstitial f(NetWork netWork, ResponseBody responseBody) {
        Class<? extends BaseInterstitial> clazz;
        BaseInterstitial baseInterstitial = null;
        String string = PlfmExistsUtil.toAdName(netWork.getId());
        HashMap<String, Class<? extends BaseInterstitial>> hashMap = PlfmExistsUtil.getInstance().getInterClassMap();
        if (!TextUtils.isEmpty((CharSequence)string) && (clazz = hashMap.get(string)) != null) {
            Class[] classArray = new Class[]{Context.class, String.class, TrackInfor.class};
            Object[] objectArray = new Object[]{this.mContext, netWork.getPmid(), this.createTrackInfor(netWork, responseBody)};
            try {
                baseInterstitial = clazz.getConstructor(classArray).newInstance(objectArray);
                baseInterstitial.setPriority(netWork.getPriority());
                baseInterstitial.setTtl(netWork.getTtl());
                baseInterstitial.setAdSource(netWork.getId());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return baseInterstitial;
    }

    private InterstialSerial g(NetWork netWork, ResponseBody responseBody) {
        if (netWork == null) {
            return null;
        }
        InterstialSerial interstialSerial = new InterstialSerial(netWork);
        BaseInterstitial baseInterstitial = this.f(netWork, responseBody);
        if (baseInterstitial != null) {
            interstialSerial.setRequestBody(this.mAdRequestBody);
            interstialSerial.setAllianceExecuter(baseInterstitial);
        }
        return interstialSerial;
    }

    @Override
    public void show() {
        AdLogUtil.Log().d(this.TAG, "Tinterstitial show");
        if (this.v != null && this.isLoaded()) {
            this.v.show();
        }
        if (this.w != null) {
            this.w.show();
        }
        try {
            if (this.getCacheHandler() != null) {
                BaseInterstitial baseInterstitial = (BaseInterstitial)this.getCacheHandler().getUseCache();
                if (baseInterstitial != null) {
                    baseInterstitial.show();
                    return;
                }
                AdLogUtil.Log().e(this.TAG, "no ad or ad is expired");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public boolean isLoaded() {
        return this.v != null && this.v.isLoaded();
    }

    @Override
    public void clearCurrentAd() {
        super.clearCurrentAd();
        AdLogUtil.Log().d(this.TAG, "Tinterstitial destroy");
        if (this.v != null) {
            this.v.destroyAd();
            this.v = null;
        }
        if (this.w != null) {
            this.w.destroyAd();
            this.w = null;
        }
        this.b();
    }

    @Override
    public void onDestroy() {
        this.clearCurrentAd();
        super.onDestroy();
    }

    @Override
    protected CacheHandler buildCacheHandler() {
        return new InterstialCacheHandler(this.mSlotId, this.mAdRequestBody);
    }
}

