/*
 * Decompiled with CFR 0.152.
 */
package com.zero.mediation.ad;

import android.content.Context;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import com.zero.common.base.BaseNative;
import com.zero.common.bean.TAdErrorCode;
import com.zero.common.bean.TAdNativeInfo;
import com.zero.common.bean.TrackInfor;
import com.zero.common.utils.AdLogUtil;
import com.zero.common.utils.SpUtil;
import com.zero.mediation.ad.TBaseAd;
import com.zero.mediation.bean.NetWork;
import com.zero.mediation.bean.ResponseBody;
import com.zero.mediation.handler.CacheHandler;
import com.zero.mediation.handler.native_.NativeCacheHandler;
import com.zero.mediation.handler.native_.NativeParalle;
import com.zero.mediation.handler.native_.NativeSerial;
import com.zero.mediation.interfacz.IAdParallel;
import com.zero.mediation.interfacz.IMediationNative;
import com.zero.mediation.util.PlfmExistsUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class TNativeAd
extends TBaseAd
implements IAdParallel,
IMediationNative {
    private String TAG = "TNativeAd";
    private NativeSerial y;
    private NativeSerial z;
    private int A;
    private int count = 0;
    private HashMap<String, NativeParalle> d = new HashMap();
    private NativeParalle B;

    public TNativeAd(Context context, String string) {
        super(context, string);
        this.A = SpUtil.getInstance().getInt("admob", 0);
    }

    @Override
    protected void requestMediationSuccess(ResponseBody responseBody) {
        switch (responseBody.getModel()) {
            case 1: {
                AdLogUtil.Log().d(this.TAG, "request type is serial");
                this.serialRequest(responseBody);
                break;
            }
            case 2: {
                AdLogUtil.Log().d(this.TAG, "request type is parallel");
                this.parallelRequest(responseBody);
                break;
            }
            default: {
                if (this.mAdRequestBody == null || this.mAdRequestBody.getMediationListener() == null) break;
                this.mAdRequestBody.getMediationListener().onMediationError(TAdErrorCode.AD_MODEL_ERROR);
            }
        }
    }

    @Override
    protected boolean checkAdt(int n) {
        return n == 3 || n == 4;
    }

    @Override
    protected void parallelRequest(ResponseBody responseBody) {
        ArrayList<NetWork> arrayList = responseBody.getNetwork();
        if (arrayList != null && arrayList.size() > 0) {
            this.b();
            this.count = 0;
            for (int i = 0; i < arrayList.size(); ++i) {
                this.b(arrayList.get(i), responseBody);
            }
            if (this.d.size() > 0) {
                this.a();
            } else {
                AdLogUtil.Log().d(this.TAG, "paralleMap is empty");
                if (this.mAdRequestBody != null && this.mAdRequestBody.getMediationListener() != null) {
                    this.mAdRequestBody.getMediationListener().onMediationError(TAdErrorCode.AD_IS_EMPTY);
                }
            }
        } else {
            AdLogUtil.Log().d(this.TAG, "networks is empty");
            if (this.mAdRequestBody != null && this.mAdRequestBody.getMediationListener() != null) {
                this.mAdRequestBody.getMediationListener().onMediationError(TAdErrorCode.AD_IS_EMPTY);
            }
        }
    }

    private void b(NetWork netWork, ResponseBody responseBody) {
        if (netWork != null) {
            if (netWork.getId() == 6) {
                AdLogUtil.Log().e(this.TAG, "Current is Criteo ad ,don't send paralle request, drop it.");
                return;
            }
            NativeParalle nativeParalle = new NativeParalle(netWork, this);
            BaseNative baseNative = this.h(netWork, responseBody);
            if (baseNative != null && this.mAdRequestBody != null) {
                nativeParalle.setRequestBody(this.mAdRequestBody);
                nativeParalle.setAllianceExecuter(baseNative);
                this.d.put(netWork.getPmid(), nativeParalle);
            }
        }
    }

    private void a() {
        this.initDelayTimeHandler();
        if (this.d != null && this.d.size() > 0) {
            AdLogUtil.Log().d(this.TAG, " start all paralle request , size is " + this.d.size());
            for (String string : this.d.keySet()) {
                this.d.get(string).loadAd();
            }
        }
    }

    private void b() {
        if (this.d != null && this.d.size() > 0) {
            AdLogUtil.Log().d(this.TAG, "clear cache map");
            for (String string : this.d.keySet()) {
                this.d.get(string).destroyAd();
            }
            this.d.clear();
        }
    }

    private void a(String string) {
        AdLogUtil.Log().d(this.TAG, "clear cache map, except " + string);
        Iterator<Map.Entry<String, NativeParalle>> iterator = this.d.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, NativeParalle> entry = iterator.next();
            String string2 = entry.getKey();
            if (TextUtils.equals((CharSequence)string, (CharSequence)string2)) continue;
            NativeParalle nativeParalle = entry.getValue();
            nativeParalle.destroyAd();
            iterator.remove();
        }
    }

    @Override
    public synchronized void paralleAdBeLoad(String string) {
        this.count = 0;
        if (this.d != null && this.d.containsKey(string)) {
            if (this.isHighestPriority(string) && !this.mDispatched) {
                AdLogUtil.Log().d(this.TAG, "highest priority is come, placementId is " + string);
                this.clearDelayTimeHandler();
                this.a(string);
                this.B = this.d.get(string);
                this.B.onParalleFilterTheBest();
                this.mDispatched = true;
            } else {
                NativeParalle nativeParalle = this.d.get(string);
                if (this.B == null) {
                    this.B = nativeParalle;
                } else if (nativeParalle.getNetwork().getPriority() < this.B.getNetwork().getPriority()) {
                    this.B = nativeParalle;
                }
                AdLogUtil.Log().d(this.TAG, "wait for highest priority , now placementId is" + string);
                if (!this.mParalleWaiting) {
                    this.mParalleWaiting = true;
                    if (this.mParalleExecuteHandler != null) {
                        this.mParalleExecuteHandler.postDelayed(new Runnable(){

                            @Override
                            public void run() {
                                TNativeAd.this.clearDelayTimeHandler();
                                if (TNativeAd.this.B != null && TNativeAd.this.B.getNetwork() != null && !TNativeAd.this.mDispatched) {
                                    AdLogUtil.Log().d(TNativeAd.this.TAG, "wait time is out, now placementid is " + TNativeAd.this.B.getNetwork().getPmid());
                                    TNativeAd.this.B.onParalleFilterTheBest();
                                    TNativeAd.this.mDispatched = true;
                                }
                            }
                        }, (long)this.mParalleWaitTime);
                        AdLogUtil.Log().d(this.TAG, "start wait , wait time=" + this.mParalleWaitTime);
                    }
                }
            }
        }
    }

    @Override
    public boolean paralleAdSizeOut() {
        if (this.d != null) {
            ++this.count;
            if (this.count >= this.d.size()) {
                AdLogUtil.Log().e(this.TAG, "error count timeout size is " + this.count + ", clear count");
                this.count = 0;
                return true;
            }
            AdLogUtil.Log().e(this.TAG, "error count is " + this.count);
            return false;
        }
        AdLogUtil.Log().e(this.TAG, "paralleMap is null");
        return false;
    }

    @Override
    protected void serialRequest(ResponseBody responseBody) {
        ArrayList<NetWork> arrayList = responseBody.getNetwork();
        if (arrayList != null && arrayList.size() > 0) {
            for (int i = 0; i < arrayList.size(); ++i) {
                NetWork netWork = arrayList.get(i);
                NativeSerial nativeSerial = this.i(netWork, responseBody);
                if (nativeSerial == null) continue;
                if (this.z == null) {
                    this.y = this.z = nativeSerial;
                    continue;
                }
                this.y.setNextHandler(nativeSerial);
                this.y = this.y.getNextHandler();
            }
            AdLogUtil.Log().d(this.TAG, "headHandler is " + this.z.toString());
            if (this.z != null) {
                this.z.loadAd();
            } else {
                AdLogUtil.Log().d(this.TAG, "headHandler is empty");
                if (this.mAdRequestBody != null && this.mAdRequestBody.getMediationListener() != null) {
                    this.mAdRequestBody.getMediationListener().onMediationError(TAdErrorCode.AD_IS_EMPTY);
                }
            }
        } else {
            AdLogUtil.Log().d(this.TAG, "ad is empty");
            if (this.mAdRequestBody != null && this.mAdRequestBody.getMediationListener() != null) {
                this.mAdRequestBody.getMediationListener().onMediationError(TAdErrorCode.AD_IS_EMPTY);
            }
        }
    }

    private BaseNative h(NetWork netWork, ResponseBody responseBody) {
        Class<? extends BaseNative> clazz;
        BaseNative baseNative = null;
        String string = PlfmExistsUtil.toAdName(netWork.getId());
        HashMap<String, Class<? extends BaseNative>> hashMap = PlfmExistsUtil.getInstance().getNativeClassMap();
        if (!TextUtils.isEmpty((CharSequence)string) && (clazz = hashMap.get(string)) != null) {
            Class[] classArray = new Class[]{Context.class, String.class, Integer.TYPE, Integer.TYPE, TrackInfor.class};
            Object[] objectArray = new Object[]{this.mContext, netWork.getPmid(), responseBody.getAdnum(), responseBody.getAdt(), this.createTrackInfor(netWork, responseBody)};
            try {
                baseNative = clazz.getConstructor(classArray).newInstance(objectArray);
                baseNative.setPriority(netWork.getPriority());
                baseNative.setChoicesPosition(this.A);
                baseNative.setTtl(netWork.getTtl());
                baseNative.setAdSource(netWork.getId());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return baseNative;
    }

    private NativeSerial i(NetWork netWork, ResponseBody responseBody) {
        if (netWork == null) {
            return null;
        }
        NativeSerial nativeSerial = new NativeSerial(netWork);
        BaseNative baseNative = this.h(netWork, responseBody);
        if (baseNative != null) {
            nativeSerial.setRequestBody(this.mAdRequestBody);
            nativeSerial.setAllianceExecuter(baseNative);
        }
        return nativeSerial;
    }

    @Override
    protected boolean isHighestPriority(String string) {
        NativeParalle nativeParalle = this.d.get(string);
        for (Map.Entry<String, NativeParalle> entry : this.d.entrySet()) {
            NativeParalle nativeParalle2 = entry.getValue();
            if (nativeParalle2.getNetwork().getPriority() >= nativeParalle.getNetwork().getPriority()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void clearCurrentAd() {
        super.clearCurrentAd();
        AdLogUtil.Log().d(this.TAG, "TNative destroy");
        if (this.z != null) {
            this.z.destroyAd();
            this.z = null;
            this.y = null;
        }
        if (this.B != null) {
            this.B.destroyAd();
            this.B = null;
        }
        this.b();
    }

    @Override
    public void registerViewForInteraction(ViewGroup viewGroup, List<View> list, TAdNativeInfo tAdNativeInfo) {
        if (tAdNativeInfo != null) {
            tAdNativeInfo.registerViewForInteraction(viewGroup, list);
        }
    }

    @Override
    public void unregisterView(TAdNativeInfo tAdNativeInfo) {
        if (tAdNativeInfo != null) {
            tAdNativeInfo.unregisterView();
        }
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        this.clearCurrentAd();
    }

    @Override
    protected CacheHandler buildCacheHandler() {
        return new NativeCacheHandler(this.mSlotId, this.mAdRequestBody);
    }

    public final void preLoadAd() {
        if (this.mAdRequestBody == null) {
            AdLogUtil.Log().d(this.TAG, "preLoadAd mAdRequestBody must not null");
            return;
        }
        this.mAdRequestBody.addFlag(5);
        this.loadAd();
    }

    public final TAdNativeInfo getTAdNativeInfo() {
        try {
            if (this.getCacheHandler() != null) {
                NativeCacheHandler nativeCacheHandler = (NativeCacheHandler)this.getCacheHandler();
                return nativeCacheHandler.getTAdNativeInfo();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }
}

