/*
 * Decompiled with CFR 0.152.
 */
package com.zero.mediation.adapter;

import android.support.annotation.NonNull;
import com.zero.common.bean.TAdErrorCode;
import com.zero.common.interfacz.TAdMediationListener;
import com.zero.common.utils.AdLogUtil;
import com.zero.mediation.ad.TBaseAd;

public class TAdMediationListenerAdapter
extends TAdMediationListener {
    private String TAG = "TAdAllianceListenerAdapter";
    private TBaseAd K;
    private TAdMediationListener M;

    public TAdMediationListenerAdapter(@NonNull TBaseAd tBaseAd) {
        this.K = tBaseAd;
    }

    public TAdMediationListenerAdapter(TAdMediationListener tAdMediationListener, @NonNull TBaseAd tBaseAd) {
        this.M = tAdMediationListener;
        this.K = tBaseAd;
    }

    public void onMediationError(TAdErrorCode tAdErrorCode) {
        if (this.K != null) {
            this.K.stopTimer();
        }
        AdLogUtil.Log().d(this.TAG, "on mediation error");
        if (this.K.isLoaded()) {
            return;
        }
        if (this.M != null) {
            this.M.onMediationError(tAdErrorCode);
        }
    }

    public void onMediationStartLoad() {
        AdLogUtil.Log().d(this.TAG, "on mediation start");
        if (this.K.isLoaded()) {
            return;
        }
        if (this.M != null) {
            this.M.onMediationStartLoad();
        }
    }

    public void onMediationLoad(int n) {
        AdLogUtil.Log().d(this.TAG, "on mediation is load");
        if (this.K.isLoaded()) {
            return;
        }
        if (this.M != null) {
            this.M.onMediationLoad(n);
        }
    }

    public void onTimeOut() {
        AdLogUtil.Log().d(this.TAG, "on mediation time out");
        if (this.K.isLoaded()) {
            return;
        }
        if (this.M != null) {
            this.M.onTimeOut();
        }
    }
}

