/*
 * Decompiled with CFR 0.152.
 */
package com.zero.mediation.bean;

import android.support.annotation.NonNull;
import android.text.TextUtils;
import com.zero.common.interfacz.ICacheAd;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;

public class AdCache<T extends ICacheAd> {
    private static AdCacheComp mComparator = new AdCacheComp();
    HashMap<String, ArrayList<T>> map = new HashMap();

    private ArrayList<T> getOrCreateList(String string) {
        ArrayList<Object> arrayList = this.map.get(string);
        if (arrayList == null) {
            arrayList = new ArrayList();
            this.map.put(string, arrayList);
        }
        return arrayList;
    }

    public void addCache(String string, @NonNull T t) {
        ArrayList<T> arrayList = this.getOrCreateList(string);
        int n = Collections.binarySearch(arrayList, t, mComparator);
        if (n < 0) {
            n = -(n + 1);
        }
        arrayList.add(n, t);
    }

    public void addCaches(String string, ArrayList<T> arrayList) {
        ArrayList<T> arrayList2 = this.getOrCreateList(string);
        arrayList2.addAll(arrayList);
        Collections.sort(arrayList2, mComparator);
    }

    public void removeCaches(String string, ArrayList<T> arrayList) {
        ArrayList<T> arrayList2 = this.map.get(string);
        if (arrayList2 != null) {
            arrayList2.removeAll(arrayList);
        }
    }

    public void removeCache(String string, T t) {
        ArrayList<T> arrayList = this.map.get(string);
        if (arrayList != null) {
            arrayList.remove(t);
        }
    }

    public ArrayList<T> getCaches(String string, int n) {
        ArrayList<ICacheAd> arrayList = null;
        ArrayList<T> arrayList2 = this.map.get(string);
        if (arrayList2 != null) {
            Iterator<T> iterator = arrayList2.iterator();
            while (iterator.hasNext()) {
                ICacheAd iCacheAd = (ICacheAd)iterator.next();
                iterator.remove();
                if (iCacheAd.isExpired()) {
                    iCacheAd.destroyAd();
                    continue;
                }
                if (arrayList == null) {
                    arrayList = new ArrayList<ICacheAd>();
                }
                arrayList.add(iCacheAd);
                if (arrayList.size() < n) continue;
                break;
            }
        }
        return arrayList;
    }

    public T getCache(String string) {
        ICacheAd iCacheAd = null;
        ArrayList<T> arrayList = this.getCaches(string, 1);
        if (arrayList != null && !arrayList.isEmpty()) {
            iCacheAd = (ICacheAd)arrayList.get(0);
        }
        return (T)iCacheAd;
    }

    public boolean hasAds(String string) {
        ArrayList<T> arrayList = this.map.get(string);
        if (arrayList == null) {
            return false;
        }
        Iterator<T> iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            ICacheAd iCacheAd = (ICacheAd)iterator.next();
            if (iCacheAd.isExpired()) {
                iCacheAd.destroyAd();
                iterator.remove();
                continue;
            }
            return true;
        }
        return false;
    }

    public int getAdNum(String string, int n, String string2) {
        int n2 = 0;
        ArrayList<T> arrayList = this.map.get(string);
        if (arrayList == null) {
            return n2;
        }
        Iterator<T> iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            ICacheAd iCacheAd = (ICacheAd)iterator.next();
            if (iCacheAd.isExpired()) {
                iCacheAd.destroyAd();
                iterator.remove();
                continue;
            }
            if (iCacheAd.getAdSource() != n || !TextUtils.equals((CharSequence)iCacheAd.getPlacementId(), (CharSequence)string2)) continue;
            ++n2;
        }
        return n2;
    }

    public boolean contains(String string, int n, String string2) {
        ArrayList<T> arrayList = this.map.get(string);
        if (arrayList == null) {
            return false;
        }
        Iterator<T> iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            ICacheAd iCacheAd = (ICacheAd)iterator.next();
            if (iCacheAd.isExpired()) {
                iCacheAd.destroyAd();
                iterator.remove();
                continue;
            }
            if (iCacheAd.getAdSource() != n || !TextUtils.equals((CharSequence)iCacheAd.getPlacementId(), (CharSequence)string2)) continue;
            return true;
        }
        return false;
    }

    public static class AdCacheComp
    implements Comparator<ICacheAd> {
        @Override
        public int compare(ICacheAd iCacheAd, ICacheAd iCacheAd2) {
            if (iCacheAd.isExpired()) {
                return 1;
            }
            if (iCacheAd2.isExpired()) {
                return -1;
            }
            if (iCacheAd.getPriority() == iCacheAd2.getPriority()) {
                if (iCacheAd.getValidTimeLimit() - iCacheAd2.getValidTimeLimit() <= 0L) {
                    return -1;
                }
                return 1;
            }
            return iCacheAd.getPriority() - iCacheAd2.getPriority();
        }
    }
}

