/*
 * Decompiled with CFR 0.152.
 */
package com.zero.mediation.handler;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.support.annotation.NonNull;
import com.zero.common.bean.TAdErrorCode;
import com.zero.common.bean.TAdNativeInfo;
import com.zero.common.bean.TAdRequestBody;
import com.zero.common.interfacz.ICacheAd;
import com.zero.common.interfacz.Iad;
import com.zero.common.interfacz.TAdAllianceListener;
import com.zero.common.utils.AdLogUtil;
import com.zero.mediation.bean.AdCache;
import com.zero.mediation.bean.NetWork;
import com.zero.mediation.bean.ResponseBody;
import com.zero.mediation.handler.LoadHandler;
import java.util.ArrayList;
import java.util.List;

public abstract class CacheHandler<T extends Iad, C>
extends LoadHandler {
    private int ai;
    private ArrayList<T> aj = new ArrayList();
    private boolean mDispatched;
    protected int mWaitTime;
    private boolean ak;
    private Handler mHandler = new Handler(){

        public void handleMessage(Message message) {
            switch (message.what) {
                case 1000: {
                    if (CacheHandler.this.mDispatched || CacheHandler.this.mOutRequest == null || CacheHandler.this.mUseCache == null) {
                        return;
                    }
                    AdLogUtil.Log().d("ssp", "\u8fd4\u56de\u7684\u662f\u5b9e\u65f6\u8bf7\u6c42\u5e7f\u544a, \u6d88\u8017\u6389\u586b\u5145\u7684cache");
                    CacheHandler.this.removeCache(CacheHandler.this.mUseCache);
                    CacheHandler.this.notifyLoadBest(CacheHandler.this.mUseCache);
                    break;
                }
                default: {
                    if (!(message.obj instanceof Iad)) break;
                    ((Iad)message.obj).loadAd();
                }
            }
        }
    };
    private boolean al;
    protected C mUseCache;
    protected String mSlotId;
    private T am;
    private ArrayList<Integer> an = new ArrayList();

    public CacheHandler(String string, TAdRequestBody tAdRequestBody) {
        this.mOutRequest = tAdRequestBody;
        this.mSlotId = string;
    }

    public void setWaitTime(int n) {
        this.mWaitTime = n;
    }

    public boolean handleResponse(Context context, @NonNull ResponseBody responseBody) {
        this.setWaitTime(responseBody.getWaitime());
        if (responseBody.getNetwork() == null) {
            return false;
        }
        for (NetWork netWork : responseBody.getNetwork()) {
            T t;
            int n = this.getNeedNum(responseBody.getSlotid(), netWork.getId(), netWork.getPmid(), Math.min(this.getMaxLoadNum(), responseBody.getAdnum()));
            if (n <= 0 || (t = this.buildExecuter(context, netWork, responseBody, n)) == null) continue;
            AdLogUtil.Log().e("ssp", "\u53d1\u8d77\u8bf7\u6c42\u5e7f\u544a slotId:" + this.mSlotId + " adSource:" + t.getAdSource() + " pmid:" + netWork.getPmid() + " \u9700\u8981\u4e2a\u6570:" + n);
            t.setDelay(netWork.getDelay());
            this.a(t);
        }
        if (this.aj.isEmpty()) {
            return this.al;
        }
        this.loadAd();
        return true;
    }

    private void a(T t) {
        this.aj.add(t);
    }

    @Override
    public void destroy() {
        super.destroy();
        for (Iad iad : this.aj) {
            iad.stopLoader();
        }
        this.aj.clear();
        this.mHandler.removeCallbacksAndMessages(null);
        this.mHandler = null;
        this.mDispatched = true;
        this.am = null;
        this.destoryUseCache(this.mUseCache);
        this.mUseCache = null;
        this.an.clear();
    }

    private void b(int n) {
        if (this.an.contains(n)) {
            return;
        }
        this.an.add(n);
    }

    private void g() {
        for (int n : this.an) {
            this.mHandler.removeMessages(n);
        }
    }

    private void a(@NonNull T t, int n) {
        this.b(n);
        Message message = this.mHandler.obtainMessage(n, t);
        this.mHandler.sendMessageDelayed(message, (long)(n * 1000));
    }

    @Override
    public void loadAd() {
        for (Iad iad : this.aj) {
            int n = iad.getDelay();
            iad.setRequestBody(this.buildTAdRequestBody(this.mOutRequest, iad));
            if (n > 0) {
                this.a(iad, n);
                continue;
            }
            iad.loadAd();
        }
    }

    protected boolean isHighestPriority(T t) {
        for (Iad iad : this.aj) {
            if (iad.getPriority() >= t.getPriority()) continue;
            return false;
        }
        return true;
    }

    protected void clearDelayTimeHandler() {
        if (this.mHandler != null) {
            this.mHandler.removeMessages(1000);
        }
    }

    protected void startWaitForBest() {
        if (this.mHandler != null) {
            this.mHandler.sendEmptyMessageDelayed(1000, (long)this.mWaitTime);
        }
    }

    protected final void notifyLoadBest(C c) {
        this.mDispatched = true;
        this.separateResult(c);
        this.setRequest(c, this.mOutRequest);
        this.onLoadBest(c);
    }

    protected final void notifyLoadFailed(TAdErrorCode tAdErrorCode) {
        this.mDispatched = true;
        this.onLoadFailed(tAdErrorCode);
    }

    protected final void removeCache(C c) {
        if (c instanceof ArrayList) {
            this.getAdCache().removeCaches(this.mSlotId, (ArrayList)c);
        } else {
            this.getAdCache().removeCache(this.mSlotId, (ICacheAd)c);
        }
    }

    protected final void buildCache(C c) {
        if (c instanceof ArrayList) {
            this.getAdCache().addCaches(this.mSlotId, (ArrayList)c);
        } else {
            this.getAdCache().addCache(this.mSlotId, (ICacheAd)c);
        }
    }

    protected final boolean checkCache(String string, int n, String string2) {
        return this.getAdCache().contains(string, n, string2);
    }

    protected int getNeedNum(String string, int n, String string2, int n2) {
        return n2 - this.getAdCache().getAdNum(string, n, string2);
    }

    protected abstract void onLoadBest(C var1);

    protected abstract void setRequest(@NonNull C var1, TAdRequestBody var2);

    protected abstract T buildExecuter(@NonNull Context var1, @NonNull NetWork var2, @NonNull ResponseBody var3, int var4);

    protected abstract void destoryUseCache(C var1);

    protected void separateResult(@NonNull C c) {
    }

    protected int getMaxLoadNum() {
        return 1;
    }

    @NonNull
    protected abstract <Y extends ICacheAd> AdCache<Y> getAdCache();

    public C getUseCache() {
        return this.mUseCache;
    }

    protected void onLoadFailed(TAdErrorCode tAdErrorCode) {
        if (this.mOutRequest != null && this.mOutRequest.getAllianceListener() != null) {
            this.mOutRequest.getAllianceListener().onAllianceError(tAdErrorCode);
        }
    }

    protected abstract boolean onPreLoad();

    public boolean preLoad() {
        if (Looper.getMainLooper() != Looper.myLooper()) {
            throw new RuntimeException("cache mode must load int main thread!");
        }
        this.al = this.onPreLoad();
        if (this.al) {
            AdLogUtil.Log().d("ssp", "\u8fd4\u56de\u7684\u662fcache");
            this.notifyLoadBest(this.mUseCache);
        }
        return this.mOutRequest.hasFlag(2) || !this.al;
    }

    private void a(@NonNull CacheTAdAllianceListener cacheTAdAllianceListener) {
        Object t = cacheTAdAllianceListener.getExecuter();
        Object c = cacheTAdAllianceListener.getCache();
        if (!this.mDispatched && !this.al && this.mOutRequest != null && this.isHighestPriority(t)) {
            this.clearDelayTimeHandler();
            this.am = t;
            this.mUseCache = c;
            AdLogUtil.Log().d("ssp", "\u8fd4\u56de\u7684\u662f\u5b9e\u65f6\u8bf7\u6c42\u5e7f\u544a adsource:" + t.getAdSource());
            this.notifyLoadBest(cacheTAdAllianceListener.getCache());
        } else {
            AdLogUtil.Log().d("ssp", "\u586b\u5145cache adsource:" + t.getAdSource());
            this.buildCache(c);
            if (this.mDispatched || this.al || this.mOutRequest == null) {
                return;
            }
            if (this.am == null || t.getPriority() < this.am.getPriority()) {
                this.am = t;
                this.mUseCache = c;
            }
            if (!this.ak) {
                this.ak = true;
                this.startWaitForBest();
            }
        }
    }

    private void a(TAdErrorCode tAdErrorCode) {
        ++this.ai;
        if (this.ai >= this.aj.size() && !this.al) {
            this.notifyLoadFailed(tAdErrorCode);
        }
    }

    protected TAdRequestBody buildTAdRequestBody(@NonNull TAdRequestBody tAdRequestBody, T t) {
        return new TAdRequestBody.AdRequestBodyBuild().setAllianceListener((TAdAllianceListener)new CacheTAdAllianceListener(this, null, t)).setReturnUrlsForImageAssets(tAdRequestBody.isUrlForImage()).showInterstitialAdByApk(tAdRequestBody.isShowInterstitialAdByApk()).build();
    }

    protected static class CacheTAdAllianceListener
    extends LoadHandler.WrapTAdAllianceListener {
        private T mExecuter;
        private C ap;
        final /* synthetic */ CacheHandler ao;

        public CacheTAdAllianceListener(@NonNull TAdRequestBody tAdRequestBody, T t) {
            this.ao = var1_1;
            super(tAdRequestBody);
            this.mExecuter = t;
        }

        public C getCache() {
            return this.ap;
        }

        public T getExecuter() {
            return this.mExecuter;
        }

        @Override
        public void onAllianceLoad(List<TAdNativeInfo> list) {
            this.ap = list;
            this.ao.a(this);
            this.ao.g();
        }

        public void onAllianceLoad() {
            this.ap = this.mExecuter;
            this.ao.a(this);
            this.ao.g();
        }

        @Override
        public void onAllianceError(TAdErrorCode tAdErrorCode) {
            AdLogUtil.Log().e("ssp", "\u8bf7\u6c42\u5e7f\u544a\u5931\u8d25 adSource:" + this.mExecuter.getAdSource());
            this.ao.a(tAdErrorCode);
        }
    }
}

