/*
 * Decompiled with CFR 0.152.
 */
package com.zero.mediation.handler;

import android.support.annotation.NonNull;
import com.zero.common.bean.InterceptAdapter;
import com.zero.common.bean.TAdErrorCode;
import com.zero.common.bean.TAdNativeInfo;
import com.zero.common.bean.TAdRequestBody;
import com.zero.common.interfacz.Iad;
import com.zero.common.interfacz.TAdAllianceListener;
import java.util.List;

public abstract class LoadHandler<T extends Iad> {
    protected T mExecuter;
    protected TAdRequestBody mOutRequest;

    public final void setRequestBody(@NonNull TAdRequestBody tAdRequestBody) {
        this.mOutRequest = tAdRequestBody;
    }

    public void loadAd() {
        this.mExecuter.setRequestBody(this.buildTAdRequestBody(this.mOutRequest));
        this.mExecuter.loadAd();
    }

    public void destroy() {
        if (this.mExecuter != null) {
            this.mExecuter.destroyAd();
        }
        this.mOutRequest = null;
        this.mExecuter = null;
    }

    public void setAllianceExecuter(T t) {
        this.mExecuter = t;
    }

    protected TAdRequestBody buildTAdRequestBody(TAdRequestBody tAdRequestBody) {
        return this.mOutRequest;
    }

    public static class WrapTAdAllianceListener
    extends TAdAllianceListener {
        protected TAdRequestBody request;

        public WrapTAdAllianceListener(@NonNull TAdRequestBody tAdRequestBody) {
            this.request = tAdRequestBody;
        }

        public void setTAdRequestBody(TAdRequestBody tAdRequestBody) {
            this.request = tAdRequestBody;
        }

        private TAdAllianceListener getAllianceListener() {
            if (this.request != null) {
                return this.request.getAllianceListener();
            }
            return null;
        }

        public void onAllianceError(TAdErrorCode tAdErrorCode) {
            TAdAllianceListener tAdAllianceListener = this.getAllianceListener();
            if (tAdAllianceListener != null) {
                tAdAllianceListener.onAllianceError(tAdErrorCode);
            }
        }

        public void onShow() {
            TAdAllianceListener tAdAllianceListener = this.getAllianceListener();
            if (tAdAllianceListener != null) {
                tAdAllianceListener.onShow();
            }
        }

        public void onClicked() {
            TAdAllianceListener tAdAllianceListener = this.getAllianceListener();
            if (tAdAllianceListener != null) {
                tAdAllianceListener.onClicked();
            }
        }

        public void onClosed() {
            TAdAllianceListener tAdAllianceListener = this.getAllianceListener();
            if (tAdAllianceListener != null) {
                tAdAllianceListener.onClosed();
            }
        }

        public void onAllianceLoad(List<TAdNativeInfo> list) {
            TAdAllianceListener tAdAllianceListener = this.getAllianceListener();
            if (tAdAllianceListener != null) {
                tAdAllianceListener.onAllianceLoad();
            }
        }

        public void onClickIntercept(InterceptAdapter interceptAdapter) {
            TAdAllianceListener tAdAllianceListener = this.getAllianceListener();
            if (tAdAllianceListener != null) {
                tAdAllianceListener.onClickIntercept(interceptAdapter);
            }
        }
    }
}

