/*
 * Decompiled with CFR 0.152.
 */
package com.zero.mediation.handler.banner;

import android.content.Context;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import com.zero.common.base.BaseBanner;
import com.zero.common.bean.TAdRequestBody;
import com.zero.common.bean.TrackInfor;
import com.zero.common.interfacz.TAdAllianceListener;
import com.zero.common.utils.AdLogUtil;
import com.zero.mediation.ad.TBaseAd;
import com.zero.mediation.bean.AdCache;
import com.zero.mediation.bean.NetWork;
import com.zero.mediation.bean.ResponseBody;
import com.zero.mediation.handler.CacheHandler;
import com.zero.mediation.handler.LoadHandler;
import com.zero.mediation.util.PlfmExistsUtil;
import java.util.HashMap;

public class BannerCacheHandler
extends CacheHandler<BaseBanner, BaseBanner> {
    private static AdCache<BaseBanner> aq = new AdCache();
    private int a;

    public BannerCacheHandler(String string, TAdRequestBody tAdRequestBody) {
        super(string, tAdRequestBody);
    }

    @Override
    protected void onLoadBest(BaseBanner baseBanner) {
        if (this.mOutRequest.getAllianceListener() != null) {
            this.mOutRequest.getAllianceListener().onAllianceLoad();
        }
    }

    @Override
    protected void setRequest(@NonNull BaseBanner baseBanner, TAdRequestBody tAdRequestBody) {
        TAdRequestBody tAdRequestBody2 = baseBanner.getRequestBody();
        if (tAdRequestBody2 == null) {
            return;
        }
        TAdAllianceListener tAdAllianceListener = tAdRequestBody2.getAllianceListener();
        if (tAdAllianceListener == null) {
            return;
        }
        if (tAdAllianceListener instanceof LoadHandler.WrapTAdAllianceListener) {
            ((LoadHandler.WrapTAdAllianceListener)tAdAllianceListener).setTAdRequestBody(tAdRequestBody);
        }
    }

    @Override
    protected BaseBanner buildExecuter(@NonNull Context context, @NonNull NetWork netWork, @NonNull ResponseBody responseBody, int n) {
        return this.a(context, netWork, responseBody);
    }

    @Override
    public BaseBanner getUseCache() {
        BaseBanner baseBanner = (BaseBanner)super.getUseCache();
        if (baseBanner != null && !baseBanner.isExpired()) {
            return baseBanner;
        }
        BaseBanner baseBanner2 = this.getAdCache().getCache(this.mSlotId);
        if (baseBanner2 != null) {
            return baseBanner2;
        }
        AdLogUtil.Log().e("BannerCacheHandler", "no ad or all ad is expired");
        return baseBanner;
    }

    @Override
    protected void destoryUseCache(BaseBanner baseBanner) {
        if (baseBanner != null) {
            baseBanner.destroyAd();
        }
    }

    @Override
    protected AdCache<BaseBanner> getAdCache() {
        return aq;
    }

    @Override
    protected boolean onPreLoad() {
        this.mUseCache = aq.getCache(this.mSlotId);
        return this.mUseCache != null;
    }

    public void setBannerSize(int n) {
        this.a = n;
    }

    private BaseBanner a(Context context, NetWork netWork, ResponseBody responseBody) {
        Class<? extends BaseBanner> clazz;
        BaseBanner baseBanner = null;
        String string = PlfmExistsUtil.toAdName(netWork.getId());
        HashMap<String, Class<? extends BaseBanner>> hashMap = PlfmExistsUtil.getInstance().getBannerClassMap();
        if (!TextUtils.isEmpty((CharSequence)string) && (clazz = hashMap.get(string)) != null) {
            Class[] classArray = new Class[]{Context.class, String.class, Integer.TYPE, TrackInfor.class};
            Object[] objectArray = new Object[]{context, netWork.getPmid(), this.a, TBaseAd.createTrackInfor(netWork, responseBody, this.mSlotId)};
            try {
                baseBanner = clazz.getConstructor(classArray).newInstance(objectArray);
                baseBanner.setPriority(netWork.getPriority());
                baseBanner.setTtl(netWork.getTtl());
                baseBanner.setAdSource(netWork.getId());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return baseBanner;
    }
}

