/*
 * Decompiled with CFR 0.152.
 */
package com.zero.mediation.handler.banner;

import com.zero.common.base.BaseBanner;
import com.zero.common.bean.InterceptAdapter;
import com.zero.common.bean.TAdErrorCode;
import com.zero.common.bean.TAdRequestBody;
import com.zero.common.interfacz.TAdAllianceListener;
import com.zero.common.utils.AdLogUtil;
import com.zero.common.widget.WrapTadView;
import com.zero.mediation.bean.NetWork;
import com.zero.mediation.handler.IParalleHandler;
import com.zero.mediation.interfacz.IAdParallel;
import com.zero.mediation.interfacz.IMediationBanner;

public class BannerParalle
implements IParalleHandler<BaseBanner>,
IMediationBanner {
    private IAdParallel ar;
    private String TAG = "BannerParalle";
    protected WrapTadView mParentView;
    protected String mPlacementId = "";
    private NetWork as;
    protected TAdRequestBody mAdRequestBody;
    private TAdRequestBody at;
    private BaseBanner au;

    public BannerParalle(NetWork netWork, IAdParallel iAdParallel) {
        this.mPlacementId = netWork.getPmid();
        this.as = netWork;
        this.ar = iAdParallel;
    }

    @Override
    public void setRequestBody(TAdRequestBody tAdRequestBody) {
        this.at = tAdRequestBody;
        this.mAdRequestBody = new TAdRequestBody.AdRequestBodyBuild().setAllianceListener(new TAdAllianceListener(){

            public void onAllianceLoad() {
                if (BannerParalle.this.ar != null) {
                    AdLogUtil.Log().d(BannerParalle.this.TAG, "Ad load success,plaformId is " + BannerParalle.this.mPlacementId);
                    BannerParalle.this.ar.paralleAdBeLoad(BannerParalle.this.mPlacementId);
                }
            }

            public void onAllianceError(TAdErrorCode tAdErrorCode) {
                BannerParalle.this.detorySelf();
                if (BannerParalle.this.ar != null) {
                    if (BannerParalle.this.ar.paralleAdSizeOut()) {
                        AdLogUtil.Log().e(BannerParalle.this.TAG, "error count is time out");
                        if (BannerParalle.this.at != null) {
                            BannerParalle.this.at.getAllianceListener().onAllianceError(tAdErrorCode);
                        }
                    } else {
                        AdLogUtil.Log().e(BannerParalle.this.TAG, "count is not out,wait next");
                    }
                }
            }

            public void onShow() {
                if (BannerParalle.this.at != null) {
                    BannerParalle.this.at.getAllianceListener().onShow();
                }
            }

            public void onClicked() {
                if (BannerParalle.this.at != null) {
                    BannerParalle.this.at.getAllianceListener().onClicked();
                }
            }

            public void onClosed() {
                if (BannerParalle.this.at != null) {
                    BannerParalle.this.at.getAllianceListener().onClosed();
                }
            }

            public void onClickIntercept(InterceptAdapter interceptAdapter) {
                if (BannerParalle.this.at != null) {
                    BannerParalle.this.at.getAllianceListener().onClickIntercept(interceptAdapter);
                }
            }
        }).build();
    }

    @Override
    public void loadAd() {
        AdLogUtil.Log().d(this.TAG, "BannerParalle start Load");
        this.au = this.getBanner();
        if (this.au != null) {
            this.au.setRequestBody(this.mAdRequestBody);
            this.au.loadAd();
        }
    }

    public BaseBanner getBanner() {
        return this.au;
    }

    @Override
    public void show(WrapTadView wrapTadView) {
        if (this.au != null) {
            AdLogUtil.Log().d(this.TAG, "BannerParalle  show");
            this.au.show(wrapTadView);
        }
    }

    protected void detorySelf() {
        if (this.au != null) {
            AdLogUtil.Log().d(this.TAG, "BannerParalle destroy self");
            this.au.destroyAd();
            this.au = null;
        }
    }

    @Override
    public void bindView(WrapTadView wrapTadView) {
        this.mParentView = wrapTadView;
    }

    @Override
    public void destroyAd() {
        AdLogUtil.Log().d(this.TAG, this.TAG + " destroyAd");
        this.ar = null;
        this.at = null;
        this.detorySelf();
    }

    @Override
    public void onParalleFilterTheBest() {
        if (this.at != null) {
            this.at.getAllianceListener().onAllianceLoad();
        }
    }

    @Override
    public NetWork getNetwork() {
        return this.as;
    }

    @Override
    public void setAllianceExecuter(BaseBanner baseBanner) {
        this.au = baseBanner;
    }

    public String toString() {
        return "BannerParalle{netWork=" + this.as + ", iadParallel=" + this.ar + ", TAG='" + this.TAG + '\'' + ", mParentView=" + this.mParentView + ", mPlacementId='" + this.mPlacementId + '\'' + ", mAdRequestBody=" + this.mAdRequestBody + ", adRequestBody=" + this.at + '}';
    }
}

