/*
 * Decompiled with CFR 0.152.
 */
package com.zero.mediation.handler.banner;

import com.zero.common.base.BaseBanner;
import com.zero.common.bean.InterceptAdapter;
import com.zero.common.bean.TAdErrorCode;
import com.zero.common.bean.TAdRequestBody;
import com.zero.common.interfacz.TAdAllianceListener;
import com.zero.common.utils.AdLogUtil;
import com.zero.common.widget.WrapTadView;
import com.zero.mediation.bean.NetWork;
import com.zero.mediation.handler.ISerialHandler;
import com.zero.mediation.interfacz.IMediationBanner;

public class BannerSerial
implements ISerialHandler<BaseBanner>,
IMediationBanner {
    private String TAG = "BannerSerial";
    protected BannerSerial nextHandler;
    protected String mPlacementId = "";
    protected TAdRequestBody mAdRequestBody;
    private TAdRequestBody at;
    private BaseBanner au = null;

    public BannerSerial(NetWork netWork) {
        this.mPlacementId = netWork.getPmid();
    }

    public BannerSerial getNextHandler() {
        return this.nextHandler;
    }

    public void setNextHandler(BannerSerial bannerSerial) {
        this.nextHandler = bannerSerial;
    }

    @Override
    public void setRequestBody(TAdRequestBody tAdRequestBody) {
        this.at = tAdRequestBody;
        this.mAdRequestBody = new TAdRequestBody.AdRequestBodyBuild().setAllianceListener(new TAdAllianceListener(){

            public void onAllianceError(TAdErrorCode tAdErrorCode) {
                BannerSerial.this.destroySelf();
                if (BannerSerial.this.nextHandler != null) {
                    AdLogUtil.Log().d(BannerSerial.this.TAG, "load error, next");
                    BannerSerial.this.nextHandler.loadAd();
                } else if (BannerSerial.this.at != null) {
                    BannerSerial.this.at.getAllianceListener().onAllianceError(tAdErrorCode);
                }
            }

            public void onAllianceLoad() {
                if (BannerSerial.this.at != null) {
                    BannerSerial.this.at.getAllianceListener().onAllianceLoad();
                }
            }

            public void onShow() {
                if (BannerSerial.this.at != null) {
                    BannerSerial.this.at.getAllianceListener().onShow();
                }
            }

            public void onClicked() {
                if (BannerSerial.this.at != null) {
                    BannerSerial.this.at.getAllianceListener().onClicked();
                }
            }

            public void onClosed() {
                if (BannerSerial.this.at != null) {
                    BannerSerial.this.at.getAllianceListener().onClosed();
                }
            }

            public void onClickIntercept(InterceptAdapter interceptAdapter) {
                if (BannerSerial.this.at != null) {
                    BannerSerial.this.at.getAllianceListener().onClickIntercept(interceptAdapter);
                }
            }
        }).build();
    }

    @Override
    public void loadAd() {
        AdLogUtil.Log().d(this.TAG, "BannerSerial start Load");
        this.au = this.getBanner();
        if (this.au != null) {
            this.au.setRequestBody(this.mAdRequestBody);
            this.au.loadAd();
        }
    }

    public BaseBanner getBanner() {
        return this.au;
    }

    @Override
    public void show(WrapTadView wrapTadView) {
        if (this.au != null) {
            AdLogUtil.Log().d(this.TAG, "BannerSerial  show");
            this.au.show(wrapTadView);
        }
    }

    protected void destroySelf() {
        if (this.au != null) {
            AdLogUtil.Log().d(this.TAG, "BannerSerial destroy self");
            this.au.destroyAd();
            this.au = null;
        }
    }

    @Override
    public void bindView(WrapTadView wrapTadView) {
    }

    @Override
    public void destroyAd() {
        this.at = null;
        if (this.nextHandler != null) {
            AdLogUtil.Log().d(this.TAG, this.TAG + " destroy");
            this.nextHandler.destroyAd();
            this.nextHandler = null;
        }
        this.destroySelf();
    }

    @Override
    public void setAllianceExecuter(BaseBanner baseBanner) {
        this.au = baseBanner;
    }

    public String toString() {
        return "BannerSerial{, TAG='" + this.TAG + '\'' + ", nextHandler=" + this.nextHandler + ", mPlacementId='" + this.mPlacementId + '\'' + ", mAdRequestBody=" + this.mAdRequestBody + ", adRequestBody=" + this.at + ", mBanner=" + this.au + '}';
    }
}

