/*
 * Decompiled with CFR 0.152.
 */
package com.zero.mediation.handler.entirety;

import android.support.annotation.NonNull;
import com.zero.common.base.BaseEntirety;
import com.zero.common.bean.InterceptAdapter;
import com.zero.common.bean.TAdErrorCode;
import com.zero.common.bean.TAdRequestBody;
import com.zero.common.interfacz.TAdAllianceListener;
import com.zero.common.utils.AdLogUtil;
import com.zero.common.widget.WrapTadView;
import com.zero.mediation.bean.NetWork;
import com.zero.mediation.handler.IParalleHandler;
import com.zero.mediation.interfacz.IAdParallel;
import com.zero.mediation.interfacz.IMediationEntirety;

public class EntiretyParalle
implements IParalleHandler<BaseEntirety>,
IMediationEntirety {
    private final NetWork ax;
    private IAdParallel ay;
    private String TAG = "BannerParalle";
    protected WrapTadView mParentView;
    protected String mPlacementId = "";
    protected TAdRequestBody mAdRequestBody;
    private TAdRequestBody at;
    private BaseEntirety az = null;

    public EntiretyParalle(@NonNull NetWork netWork, IAdParallel iAdParallel) {
        this.mPlacementId = netWork.getPmid();
        this.ax = netWork;
        this.ay = iAdParallel;
    }

    @Override
    public void setRequestBody(TAdRequestBody tAdRequestBody) {
        this.at = tAdRequestBody;
        this.mAdRequestBody = new TAdRequestBody.AdRequestBodyBuild().setAllianceListener(new TAdAllianceListener(){

            public void onAllianceLoad() {
                if (EntiretyParalle.this.ay != null) {
                    AdLogUtil.Log().d(EntiretyParalle.this.TAG, "Ad load success,plaformId is " + EntiretyParalle.this.mPlacementId);
                    EntiretyParalle.this.ay.paralleAdBeLoad(EntiretyParalle.this.mPlacementId);
                }
            }

            public void onAllianceError(TAdErrorCode tAdErrorCode) {
                EntiretyParalle.this.detorySelf();
                if (EntiretyParalle.this.ay != null) {
                    if (EntiretyParalle.this.ay.paralleAdSizeOut()) {
                        AdLogUtil.Log().e(EntiretyParalle.this.TAG, "error count is time out");
                        if (EntiretyParalle.this.at != null) {
                            EntiretyParalle.this.at.getAllianceListener().onAllianceError(tAdErrorCode);
                        }
                    } else {
                        AdLogUtil.Log().e(EntiretyParalle.this.TAG, "count is not out,wait next");
                    }
                }
            }

            public void onShow() {
                if (EntiretyParalle.this.at != null) {
                    EntiretyParalle.this.at.getAllianceListener().onShow();
                }
            }

            public void onClicked() {
                if (EntiretyParalle.this.at != null) {
                    EntiretyParalle.this.at.getAllianceListener().onClicked();
                }
            }

            public void onClosed() {
                if (EntiretyParalle.this.at != null) {
                    EntiretyParalle.this.at.getAllianceListener().onClosed();
                }
            }

            public void onClickIntercept(InterceptAdapter interceptAdapter) {
                if (EntiretyParalle.this.at != null) {
                    EntiretyParalle.this.at.getAllianceListener().onClickIntercept(interceptAdapter);
                }
            }
        }).setEntirtyShowTime(tAdRequestBody.getEntirtyShowTime()).build();
    }

    @Override
    public void loadAd() {
        AdLogUtil.Log().d(this.TAG, "AdTanBannerParalle start Load");
        this.az = this.getEntirety();
        this.az.setRequestBody(this.mAdRequestBody);
        this.az.loadAd();
    }

    public BaseEntirety getEntirety() {
        return this.az;
    }

    @Override
    public void show(WrapTadView wrapTadView) {
        if (this.az != null) {
            AdLogUtil.Log().d(this.TAG, "AdTanBannerParalle  show");
            this.az.show(wrapTadView);
        }
    }

    protected void detorySelf() {
        if (this.az != null) {
            AdLogUtil.Log().d(this.TAG, "AdTanBannerParalle destroy self");
            this.az.destroyAd();
            this.az = null;
        }
    }

    @Override
    public void bindView(WrapTadView wrapTadView) {
        this.mParentView = wrapTadView;
    }

    @Override
    public void destroyAd() {
        AdLogUtil.Log().d(this.TAG, this.TAG + " destroyAd");
        this.ay = null;
        this.at = null;
        this.detorySelf();
    }

    @Override
    public void onParalleFilterTheBest() {
        if (this.at != null) {
            this.at.getAllianceListener().onAllianceLoad();
        }
    }

    @Override
    public NetWork getNetwork() {
        return this.ax;
    }

    @Override
    public void setAllianceExecuter(BaseEntirety baseEntirety) {
        this.az = baseEntirety;
    }

    public String toString() {
        return "EntiretyParalle{netWork=" + this.ax + ", iadParallel=" + this.ay + ", TAG='" + this.TAG + '\'' + ", mParentView=" + this.mParentView + ", mPlacementId='" + this.mPlacementId + '\'' + ", mAdRequestBody=" + this.mAdRequestBody + ", adRequestBody=" + this.at + '}';
    }
}

