/*
 * Decompiled with CFR 0.152.
 */
package com.zero.mediation.handler.entirety;

import com.zero.common.base.BaseEntirety;
import com.zero.common.bean.EntiretyAdsize;
import com.zero.common.bean.InterceptAdapter;
import com.zero.common.bean.TAdErrorCode;
import com.zero.common.bean.TAdRequestBody;
import com.zero.common.interfacz.TAdAllianceListener;
import com.zero.common.utils.AdLogUtil;
import com.zero.common.widget.WrapTadView;
import com.zero.mediation.bean.NetWork;
import com.zero.mediation.handler.ISerialHandler;
import com.zero.mediation.interfacz.IMediationEntirety;

public class EntiretySerial
implements ISerialHandler<BaseEntirety>,
IMediationEntirety {
    private String TAG = "BannerSerial";
    protected EntiretySerial nextHandler;
    protected WrapTadView mParentView;
    protected String mPlacementId = "";
    protected TAdRequestBody mAdRequestBody;
    protected EntiretyAdsize entiretyAdsize;
    private TAdRequestBody at;
    private BaseEntirety az = null;

    public EntiretySerial(NetWork netWork) {
        this.mPlacementId = netWork.getPmid();
    }

    public EntiretySerial getNextHandler() {
        return this.nextHandler;
    }

    public void setNextHandler(EntiretySerial entiretySerial) {
        this.nextHandler = entiretySerial;
    }

    @Override
    public void setRequestBody(TAdRequestBody tAdRequestBody) {
        this.at = tAdRequestBody;
        this.mAdRequestBody = new TAdRequestBody.AdRequestBodyBuild().setAllianceListener(new TAdAllianceListener(){

            public void onAllianceError(TAdErrorCode tAdErrorCode) {
                EntiretySerial.this.destroySelf();
                if (EntiretySerial.this.nextHandler != null) {
                    AdLogUtil.Log().d(EntiretySerial.this.TAG, "load error, next");
                    EntiretySerial.this.nextHandler.loadAd();
                } else if (EntiretySerial.this.at != null) {
                    EntiretySerial.this.at.getAllianceListener().onAllianceError(tAdErrorCode);
                }
            }

            public void onAllianceLoad() {
                if (EntiretySerial.this.at != null) {
                    EntiretySerial.this.at.getAllianceListener().onAllianceLoad();
                }
            }

            public void onShow() {
                if (EntiretySerial.this.at != null) {
                    EntiretySerial.this.at.getAllianceListener().onShow();
                }
            }

            public void onClicked() {
                if (EntiretySerial.this.at != null) {
                    EntiretySerial.this.at.getAllianceListener().onClicked();
                }
            }

            public void onClosed() {
                if (EntiretySerial.this.at != null) {
                    EntiretySerial.this.at.getAllianceListener().onClosed();
                }
            }

            public void onClickIntercept(InterceptAdapter interceptAdapter) {
                if (EntiretySerial.this.at != null) {
                    EntiretySerial.this.at.getAllianceListener().onClickIntercept(interceptAdapter);
                }
            }
        }).setEntirtyShowTime(tAdRequestBody.getEntirtyShowTime()).build();
    }

    @Override
    public void loadAd() {
        AdLogUtil.Log().d(this.TAG, "AdTanBannerParalle start Load");
        this.az = this.getEntirety();
        if (this.az != null) {
            this.az.setRequestBody(this.mAdRequestBody);
            this.az.loadAd();
        }
    }

    public BaseEntirety getEntirety() {
        return this.az;
    }

    @Override
    public void show(WrapTadView wrapTadView) {
        if (this.az != null) {
            AdLogUtil.Log().d(this.TAG, "AdTanBannerParalle  show");
            this.az.show(wrapTadView);
        }
    }

    protected void destroySelf() {
        if (this.az != null) {
            AdLogUtil.Log().d(this.TAG, "AdTanBannerParalle destroy self");
            this.az.destroyAd();
            this.az = null;
        }
    }

    @Override
    public void bindView(WrapTadView wrapTadView) {
        this.mParentView = wrapTadView;
    }

    @Override
    public void destroyAd() {
        this.at = null;
        if (this.nextHandler != null) {
            AdLogUtil.Log().d(this.TAG, this.TAG + " destroy");
            this.nextHandler.destroyAd();
            this.nextHandler = null;
        }
        this.destroySelf();
    }

    @Override
    public void setAllianceExecuter(BaseEntirety baseEntirety) {
        this.az = baseEntirety;
    }

    public String toString() {
        return "EntiretySerial{TAG='" + this.TAG + '\'' + ", nextHandler=" + this.nextHandler + ", mParentView=" + this.mParentView + ", mPlacementId='" + this.mPlacementId + '\'' + ", mAdRequestBody=" + this.mAdRequestBody + ", entiretyAdsize=" + this.entiretyAdsize + ", adRequestBody=" + this.at + '}';
    }
}

