/*
 * Decompiled with CFR 0.152.
 */
package com.zero.mediation.handler.interstial;

import android.content.Context;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import com.zero.common.base.BaseInterstitial;
import com.zero.common.bean.TAdRequestBody;
import com.zero.common.bean.TrackInfor;
import com.zero.common.interfacz.TAdAllianceListener;
import com.zero.common.utils.AdLogUtil;
import com.zero.mediation.ad.TBaseAd;
import com.zero.mediation.bean.AdCache;
import com.zero.mediation.bean.NetWork;
import com.zero.mediation.bean.ResponseBody;
import com.zero.mediation.handler.CacheHandler;
import com.zero.mediation.handler.LoadHandler;
import com.zero.mediation.util.PlfmExistsUtil;
import java.util.HashMap;

public class InterstialCacheHandler
extends CacheHandler<BaseInterstitial, BaseInterstitial> {
    private static AdCache<BaseInterstitial> aq = new AdCache();

    public InterstialCacheHandler(String string, TAdRequestBody tAdRequestBody) {
        super(string, tAdRequestBody);
    }

    @Override
    protected void onLoadBest(BaseInterstitial baseInterstitial) {
        if (this.mOutRequest.getAllianceListener() != null) {
            this.mOutRequest.getAllianceListener().onAllianceLoad();
        }
        if (!this.mOutRequest.isShowInterstitialAdByApk() && this.getUseCache() != null) {
            this.getUseCache().show();
        }
    }

    @Override
    protected void setRequest(@NonNull BaseInterstitial baseInterstitial, TAdRequestBody tAdRequestBody) {
        TAdRequestBody tAdRequestBody2 = baseInterstitial.getRequestBody();
        if (tAdRequestBody2 == null) {
            return;
        }
        TAdAllianceListener tAdAllianceListener = tAdRequestBody2.getAllianceListener();
        if (tAdAllianceListener == null) {
            return;
        }
        if (tAdAllianceListener instanceof LoadHandler.WrapTAdAllianceListener) {
            ((LoadHandler.WrapTAdAllianceListener)tAdAllianceListener).setTAdRequestBody(tAdRequestBody);
        }
    }

    @Override
    protected BaseInterstitial buildExecuter(@NonNull Context context, @NonNull NetWork netWork, @NonNull ResponseBody responseBody, int n) {
        return this.b(context, netWork, responseBody);
    }

    @Override
    protected void destoryUseCache(BaseInterstitial baseInterstitial) {
        if (baseInterstitial != null) {
            baseInterstitial.destroyAd();
        }
    }

    @Override
    @NonNull
    protected AdCache<BaseInterstitial> getAdCache() {
        return aq;
    }

    @Override
    public BaseInterstitial getUseCache() {
        BaseInterstitial baseInterstitial = (BaseInterstitial)super.getUseCache();
        if (baseInterstitial != null && !baseInterstitial.isExpired()) {
            return baseInterstitial;
        }
        BaseInterstitial baseInterstitial2 = this.getAdCache().getCache(this.mSlotId);
        if (baseInterstitial2 != null) {
            return baseInterstitial2;
        }
        AdLogUtil.Log().e("InterstitialCacheHandler", "no ad or all ad is expired");
        return baseInterstitial;
    }

    @Override
    protected boolean onPreLoad() {
        this.mUseCache = aq.getCache(this.mSlotId);
        return this.mUseCache != null;
    }

    private BaseInterstitial b(Context context, NetWork netWork, ResponseBody responseBody) {
        Class<? extends BaseInterstitial> clazz;
        BaseInterstitial baseInterstitial = null;
        String string = PlfmExistsUtil.toAdName(netWork.getId());
        HashMap<String, Class<? extends BaseInterstitial>> hashMap = PlfmExistsUtil.getInstance().getInterClassMap();
        if (!TextUtils.isEmpty((CharSequence)string) && (clazz = hashMap.get(string)) != null) {
            Class[] classArray = new Class[]{Context.class, String.class, TrackInfor.class};
            Object[] objectArray = new Object[]{context, netWork.getPmid(), TBaseAd.createTrackInfor(netWork, responseBody, this.mSlotId)};
            try {
                baseInterstitial = clazz.getConstructor(classArray).newInstance(objectArray);
                baseInterstitial.setPriority(netWork.getPriority());
                baseInterstitial.setTtl(netWork.getTtl());
                baseInterstitial.setAdSource(netWork.getId());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return baseInterstitial;
    }
}

