/*
 * Decompiled with CFR 0.152.
 */
package com.zero.mediation.handler.interstial;

import android.support.annotation.NonNull;
import com.zero.common.base.BaseInterstitial;
import com.zero.common.bean.InterceptAdapter;
import com.zero.common.bean.TAdErrorCode;
import com.zero.common.bean.TAdRequestBody;
import com.zero.common.interfacz.TAdAllianceListener;
import com.zero.common.utils.AdLogUtil;
import com.zero.common.widget.WrapTadView;
import com.zero.mediation.bean.NetWork;
import com.zero.mediation.handler.IParalleHandler;
import com.zero.mediation.interfacz.IAdParallel;
import com.zero.mediation.interfacz.IMediationIntersitial;

public class InterstialParalle
implements IParalleHandler<BaseInterstitial>,
IMediationIntersitial {
    private final NetWork ax;
    private String TAG = "InterstialParalle";
    private IAdParallel ay;
    protected WrapTadView mParentView;
    protected String mPlacementId = "";
    protected TAdRequestBody mAdRequestBody;
    private TAdRequestBody at;
    private BaseInterstitial aC = null;

    public InterstialParalle(@NonNull NetWork netWork, IAdParallel iAdParallel) {
        this.ax = netWork;
        this.mPlacementId = netWork.getPmid();
        this.ay = iAdParallel;
    }

    @Override
    public void setRequestBody(TAdRequestBody tAdRequestBody) {
        this.at = tAdRequestBody;
        this.mAdRequestBody = new TAdRequestBody.AdRequestBodyBuild().setAllianceListener(new TAdAllianceListener(){

            public void onAllianceLoad() {
                if (InterstialParalle.this.ay != null) {
                    AdLogUtil.Log().d(InterstialParalle.this.TAG, "Ad load success,plaformId is " + InterstialParalle.this.mPlacementId);
                    InterstialParalle.this.ay.paralleAdBeLoad(InterstialParalle.this.mPlacementId);
                }
            }

            public void onAllianceError(TAdErrorCode tAdErrorCode) {
                InterstialParalle.this.destorySelf();
                if (InterstialParalle.this.ay != null) {
                    if (InterstialParalle.this.ay.paralleAdSizeOut()) {
                        AdLogUtil.Log().e(InterstialParalle.this.TAG, "error count is time out");
                        if (InterstialParalle.this.at != null) {
                            InterstialParalle.this.at.getAllianceListener().onAllianceError(tAdErrorCode);
                        }
                    } else {
                        AdLogUtil.Log().e(InterstialParalle.this.TAG, "count is not out,wait next");
                    }
                }
            }

            public void onShow() {
                if (InterstialParalle.this.at != null) {
                    InterstialParalle.this.at.getAllianceListener().onShow();
                }
            }

            public void onClicked() {
                if (InterstialParalle.this.at != null) {
                    InterstialParalle.this.at.getAllianceListener().onClicked();
                }
            }

            public void onClosed() {
                if (InterstialParalle.this.at != null) {
                    InterstialParalle.this.at.getAllianceListener().onClosed();
                }
            }

            public void onClickIntercept(InterceptAdapter interceptAdapter) {
                if (InterstialParalle.this.at != null) {
                    InterstialParalle.this.at.getAllianceListener().onClickIntercept(interceptAdapter);
                }
            }
        }).showInterstitialAdByApk(this.at != null && this.at.isShowInterstitialAdByApk()).build();
    }

    @Override
    public void loadAd() {
        AdLogUtil.Log().d(this.TAG, "AdFanInterstialParalle start Load");
        this.aC = this.getInterstitial();
        if (this.aC != null) {
            this.aC.setRequestBody(this.mAdRequestBody);
            this.aC.loadAd();
        }
    }

    public BaseInterstitial getInterstitial() {
        return this.aC;
    }

    protected void destorySelf() {
        if (this.aC != null) {
            AdLogUtil.Log().d(this.TAG, "AdFanInterstialParalle destroy self");
            this.aC.destroyAd();
            this.aC = null;
        }
    }

    @Override
    public void show() {
        if (this.isLoaded()) {
            AdLogUtil.Log().d(this.TAG, "AdFanInterstialParalle show");
            this.aC.show();
        }
    }

    @Override
    public boolean isLoaded() {
        return this.aC != null && this.aC.isLoaded();
    }

    @Override
    public void destroyAd() {
        AdLogUtil.Log().d(this.TAG, this.TAG + " destroyAd");
        this.ay = null;
        this.at = null;
        this.destorySelf();
    }

    @Override
    public void onParalleFilterTheBest() {
        if (this.at != null) {
            this.at.getAllianceListener().onAllianceLoad();
            if (this.at != null && !this.at.isShowInterstitialAdByApk()) {
                AdLogUtil.Log().d(this.TAG, "interstitia show by sdk");
                this.show();
            } else {
                AdLogUtil.Log().d(this.TAG, "interstitia show by apk,pls call show");
            }
        }
    }

    @Override
    public NetWork getNetwork() {
        return this.ax;
    }

    @Override
    public void setAllianceExecuter(BaseInterstitial baseInterstitial) {
        this.aC = baseInterstitial;
    }

    public String toString() {
        return "InterstialParalle{netWork=" + this.ax + ", TAG='" + this.TAG + '\'' + ", iadParallel=" + this.ay + ", mParentView=" + this.mParentView + ", mPlacementId='" + this.mPlacementId + '\'' + ", mAdRequestBody=" + this.mAdRequestBody + ", adRequestBody=" + this.at + '}';
    }
}

