/*
 * Decompiled with CFR 0.152.
 */
package com.zero.mediation.handler.interstial;

import com.zero.common.base.BaseInterstitial;
import com.zero.common.bean.InterceptAdapter;
import com.zero.common.bean.TAdErrorCode;
import com.zero.common.bean.TAdRequestBody;
import com.zero.common.interfacz.TAdAllianceListener;
import com.zero.common.utils.AdLogUtil;
import com.zero.mediation.bean.NetWork;
import com.zero.mediation.handler.ISerialHandler;
import com.zero.mediation.interfacz.IMediationIntersitial;

public class InterstialSerial
implements ISerialHandler<BaseInterstitial>,
IMediationIntersitial {
    private String TAG = "InterstialSerial";
    protected InterstialSerial nextHandler;
    protected String mPlacementId = "";
    protected TAdRequestBody mAdRequestBody;
    private TAdRequestBody at;
    private BaseInterstitial aC = null;

    public InterstialSerial(NetWork netWork) {
        this.mPlacementId = netWork.getPmid();
    }

    public InterstialSerial getNextHandler() {
        return this.nextHandler;
    }

    public void setNextHandler(InterstialSerial interstialSerial) {
        this.nextHandler = interstialSerial;
    }

    @Override
    public void show() {
        if (this.aC != null && this.aC.isLoaded()) {
            AdLogUtil.Log().d(this.TAG, this.TAG + " show");
            this.aC.show();
        } else if (this.nextHandler != null) {
            AdLogUtil.Log().d(this.TAG, this.TAG + " use next handle to show");
            this.nextHandler.show();
        }
    }

    @Override
    public boolean isLoaded() {
        if (this.aC != null && this.aC.isLoaded()) {
            AdLogUtil.Log().d(this.TAG, this.TAG + " is loaded");
            return true;
        }
        AdLogUtil.Log().d(this.TAG, this.TAG + " check next loaded status");
        return this.nextHandler != null && this.nextHandler.isLoaded();
    }

    @Override
    public void setRequestBody(TAdRequestBody tAdRequestBody) {
        this.at = tAdRequestBody;
        this.mAdRequestBody = new TAdRequestBody.AdRequestBodyBuild().setAllianceListener(new TAdAllianceListener(){

            public void onAllianceError(TAdErrorCode tAdErrorCode) {
                InterstialSerial.this.destroySelf();
                if (InterstialSerial.this.nextHandler != null) {
                    AdLogUtil.Log().d(InterstialSerial.this.TAG, "load error, next");
                    InterstialSerial.this.nextHandler.loadAd();
                } else if (InterstialSerial.this.at != null) {
                    InterstialSerial.this.at.getAllianceListener().onAllianceError(tAdErrorCode);
                }
            }

            public void onAllianceLoad() {
                if (InterstialSerial.this.at != null) {
                    InterstialSerial.this.at.getAllianceListener().onAllianceLoad();
                    if (InterstialSerial.this.at != null && !InterstialSerial.this.at.isShowInterstitialAdByApk()) {
                        AdLogUtil.Log().d(InterstialSerial.this.TAG, "interstitia show by sdk");
                        InterstialSerial.this.show();
                    } else {
                        AdLogUtil.Log().d(InterstialSerial.this.TAG, "interstitia show by apk,pls call show");
                    }
                }
            }

            public void onShow() {
                if (InterstialSerial.this.at != null) {
                    InterstialSerial.this.at.getAllianceListener().onShow();
                }
            }

            public void onClicked() {
                if (InterstialSerial.this.at != null) {
                    InterstialSerial.this.at.getAllianceListener().onClicked();
                }
            }

            public void onClosed() {
                if (InterstialSerial.this.at != null) {
                    InterstialSerial.this.at.getAllianceListener().onClosed();
                }
            }

            public void onClickIntercept(InterceptAdapter interceptAdapter) {
                if (InterstialSerial.this.at != null) {
                    InterstialSerial.this.at.getAllianceListener().onClickIntercept(interceptAdapter);
                }
            }
        }).showInterstitialAdByApk(this.at != null && this.at.isShowInterstitialAdByApk()).build();
    }

    @Override
    public void loadAd() {
        AdLogUtil.Log().d(this.TAG, "FanBannerHandler start Load");
        this.aC = this.getInterstitial();
        if (this.aC != null) {
            this.aC.setRequestBody(this.mAdRequestBody);
            this.aC.loadAd();
        }
    }

    public BaseInterstitial getInterstitial() {
        return this.aC;
    }

    protected void destroySelf() {
        if (this.aC != null) {
            AdLogUtil.Log().d(this.TAG, "IntersitialSerial destroy self");
            this.aC.destroyAd();
            this.aC = null;
        }
    }

    @Override
    public void destroyAd() {
        this.at = null;
        if (this.nextHandler != null) {
            AdLogUtil.Log().d(this.TAG, this.TAG + " destroy");
            this.nextHandler.destroyAd();
            this.nextHandler = null;
        }
        this.destroySelf();
    }

    @Override
    public void setAllianceExecuter(BaseInterstitial baseInterstitial) {
        this.aC = baseInterstitial;
    }

    public String toString() {
        return "InterstialSerial{TAG='" + this.TAG + '\'' + ", nextHandler=" + this.nextHandler + ", mPlacementId='" + this.mPlacementId + '\'' + ", mAdRequestBody=" + this.mAdRequestBody + ", adRequestBody=" + this.at + ", mInterstitial=" + this.aC + '}';
    }
}

